/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.lift;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataDisplay;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.Reloadable;
import oracle.dmt.dataminer.controls.renderers.ColorCellRenderer;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.TestResultsSelectorPanel;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.TestViewerPartitionToolbar;
import oracle.dmt.dataminer.tviewer.lift.LiftDetailPanel;
import oracle.dmt.dataminer.tviewer.lift.LiftEditor;
import oracle.dmt.dataminer.tviewer.lift.LiftTabState;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class LiftPanel
extends DataMinerViewGUI
implements GraphDataDisplay,
Reloadable {
    private GraphPanel _graphPanel;
    private LiftTabState _state;
    private boolean _loading;
    private DataMinerTablePanel dataMinerTablePanel;
    private JPanel displayPanel;
    private JComboBox<String> jDisplayCombo;
    private JLabel jDisplayLbl;
    private JPanel jGraphControl;
    private JPanel jGraphPanel;
    private JPanel jPanel;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JSlider jQuantileSlider;
    private JSplitPane jSplitPane;
    private JComboBox<String> jTargetComb;
    private JLabel jTargetLbl;
    private TestViewerPartitionToolbar partitionToolbar;
    private JButton jDetailBtn;
    private JButton jAddOrRemoveBtn;

    public LiftPanel(LiftEditor liftEditor, Context context) {
        super(liftEditor, context);
        this._state = new LiftTabState(liftEditor.getCachedLegendState());
        this.initComponents();
        this.initGraph();
        this.initRes();
        this.initUI();
    }

    public void updateSelectedPartition() {
        String string = this.partitionToolbar.getSelectedPartitionID();
        LiftEditor liftEditor = (LiftEditor)this.getEditor();
        liftEditor.getCachedLegendState().setSelectedPartition(string);
    }

    public String getSelectedPartition() {
        return this.partitionToolbar.getSelectedPartitionID();
    }

    private void initGraph() {
        this._graphPanel = new GraphPanel(this, new DefaultGraphDataModel(null, null, null, null, null));
        this.jGraphPanel.add((Component)new JTextArea(CommonLrb.get("LOADING")), "Center");
        this.jGraphPanel.updateUI();
    }

    private void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLbl, this.jTargetComb, (String)TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleName(TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("TARGET_VALUE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jDisplayLbl, this.jDisplayCombo, (String)TestViewerLrb.get("DISPLAY_OPTION"));
        this.jDisplayLbl.getAccessibleContext().setAccessibleName(TestViewerLrb.get("DISPLAY_OPTION"));
        this.jDisplayLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("DISPLAY_OPTION_ADA"));
    }

    private void initUI() {
        this.jDisplayCombo.addActionListener(new DisplayComboActionListener());
        this.jTargetComb.addActionListener(new TargetComboActionListener());
        this.jQuantileSlider.addChangeListener(new QuantileChangeListener());
        this.dataMinerTablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int[] nArray = LiftPanel.this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
                    String string = (String)LiftPanel.this._state.getLiftTableModel().getValueAt(nArray[0], LiftPanel.this._state.getRESULT_NAME());
                    LiftDetailPanel liftDetailPanel = new LiftDetailPanel(LiftPanel.this.getContext(), string, LiftPanel.this._state.getLiftData().get(string), LiftPanel.this.getSelectedPartition());
                    liftDetailPanel.showAsDialog(LiftPanel.this);
                }
            }
        });
        this.installLiftResultsActions();
        this.dataMinerTablePanel.setTitle(CommonLrb.get("MODELS"));
        this.initializeControls();
        this.jSplitPane.setDividerLocation(0.75);
        this.jSplitPane.setResizeWeight(0.75);
    }

    @Override
    public void load() {
        LoadWorker loadWorker = new LoadWorker();
        loadWorker.execute();
    }

    @Override
    public void reload() {
        LiftEditor liftEditor = (LiftEditor)this.getEditor();
        this._state = new LiftTabState(liftEditor.getCachedLegendState());
        this.setContext(liftEditor.getContext());
        this._state.setSelectedTargetValue((String)this.jTargetComb.getSelectedItem());
        this.load();
    }

    private void initializeControls() {
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)this._state.getLoadingLiftTableModel()));
        this.dataMinerTablePanel.getTable().setSelectionMode(0);
        this.jDisplayCombo.setModel(new DefaultComboBoxModel<String>(new String[]{TestViewerLrb.get("DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES"), TestViewerLrb.get("DISPLAY_OPTION_CUMULATIVE_LIFT")}));
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{CommonLrb.get("LOADING")}));
        ListSelectionModel listSelectionModel = this.dataMinerTablePanel.getTable().getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LiftPanel.this.jResultTableValueChanged(listSelectionEvent);
            }
        });
    }

    public void jResultTableValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            String string = (String)this._state.getLiftTableModel().getValueAt(nArray[0], this._state.getRESULT_NAME());
            this._state.setSelectedTestResult(string);
        }
    }

    public LiftTabState.LiftData getLiftData() {
        String string = this._state.getSelectedTestResult();
        if (string == null) {
            int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            if (nArray.length > 0 && -1 != nArray[0]) {
                string = (String)this._state.getLiftTableModel().getValueAt(nArray[0], this._state.getRESULT_NAME());
                this._state.setSelectedTestResult(string);
            }
            if (string == null) {
                return null;
            }
        }
        int n = this._state.getSelectedQuantileValue();
        LiftTabState.LiftData liftData = new LiftTabState.LiftData(this._state.getLiftData().get(string).get(n));
        liftData.setLabel(string);
        return liftData;
    }

    private void initComponents() {
        this.partitionToolbar = new TestViewerPartitionToolbar();
        this.jSplitPane = new JSplitPane();
        this.jPanel = new JPanel();
        this.jGraphPanel = new JPanel();
        this.jGraphControl = new JPanel();
        this.jQuantileSlider = new JSlider();
        this.jPanel1 = new JPanel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.displayPanel = new JPanel();
        this.jDisplayLbl = new JLabel();
        this.jPanel3 = new JPanel();
        this.jDisplayCombo = new JComboBox();
        this.jTargetLbl = new JLabel();
        this.jTargetComb = new JComboBox();
        this.jSplitPane.setDividerLocation(400);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setOneTouchExpandable(true);
        this.jGraphPanel.setLayout(new BorderLayout());
        this.jGraphControl.setLayout(new GridBagLayout());
        this.jQuantileSlider.setName("jQuantileSlider");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 45, 0, 0);
        this.jGraphControl.add((Component)this.jQuantileSlider, gridBagConstraints);
        GroupLayout groupLayout = new GroupLayout(this.jPanel);
        this.jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jGraphControl, -1, 652, Short.MAX_VALUE).addComponent(this.jGraphPanel, -1, 652, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jGraphPanel, -1, 348, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jGraphControl, -2, -1, -2)));
        this.jSplitPane.setTopComponent(this.jPanel);
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, GroupLayout.Alignment.TRAILING, -1, 652, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, 91, Short.MAX_VALUE));
        this.jSplitPane.setBottomComponent(this.jPanel1);
        this.displayPanel.setLayout(new FlowLayout(0, 0, 0));
        this.jDisplayLbl.setText("Display:");
        this.displayPanel.add(this.jDisplayLbl);
        this.jPanel3.setLayout(new FlowLayout(0, 12, 0));
        this.jDisplayCombo.setMinimumSize(new Dimension(0, 0));
        this.jPanel3.add(this.jDisplayCombo);
        this.jTargetLbl.setHorizontalAlignment(4);
        this.jTargetLbl.setText("Target Value:");
        this.jPanel3.add(this.jTargetLbl);
        this.jTargetComb.setMinimumSize(new Dimension(0, 0));
        this.jTargetComb.setPreferredSize(new Dimension(170, 23));
        this.jPanel3.add(this.jTargetComb);
        this.displayPanel.add(this.jPanel3);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, -1, 698, Short.MAX_VALUE).addComponent(this.partitionToolbar, -1, -1, Short.MAX_VALUE).addComponent(this.displayPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.partitionToolbar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.displayPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane).addContainerGap()));
    }

    private void installLiftResultsActions() {
        this.dataMinerTablePanel.removeSearchField();
        this.jDetailBtn = new JButton(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.setDisabledIcon(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.setToolTipText(TestViewerLrb.get("LIFT_DETAIL_DIALOG"));
        this.jDetailBtn.addActionListener(new DetailButtonActionListener());
        if (this._state.getParentTestViewerState().getAllTestResults().size() > 1) {
            this.jAddOrRemoveBtn = new JButton(OracleIcons.getIcon((String)"compare.png"));
            this.jAddOrRemoveBtn.setDisabledIcon(OracleIcons.getIcon((String)"compare.png"));
            this.jAddOrRemoveBtn.setToolTipText(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TITLE"));
            this.jAddOrRemoveBtn.addActionListener(new AddOrRemoveButtonActionListener());
            this.dataMinerTablePanel.addControlBarComponents(this.jDetailBtn, this.jAddOrRemoveBtn);
        } else {
            this.dataMinerTablePanel.addControlBarComponents(this.jDetailBtn);
        }
    }

    public Object getCachedPropertyState() {
        return this._state;
    }

    @Override
    public void showData(Object object) {
        this.showDetail();
    }

    private void showDetail() {
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        String string = (String)this._state.getLiftTableModel().getValueAt(nArray[0], this._state.getRESULT_NAME());
        LiftDetailPanel liftDetailPanel = new LiftDetailPanel(this.getContext(), string, this._state.getLiftData().get(string), this.getSelectedPartition());
        liftDetailPanel.showAsDialog(this);
    }

    private void setupGraphPanel() {
        this.jGraphPanel.removeAll();
        this.jGraphPanel.add((Component)this._graphPanel, "Center");
        this.jGraphPanel.updateUI();
    }

    private void setupModelsTable() {
        this.dataMinerTablePanel.getTable().setFixedColumns(1, 165);
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)this._state.getLiftTableModel()));
        this.dataMinerTablePanel.getTable().setAutoResizeMode(0);
        this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
        this.dataMinerTablePanel.getTable().setSorted(true);
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getFullColumnModel();
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getModelViewerNumericRenderer();
        TableCellRenderer tableCellRenderer2 = FormatTableCellRenderer.getModelViewerPercentRenderer();
        TableCellRenderer tableCellRenderer3 = FormatTableCellRenderer.getDateRenderer();
        ColorCellRenderer colorCellRenderer = new ColorCellRenderer(new ColorCellRenderer.ColorChooser(){

            @Override
            public Color getColorFor(Object object) {
                String string = (String)object;
                return LiftPanel.this._state.getParentTestViewerState().getTestResultGraphColor(string);
            }
        });
        tableColumnModel.getColumn(this._state.getRESULT_NAME()).setCellRenderer(colorCellRenderer);
        tableColumnModel.getColumn(this._state.getLIFT_CUMULATIVE()).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(this._state.getGAIN_CUMULATIVE()).setCellRenderer(tableCellRenderer2);
        tableColumnModel.getColumn(this._state.getPERCENTAGE_RECORDS_CUMULATIVE()).setCellRenderer(tableCellRenderer2);
        tableColumnModel.getColumn(this._state.getTARGET_DENSITY_CUMULATIVE()).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(this._state.getCREATION_DATE()).setCellRenderer(tableCellRenderer3);
        this.dataMinerTablePanel.getTable().autoSizeColumnsToFit();
    }

    private void updateSelectedModel() {
        String string = this._state.getSelectedTestResult();
        int n = 0;
        if (string == null) {
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                Double d3;
                if (this._state.getSelectedDisplayOption().equals("DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES")) {
                    d3 = (Double)this._state.getLiftTableModel().getValueAt(i, this._state.getTARGET_DENSITY_CUMULATIVE());
                    d = d3 != null ? d3 : 0.0;
                } else {
                    d3 = (Double)this._state.getLiftTableModel().getValueAt(i, this._state.getLIFT_CUMULATIVE());
                    double d4 = d = d3 != null ? d3 : 0.0;
                }
                if (!(d2 < d)) continue;
                d2 = d;
                n = i;
            }
        } else {
            for (int i = 0; i < this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                Object object = this._state.getLiftTableModel().getValueAt(i, this._state.getRESULT_NAME());
                if (!string.equals(object)) continue;
                n = i;
            }
        }
        this.dataMinerTablePanel.getTable().setRowSelectionInterval(n, n);
    }

    private class AddOrRemoveButtonActionListener
    implements ActionListener {
        private AddOrRemoveButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TestResultsSelectorPanel testResultsSelectorPanel = new TestResultsSelectorPanel(LiftPanel.this.getContext(), LiftPanel.this._state.getParentTestViewerState());
            if (testResultsSelectorPanel.showAsDialog(LiftPanel.this)) {
                List<TestResult> list = testResultsSelectorPanel.getSelectedTestResults();
                LiftPanel.this._state.getParentTestViewerState().setTestResults(list);
                LiftPanel.this.jGraphPanel.removeAll();
                LiftPanel.this.jGraphPanel.add((Component)new JTextArea(CommonLrb.get("LOADING")), "Center");
                LiftPanel.this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)LiftPanel.this._state.getLoadingLiftTableModel()));
                LoadWorker loadWorker = new LoadWorker();
                loadWorker.execute();
            }
        }
    }

    private class DetailButtonActionListener
    implements ActionListener {
        private DetailButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LiftPanel.this.showDetail();
        }
    }

    private class QuantileChangeListener
    implements ChangeListener {
        private QuantileChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (LiftPanel.this._loading) {
                return;
            }
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (jSlider.getValueIsAdjusting()) {
                return;
            }
            this.updateThreshold();
        }

        private void updateThreshold() {
            BoundedRangeModel boundedRangeModel = LiftPanel.this.jQuantileSlider.getModel();
            Integer n = boundedRangeModel.getValue();
            n = Math.max(1, n);
            LiftPanel.this._state.setSelectedQuantileValue(n);
            UpdateThresholdWorker updateThresholdWorker = new UpdateThresholdWorker();
            updateThresholdWorker.execute();
        }
    }

    private class TargetComboActionListener
    implements ActionListener {
        private TargetComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (LiftPanel.this._loading) {
                return;
            }
            LiftPanel.this._state.setSelectedTargetValue((String)LiftPanel.this.jTargetComb.getSelectedItem());
            LiftPanel.this.jGraphPanel.removeAll();
            LiftPanel.this.jGraphPanel.add((Component)new JTextArea(CommonLrb.get("LOADING")), "Center");
            LiftPanel.this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)LiftPanel.this._state.getLoadingLiftTableModel()));
            UpdateGraphWorker updateGraphWorker = new UpdateGraphWorker();
            updateGraphWorker.execute();
        }
    }

    private class DisplayComboActionListener
    implements ActionListener {
        private DisplayComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (LiftPanel.this._loading) {
                return;
            }
            String string = (String)LiftPanel.this.jDisplayCombo.getSelectedItem();
            if (string.equals(TestViewerLrb.get("DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES"))) {
                LiftPanel.this._state.setSelectedDisplayOption("DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES");
            } else {
                LiftPanel.this._state.setSelectedDisplayOption("DISPLAY_OPTION_CUMULATIVE_LIFT");
            }
            LiftPanel.this.jGraphPanel.removeAll();
            LiftPanel.this.jGraphPanel.add((Component)new JTextArea(CommonLrb.get("LOADING")), "Center");
            LiftPanel.this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)LiftPanel.this._state.getLoadingLiftTableModel()));
            UpdateGraphWorker updateGraphWorker = new UpdateGraphWorker();
            updateGraphWorker.execute();
        }
    }

    private class UpdateThresholdWorker
    extends ODMrSwingWorker<Void, Void> {
        private UpdateThresholdWorker() {
            super(LiftPanel.this);
        }

        @Override
        protected Void doInBackground() throws Exception {
            LiftPanel.this._state.refreshCustomThresholdData();
            LiftPanel.this._graphPanel.refreshGraph();
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            LiftPanel.this.dataMinerTablePanel.getTable().repaint();
            LiftPanel.this.updateSelectedModel();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(LiftPanel.this.getEditor().getContext(), throwable, TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
        }
    }

    private class UpdateGraphWorker
    extends ODMrSwingWorker<Void, Void> {
        private UpdateGraphWorker() {
            super(LiftPanel.this, LiftPanel.this.overLayPanel);
            LiftPanel.this._loading = true;
        }

        @Override
        protected Void doInBackground() throws Exception {
            LiftPanel.this._state.refreshLiftData(LiftPanel.this.partitionToolbar.getCompareMode());
            LiftPanel.this._graphPanel.initGraph(LiftPanel.this._state.getLiftGraphModel());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            LiftPanel.this.setupGraphPanel();
            LiftPanel.this.setupModelsTable();
            LiftPanel.this.updateSelectedModel();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(LiftPanel.this.getEditor().getContext(), throwable, TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            LiftPanel.this._loading = false;
        }
    }

    private class LoadWorker
    extends ODMrSwingWorker<Void, Void> {
        private LoadWorker() {
            super(LiftPanel.this, LiftPanel.this.overLayPanel);
            LiftPanel.this._loading = true;
        }

        @Override
        protected Void doInBackground() throws Exception {
            LiftPanel.this.partitionToolbar.load(LiftPanel.this.getEditor());
            LiftPanel.this.updateSelectedPartition();
            LiftPanel.this._state.load(LiftPanel.this.partitionToolbar.getCompareMode());
            LiftPanel.this._graphPanel.initGraph(LiftPanel.this._state.getLiftGraphModel());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            LiftPanel.this.setupGraphPanel();
            LiftPanel.this.setupModelsTable();
            LiftPanel.this.updateSelectedModel();
            LiftPanel.this.jTargetComb.setModel(new DefaultComboBoxModel<String>(LiftPanel.this._state.getTargetValues().toArray(new String[LiftPanel.this._state.getTargetValues().size()])));
            LiftPanel.this.jTargetComb.setSelectedItem(LiftPanel.this._state.getSelectedTargetValue());
            Integer n = LiftPanel.this._state.getSelectedQuantileValue();
            Integer n2 = 0;
            Integer n3 = LiftPanel.this._state.getMaxQuantileCnt() - 1;
            LiftPanel.this.jQuantileSlider.setMajorTickSpacing(10);
            LiftPanel.this.jQuantileSlider.setMinorTickSpacing(1);
            LiftPanel.this.jQuantileSlider.setPaintTicks(true);
            LiftPanel.this.jQuantileSlider.setPaintLabels(true);
            LiftPanel.this.jQuantileSlider.setSnapToTicks(true);
            LiftPanel.this.jQuantileSlider.setModel(new DefaultBoundedRangeModel(n, 0, n2, n3));
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(LiftPanel.this.getEditor().getContext(), throwable, TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            LiftPanel.this._loading = false;
        }
    }
}

