/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.sql;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.navigator.DataNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.teditor.sql.SQLEditorLrb;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.TextComponentSearchSupport;

public class SQLViewerPanel
extends DataMinerViewGUI {
    private ControlBar controlBar;
    private ComponentWithTitlebar<JComponent> jComponentWithToolbar;
    private JTextPane jSQLTextArea;
    private JScrollPane jScrollPane;
    private SearchField searchField;

    public SQLViewerPanel(Editor editor, Context context) {
        super(editor, context);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.jSQLTextArea = new JTextPane();
        this.controlBar = new ControlBar();
        this.searchField = new SearchField();
        this.jComponentWithToolbar = new ComponentWithTitlebar();
        this.jScrollPane.setViewportView(this.jSQLTextArea);
        this.searchField.setPreferredSize(new Dimension(200, 21));
        this.jComponentWithToolbar.setComponent((JComponent)this.jScrollPane);
        this.jComponentWithToolbar.setControlBar(this.controlBar);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jComponentWithToolbar, -1, 512, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jComponentWithToolbar, -1, 364, Short.MAX_VALUE).addContainerGap()));
    }

    private void initUI() {
        final TextComponentSearchSupport textComponentSearchSupport = new TextComponentSearchSupport((JTextComponent)this.jSQLTextArea);
        this.jSQLTextArea.setText(CommonLrb.get("LOADING"));
        this.jSQLTextArea.setEditable(false);
        this.jComponentWithToolbar.setLabel(new JLabel(SQLEditorLrb.get("SQL_VIEWER_TEXT_AREA_TITLE")));
        this.searchField.setStyle(SearchField.Style.FIND);
        this.searchField.setPrompt(CoreCommonLrb.get((String)"FIND"));
        this.searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                SearchEvent.Direction direction = searchEvent.getDirection();
                String string = searchEvent.getSearchText();
                textComponentSearchSupport.search(direction, string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        this.controlBar.add((Component)this.searchField);
    }

    @Override
    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    @Override
    public HelpInfo getHelpInfo() {
        String string = "dm_datasourceviewer_sql";
        return new HelpInfo(string);
    }

    private String getStackedSQL() {
        DataNode dataNode = (DataNode)this.getContext().getNode();
        WorkflowNode workflowNode = (WorkflowNode)dataNode.getParent().getAncestor(WorkflowNode.class);
        WorkflowModel workflowModel = workflowNode.getWorkflowModel();
        if (workflowModel == null) {
            return "";
        }
        DataNodeType dataNodeType = (DataNodeType)dataNode.getRepositoryData();
        AbstractDataNode abstractDataNode = (AbstractDataNode)workflowModel.findNodeByMetadataId(dataNodeType.getId());
        if (abstractDataNode == null) {
            return "";
        }
        return abstractDataNode.getStackedSQL(workflowModel, true);
    }

    private class LoadUI
    extends ODMrSwingWorker<String, Void> {
        private LoadUI() {
            super(SQLViewerPanel.this, SQLViewerPanel.this.overLayPanel);
            SQLViewerPanel.this.setLoading(true);
        }

        @Override
        protected String doInBackground() throws Exception {
            String string = SQLViewerPanel.this.getStackedSQL();
            return string;
        }

        @Override
        protected void onSuccess(String string) throws Exception {
            SQLViewerPanel.this.jSQLTextArea.setText(string);
            SQLViewerPanel.this.jSQLTextArea.setCaretPosition(SQLViewerPanel.this.jSQLTextArea.getDocument().getLength());
            SQLViewerPanel.this.jSQLTextArea.moveCaretPosition(0);
            SQLViewerPanel.this.jSQLTextArea.select(0, 0);
            SQLViewerPanel.this.setLoaded(true);
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(SQLViewerPanel.this.getEditor().getContext(), throwable, SQLEditorLrb.get("SQL_VIEWER_FAILURE_TITLE"), SQLEditorLrb.get("SQL_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            SQLViewerPanel.this.setLoading(false);
        }
    }
}

