/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BinGeneration;
import oracle.dmt.dataminer.workflow.xmlschema.BinningSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressRunnable;

class NumericalBinningWorker
extends ProgressRunnable {
    private boolean _canceled;
    private Vector<NameValuePair> values = null;
    private Context context;
    private AttributeType binnedAttribute;
    private BinningSettingsType binningSettings;
    public static final int DEFAULT_TOPN = 10;

    public NumericalBinningWorker(Context context, AttributeType attributeType, BinningSettingsType binningSettingsType) {
        this.context = context;
        this.binnedAttribute = attributeType;
        this.binningSettings = binningSettingsType;
    }

    public Vector<NameValuePair> getValues() {
        return this.values;
    }

    public Object doWork() throws Exception {
        BaseTreeNode baseTreeNode = (BaseTreeNode)this.context.getNode();
        WorkflowNode workflowNode = (WorkflowNode)baseTreeNode.getParent().getAncestor(WorkflowNode.class);
        WorkflowModel workflowModel = workflowNode.getWorkflowModel();
        if (workflowModel == null) {
            return null;
        }
        String string = GraphUtils.getSampleTableName(this.context);
        try {
            TransformationType.Binning binning = new TransformationType.Binning();
            TransformationType.Binning.EqualWidth equalWidth = new TransformationType.Binning.EqualWidth();
            BinGeneration binGeneration = new BinGeneration();
            binGeneration.setAuto(new BinGeneration.Auto());
            equalWidth.setBinCount(this.binningSettings.getNumericBinCount());
            equalWidth.setBinGeneration(binGeneration);
            binning.setEqualWidth(equalWidth);
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.context);
            this.values = TransformationStatisticsState.generateDefaultBins(connectionFolder, "select * from " + string, this.binnedAttribute.getName(), this.binnedAttribute.getDataType(), binning);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected void finish(Object object) {
    }

    protected void doCancel() {
        super.doCancel();
        this._canceled = true;
    }

    public boolean isCanceled() {
        return this._canceled;
    }
}

