/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.teditor.graph.BinClausesInfo;
import oracle.dmt.dataminer.teditor.graph.GraphLoader;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.teditor.graph.GraphPreferences;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BinningSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.BinningType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphType;
import oracle.ide.Context;
import oracle.javatools.util.Pair;

abstract class GraphQueryBuilder {
    protected Context context;
    protected String query;
    protected boolean showGroupByNulls;
    protected boolean showXNulls;
    protected boolean isGroupByEnabled;
    protected boolean isMultiSeries;
    protected boolean isSingleSeries;
    protected GraphType graphType;
    protected List<AttributeType> binningAttributes = new ArrayList<AttributeType>();
    protected List<BinningSettingsType> attributeBinningSettings = new ArrayList<BinningSettingsType>();
    protected String allBinsClause = "";
    protected BinningSettingsType xBinningSettings;
    protected List<String> catBinValues;
    protected AttributeType xattribute;
    protected String xAttributeName;
    protected String yAttributeName;
    protected String yAxisLabel;
    protected AttributeType yattribute;
    protected String aggfnc;
    protected List<AttributeType> yattributes;
    protected BinningSettingsType gbinningSettings;
    protected List<String> gcatBinValues;
    protected String gAttributeName;
    protected AttributeType gattribute;
    protected String groupingClause = "";
    protected String emptyGBinClause = "";
    protected String fqCacheTableName;
    protected String fqGAttributeName;
    protected String qGAttributeName;
    protected String fqXAttributeName;
    protected String qXAttributeName;
    protected String qYAttributeName;
    protected List<String> columnTitles = new ArrayList<String>();

    public abstract String buildGraphQuery() throws Exception;

    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public String getYAttributeName() {
        return this.yAttributeName;
    }

    public List<String> getColumnTitles() {
        return this.columnTitles;
    }

    protected static GraphQueryBuilder getQueryGraphBuilder(Class<?> clazz, Context context, String string, GraphSettingsType graphSettingsType, GraphPreferences graphPreferences) throws Exception {
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Object obj = constructor.newInstance(new Object[0]);
        if (!(obj instanceof GraphQueryBuilder)) {
            throw new RuntimeException("Unexpected Graph Query Builder type");
        }
        if (graphSettingsType.getXAttribute().getStatus().equals((Object)AttributeStatus.INVALID)) {
            throw new GraphLoader.InvalidAttributeException(GraphLrb.get("INVALID_INPUTS_PRESENT"));
        }
        for (AttributeType attributeType : graphSettingsType.getYAttributes().getYAttribute()) {
            if (!attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
            throw new GraphLoader.InvalidAttributeException(GraphLrb.get("INVALID_INPUTS_PRESENT"));
        }
        if (graphSettingsType.getGroupByOption().isGroupByEnabled() && graphSettingsType.getGroupByOption().getGroupByAttribute().getStatus().equals((Object)AttributeStatus.INVALID)) {
            throw new GraphLoader.InvalidAttributeException(GraphLrb.get("INVALID_INPUTS_PRESENT"));
        }
        GraphQueryBuilder graphQueryBuilder = (GraphQueryBuilder)obj;
        graphQueryBuilder.graphType = graphSettingsType.getType();
        graphQueryBuilder.context = context;
        graphQueryBuilder.showGroupByNulls = graphPreferences.isShowGroupByNullsBin();
        graphQueryBuilder.showXNulls = graphPreferences.isShowGroupByNullsBin();
        graphQueryBuilder.xBinningSettings = graphSettingsType.getXBinningSettings();
        graphQueryBuilder.catBinValues = GraphUtils.getCategoricalBinValues(graphQueryBuilder.xBinningSettings);
        graphQueryBuilder.xattribute = graphSettingsType.getXAttribute();
        graphQueryBuilder.xAttributeName = graphQueryBuilder.xattribute.getName();
        graphQueryBuilder.yattributes = graphSettingsType.getYAttributes().getYAttribute();
        graphQueryBuilder.yattribute = graphQueryBuilder.yattributes.size() == 0 ? null : (AttributeType)graphSettingsType.getYAttributes().getYAttribute().get(0);
        graphQueryBuilder.aggfnc = GraphUtils.getSQLAggregationFunctionClause(graphSettingsType.getYAttributes().getAggregationFunction());
        graphQueryBuilder.isGroupByEnabled = graphSettingsType.getGroupByOption().isGroupByEnabled();
        graphQueryBuilder.gbinningSettings = graphSettingsType.getGroupByOption().getBinningSettings();
        graphQueryBuilder.gcatBinValues = GraphUtils.getCategoricalBinValues(graphQueryBuilder.gbinningSettings);
        graphQueryBuilder.gAttributeName = graphSettingsType.getGroupByOption().isGroupByEnabled() ? graphSettingsType.getGroupByOption().getGroupByAttribute().getName() : "";
        graphQueryBuilder.gattribute = graphSettingsType.getGroupByOption().getGroupByAttribute();
        graphQueryBuilder.isSingleSeries = GraphUtils.isSingleSeriesGraph(graphSettingsType.getType());
        boolean bl = graphQueryBuilder.isMultiSeries = graphSettingsType.getYAttributes().getYAttribute().size() > 1;
        if (!graphQueryBuilder.xBinningSettings.getBinningKind().equals((Object)BinningType.NONE)) {
            graphQueryBuilder.binningAttributes.add(graphQueryBuilder.xattribute);
            graphQueryBuilder.attributeBinningSettings.add(graphQueryBuilder.xBinningSettings);
        }
        if (graphSettingsType.getGroupByOption().isGroupByEnabled() && !graphQueryBuilder.gbinningSettings.getBinningKind().equals((Object)BinningType.NONE)) {
            graphQueryBuilder.binningAttributes.add(graphQueryBuilder.gattribute);
            graphQueryBuilder.attributeBinningSettings.add(graphQueryBuilder.gbinningSettings);
        }
        graphQueryBuilder.fqCacheTableName = "";
        graphQueryBuilder.fqGAttributeName = "";
        graphQueryBuilder.qGAttributeName = "";
        graphQueryBuilder.fqXAttributeName = "";
        graphQueryBuilder.qXAttributeName = "";
        graphQueryBuilder.qYAttributeName = "";
        graphQueryBuilder.fqCacheTableName = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(string));
        if (graphQueryBuilder.isGroupByEnabled) {
            graphQueryBuilder.fqGAttributeName = StringUtils.createFullyQualifiedName(graphQueryBuilder.fqCacheTableName, StringUtils.addDoubleQuotes(StringUtils.processQuotedName(graphQueryBuilder.gAttributeName)));
            graphQueryBuilder.qGAttributeName = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(graphQueryBuilder.gAttributeName));
        }
        graphQueryBuilder.fqXAttributeName = StringUtils.createFullyQualifiedName(graphQueryBuilder.fqCacheTableName, StringUtils.addDoubleQuotes(StringUtils.processQuotedName(graphQueryBuilder.xAttributeName)));
        graphQueryBuilder.qXAttributeName = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(graphQueryBuilder.xAttributeName));
        if (graphQueryBuilder.yattribute != null) {
            graphQueryBuilder.qYAttributeName = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(graphQueryBuilder.yattribute.getName()));
        }
        return graphQueryBuilder;
    }

    protected BinClausesInfo getNumBinClauses(List<NameValuePair> list, String string, AttributeType attributeType, String object, boolean bl, boolean bl2) {
        Object object2 = bl ? " case " : "";
        String string2 = attributeType.getName();
        String string3 = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(string2));
        String string4 = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(string));
        Object object3 = " case ";
        Object object4 = ", EMPTY_BINS as (";
        String string5 = "  <gcomma>\n<gattr> ";
        int n = 1;
        if (object == null || ((String)object).length() == 0) {
            object = "";
        } else {
            object = "'" + (String)object + "'";
            string5 = "<gcomma>\nNVL(BINNED_DATA.<gattr>, EMPTY_BINS.<gattr>) <gattr>";
        }
        boolean bl3 = false;
        boolean bl4 = false;
        NameValuePair nameValuePair = list.get(0);
        String string6 = (String)nameValuePair.getValue();
        if ("eqw".equals(string6)) {
            bl3 = false;
        } else if ("lowcard".equals(string6)) {
            bl3 = true;
        } else if (DatabaseMetadataUtils.isDateType(attributeType.getDataType())) {
            bl4 = true;
        } else {
            throw new RuntimeException("Binning qualifier paramter is missing");
        }
        if (!bl4) {
            list.remove(0);
        }
        for (int i = 0; i < list.size(); ++i) {
            String string7 = (String)list.get(i).getValue();
            String string8 = bl4 ? GraphUtils.getDateConversionClause(attributeType.getDataType(), string7) : string7;
            String string9 = null;
            String string10 = null;
            if (!bl3) {
                if (i == 0) {
                    string9 = " '<uppername>'";
                    string9 = StringUtils.getReplacedString(string9, "<uppername>", "<= <upper>");
                    string9 = StringUtils.getReplacedString(string9, "<upper>", string7);
                    object2 = (String)object2 + " when <attrname> <= <upper> then <binId>\n";
                    object2 = StringUtils.getReplacedString((String)object2, "<attrname>", string3);
                    object2 = StringUtils.getReplacedString((String)object2, "<upper>", string8);
                    object2 = StringUtils.getReplacedString((String)object2, "<binId>", Integer.toString(n));
                    object3 = (String)object3 + " when <attrname> <= <upper> then <binName>\n";
                    object3 = StringUtils.getReplacedString((String)object3, "<attrname>", string3);
                    object3 = StringUtils.getReplacedString((String)object3, "<upper>", string8);
                    object3 = StringUtils.getReplacedString((String)object3, "<binName>", string9);
                } else {
                    String string11 = (String)list.get(i - 1).getValue();
                    String string12 = bl4 ? GraphUtils.getDateConversionClause(attributeType.getDataType(), string11) : string11;
                    string9 = " '<lower>-<upper>'";
                    string9 = StringUtils.getReplacedString(string9, "<upper>", string7);
                    string9 = StringUtils.getReplacedString(string9, "<lower>", string11);
                    object2 = (String)object2 + " when <attrname> <= <upper> and <attrname> > <lower> then <binId>\n";
                    object2 = StringUtils.getReplacedString((String)object2, "<attrname>", string3);
                    object2 = StringUtils.getReplacedString((String)object2, "<upper>", string8);
                    object2 = StringUtils.getReplacedString((String)object2, "<lower>", string12);
                    object2 = StringUtils.getReplacedString((String)object2, "<binId>", Integer.toString(n));
                    object3 = (String)object3 + " when <attrname> <= <upper> and <attrname> > <lower> then <binName>\n";
                    object3 = StringUtils.getReplacedString((String)object3, "<attrname>", string3);
                    object3 = StringUtils.getReplacedString((String)object3, "<upper>", string8);
                    object3 = StringUtils.getReplacedString((String)object3, "<lower>", string12);
                    object3 = StringUtils.getReplacedString((String)object3, "<binName>", string9);
                    if (i == list.size() - 1) {
                        object2 = (String)object2 + " when <attrname> > <upper> then <binId> ";
                        object2 = StringUtils.getReplacedString((String)object2, "<attrname>", string3);
                        object2 = StringUtils.getReplacedString((String)object2, "<upper>", string8);
                        object2 = StringUtils.getReplacedString((String)object2, "<binId>", Integer.toString(n + 1));
                        string10 = " '<uppername>'";
                        string10 = StringUtils.getReplacedString(string10, "<uppername>", "> <upper>");
                        string10 = StringUtils.getReplacedString(string10, "<upper>", string7);
                        object3 = (String)object3 + " when <attrname> > <upper> then <binName> ";
                        object3 = StringUtils.getReplacedString((String)object3, "<attrname>", string3);
                        object3 = StringUtils.getReplacedString((String)object3, "<upper>", string8);
                        object3 = StringUtils.getReplacedString((String)object3, "<binName>", string10);
                    }
                }
            } else {
                string8 = (String)list.get(i).getValue();
                string9 = " '<uppername>'";
                string9 = StringUtils.getReplacedString(string9, "<uppername>", "<upper>");
                string9 = StringUtils.getReplacedString(string9, "<upper>", string7);
                object2 = (String)object2 + " when <attrname> = <upper> then <binId>\n";
                object2 = StringUtils.getReplacedString((String)object2, "<attrname>", string3);
                object2 = StringUtils.getReplacedString((String)object2, "<upper>", string8);
                object2 = StringUtils.getReplacedString((String)object2, "<binId>", Integer.toString(n));
                object3 = (String)object3 + " when <attrname> = <upper> then <binName>\n";
                object3 = StringUtils.getReplacedString((String)object3, "<attrname>", string3);
                object3 = StringUtils.getReplacedString((String)object3, "<upper>", string8);
                object3 = StringUtils.getReplacedString((String)object3, "<binName>", string9);
            }
            object4 = (String)object4 + " select 0 as <yattrname>, <binId> as \"BIN_IDS\", <binName> as <attrname> <gcomma> <default_cat> <gattr> from dual \n ";
            object4 = StringUtils.getReplacedString((String)object4, "<binId>", Integer.toString(n));
            object4 = StringUtils.getReplacedString((String)object4, "<binName>", string9);
            object4 = (String)object4 + " union all\n ";
            if (i == list.size() - 1) {
                object4 = (String)object4 + " select 0 as <yattrname>, <binId> as \"BIN_IDS\", <binName> as <attrname> <gcomma> <default_cat> <gattr> from dual \n ";
                object4 = StringUtils.getReplacedString((String)object4, "<binId>", Integer.toString(n + 1));
                object4 = StringUtils.getReplacedString((String)object4, "<binName>", string10);
            }
            ++n;
        }
        object4 = (String)object4 + ")\n";
        object4 = (String)object4 + ", ALL_BINS as ( select   NVL(BINNED_DATA.<yattrname>, EMPTY_BINS.<yattrname>) <yattrname>,  NVL(BINNED_DATA.BIN_IDS, EMPTY_BINS.BIN_IDS) BIN_IDS,  NVL(BINNED_DATA.<qattrname>, EMPTY_BINS.<qattrname>) <qattrname>   <categorySelectClause> from BINNED_DATA right outer join EMPTY_BINS on BINNED_DATA.BIN_IDS = EMPTY_BINS.BIN_IDS order by bin_ids) ";
        object4 = StringUtils.getReplacedString((String)object4, "<yattrname>", string4);
        object4 = StringUtils.getReplacedString((String)object4, "<attrname>", string3);
        object4 = StringUtils.getReplacedString((String)object4, "<qattrname>", string3);
        object4 = StringUtils.getReplacedString((String)object4, "<default_cat>", (String)object);
        object4 = StringUtils.getReplacedString((String)object4, "<categorySelectClause>", string5);
        if (bl2) {
            object2 = (String)object2 + " when <attrname> is Null Then <binId> ";
            object2 = StringUtils.getReplacedString((String)object2, "<attrname>", string3);
            object2 = StringUtils.getReplacedString((String)object2, "<binId>", Integer.toString(n + 1));
            object3 = (String)object3 + " when <attrname> is Null Then 'Nulls' ";
            object3 = StringUtils.getReplacedString((String)object3, "<attrname>", string3);
        }
        object2 = (String)object2 + (bl ? " end bin_ids " : "");
        object3 = (String)object3 + " end <binning_labels> ";
        object3 = StringUtils.getReplacedString((String)object3, "<binning_labels>", string3);
        return new BinClausesInfo((Pair<String, String>)new Pair(object2, object3), (String)object4);
    }

    protected String getCatBinCaseClause(AttributeType attributeType, BinningSettingsType binningSettingsType) {
        if (GraphUtils.getCategoricalBinValues(binningSettingsType).isEmpty()) {
            return "";
        }
        String string = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(attributeType.getName()));
        String string2 = " case when <attr> in (<inclause>) then <attr> else <others> end <attr>";
        String string3 = "'" + GraphLrb.get("BIN_OTHERS") + "'";
        string2 = StringUtils.getReplacedString(string2, "<others>", string3);
        string2 = StringUtils.getReplacedString(string2, "<attr>", string);
        List<String> list = GraphUtils.getCategoricalBinValues(binningSettingsType);
        int n = list.size();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            String string4 = list.get(i);
            stringBuilder.append("'");
            stringBuilder.append(string4);
            stringBuilder.append("'");
            if (i >= n - 1) continue;
            stringBuilder.append(", ");
        }
        string2 = StringUtils.getReplacedString(string2, "<inclause>", stringBuilder.toString());
        return string2;
    }

    public boolean isMultiSeries() {
        return this.isMultiSeries;
    }
}

