/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.teditor.data.DataEditor;
import oracle.dmt.dataminer.teditor.data.DataViewerState;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModelBase;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;

public class ODMrResultSetTableModel
extends ODMrResultSetTableModelBase {
    private static final Logger LOGGER = Logger.getLogger(ODMrResultSetTableModel.class.getName());
    private Editor editor = EditorManager.getEditorManager().getCurrentEditor();
    private ResultSet resultSet;
    private PreparedStatement statement;

    public ODMrResultSetTableModel(DataViewerState dataViewerState) {
        super(dataViewerState);
    }

    @Override
    protected void logError(Exception exception) {
        LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getSQL() {
        if (this.sqlCode == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this.sqlCode);
        if (this.whereClause != null && this.whereClause.trim().length() > 0) {
            if (this.whereClause.trim().toLowerCase().indexOf("where") != 0) {
                stringBuilder.append(" where ");
            }
            stringBuilder.append(this.whereClause);
        }
        if (this.orderByClause != null && this.orderByClause.trim().length() > 0) {
            if (this.orderByClause.trim().toLowerCase().indexOf("order by") != 0) {
                stringBuilder.append(" order by  ");
            }
            stringBuilder.append(this.orderByClause);
        } else if (this.sortColumn > 0) {
            stringBuilder.insert(0, "select * from (\n");
            stringBuilder.append("\n ) sub1 order by ");
            stringBuilder.append(this.getSortColumn());
            stringBuilder.append(this.getSortDirection());
        }
        return ODMrResultSetTableModel.sanitizeOracleSQL(stringBuilder.toString());
    }

    private ResultSet openResultSet() throws SQLException {
        String string = this.getSQL();
        this.statement = this.getConnection().prepareStatement(string);
        this.statement.setEscapeProcessing(false);
        ResultSet resultSet = this.statement.executeQuery();
        return resultSet;
    }

    @Override
    public boolean open(int n) {
        this.areAllFetched = false;
        this.fetchNext(n);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        Object object = this.lock;
        synchronized (object) {
            this.tableRows = null;
            this.backUpRows = null;
            this.areAllFetched = false;
            try {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                this.resultSet = null;
            }
            catch (Exception exception) {
                this.logError(exception);
            }
        }
    }

    @Override
    public void prepareForSort() {
        this.backupRows();
        this.areAllFetched = false;
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
                this.resultSet = null;
            }
            catch (Exception exception) {
                this.logError(exception);
            }
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                this.statement = null;
            }
            catch (Exception exception) {
                this.logError(exception);
            }
        }
    }

    @Override
    public void close() {
        if (this.resultSet != null) {
            try {
                Statement statement = this.resultSet.getStatement();
                this.cleanUp();
                if (statement != null) {
                    statement.close();
                }
                this.statement = null;
            }
            catch (Exception exception) {
                this.logError(exception);
            }
        }
    }

    @Override
    public void interruptSorting() {
        try {
            if (this.isSorting()) {
                this.statement.cancel();
            }
        }
        catch (Exception exception) {
            this.logError(exception);
        }
        this.close();
    }

    @Override
    public void fetchAll() {
        if (this.areAllFetched) {
            return;
        }
        this.fetchNext(Integer.MAX_VALUE);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        List list;
        if (n2 < 0) {
            return null;
        }
        List list2 = list = this.tableRows != null ? this.tableRows : this.backUpRows;
        if (list != null) {
            boolean bl = false;
            if (!this.isSorting()) {
                if (n >= list.size() && !this.isRunning) {
                    bl = true;
                }
                if (bl) {
                    this.fetchNext(n - (list.size() - 1));
                }
            }
            if (n < list.size()) {
                if (n2 == 0) {
                    return n + 1;
                }
                List list3 = (List)list.get(n);
                if (list3 != null && list3.size() > n2 - 1) {
                    return list3.get(n2 - 1);
                }
            }
        }
        return null;
    }

    private void createColumnNamesList() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.columnNames = new ArrayList();
        this.columnNameOccurance = new HashMap();
        if (this.verticalDisplay) {
            this.types = new int[2];
            this.columnSizes = new int[2];
            this.columnNames.add(this.translate("Name"));
            this.columnNames.add(this.translate("Value"));
            this.columnSizes[0] = 30;
            this.columnSizes[1] = 60;
            this.types[0] = 12;
            this.types[1] = 12;
        } else {
            int n2;
            int n3 = 0;
            int n4 = 0;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int n5 = 0;
            boolean bl = false;
            for (n2 = 1; n2 <= n; ++n2) {
                bl = false;
                for (int i = 0; this.skipColumns != null && i < this.skipColumns.size(); ++i) {
                    if (!((String)this.skipColumns.get(i)).toUpperCase().equals(resultSetMetaData.getColumnName(n2).toUpperCase())) continue;
                    bl = true;
                }
                if (bl) continue;
                String string = resultSetMetaData.getColumnTypeName(n2);
                String string2 = resultSetMetaData.getColumnLabel(n2);
                String string3 = this.getUniqueColumnName(string2);
                this.columnNames.add(string3);
                if (this.columnNameToType == null) {
                    this.columnNameToType = new HashMap();
                }
                this.columnNameToType.put(string3, string);
                this.label.setText(string3);
                n3 = Double.valueOf(this.label.getPreferredSize().getWidth()).intValue();
                n4 = resultSetMetaData.getColumnDisplaySize(n2);
                nArray2[n5] = n3 > n4 ? n3 : n4;
                nArray[n5] = resultSetMetaData.getColumnType(n2) == 2009 ? 2005 : resultSetMetaData.getColumnType(n2);
                ++n5;
            }
            this.types = nArray;
            if (this.useStandardColumnSize) {
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    nArray2[n2] = this.standardColumnSize;
                }
            }
            this.columnSizes = nArray2;
        }
    }

    private synchronized void fetchNext(int n) {
        if (this.areAllFetched) {
            return;
        }
        this.fetchSize = this.getFetchSize();
        if (this.tableRows == null) {
            this.tableRows = new ArrayList();
        }
        this.rows = this.tableRows;
        this.count = Math.max(this.fetchSize, n);
        this.newRows = new ArrayList(this.fetchSize);
        this.error = false;
        this.canceled = false;
        this.setRunning(true);
        FetchWorker fetchWorker = new FetchWorker();
        fetchWorker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadData() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.lock(this.getConnection())) {
                    return;
                }
                if (this.getConnection().isClosed()) {
                    return;
                }
                if (this.resultSet != null) return;
                this.resultSet = this.openResultSet();
            }
            catch (SQLException sQLException) {
                if (this.useExceptionDetail()) {
                    this.setErrorMessage(sQLException.getMessage());
                }
                if (sQLException.getErrorCode() == 40203 || sQLException.getErrorCode() == 942) {
                    String string = CommonLrb.get("MSG_DATAMINER_EDITOR_FAILURE_MODEL_DOES_NOT_EXIST");
                    string = MessageFormat.format(string, this.tableName);
                    DataMinerEditor.handleEditorException(this.context, sQLException, DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_TITLE"), string);
                } else {
                    this.logError(sQLException);
                }
            }
            finally {
                this.unlock(this.getConnection());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object updateUI() {
        this.uiUpdated = false;
        int n = this.count;
        ArrayList<String> arrayList = null;
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.resultSet == null || this.resultSet.getFetchSize() == 0) {
                    this.uiUpdated = true;
                    this.createErrorColumnNamesList();
                    arrayList = new ArrayList<String>();
                    arrayList.add(this.getErrorMessage());
                    this.tableRows.add(arrayList);
                    this.areAllFetched = true;
                    this.fireTableStructureChanged();
                    return null;
                }
                this.createColumnNamesList();
                while (n > 0 && this.resultSet.next()) {
                    int n2;
                    if (this.verticalDisplay) {
                        for (n2 = 1; n2 <= this.resultSet.getMetaData().getColumnCount(); ++n2) {
                            arrayList = new ArrayList();
                            arrayList.add(this.resultSet.getMetaData().getColumnName(n2));
                            this.cacheObjectInARow(arrayList, n2, this.resultSet);
                            this.newRows.add(arrayList);
                        }
                        continue;
                    }
                    arrayList = new ArrayList();
                    for (int i = 1; i <= this.resultSet.getMetaData().getColumnCount(); ++i) {
                        n2 = 0;
                        for (int j = 0; n2 == 0 && this.skipColumns != null && j < this.skipColumns.size(); ++j) {
                            if (!((String)this.skipColumns.get(j)).toUpperCase().equals(this.resultSet.getMetaData().getColumnName(i).toUpperCase())) continue;
                            n2 = 1;
                        }
                        if (n2 == 0) {
                            this.cacheObjectInARow(arrayList, i, this.resultSet);
                        }
                        if (!this.canceled) continue;
                        throw new InterruptedException();
                    }
                    try {
                        String string = this.resultSet.getString("SDEV_LINK_TYPE");
                        if ("PACKAGE BODY".equals(string)) {
                            string = "PACKAGE+BODY";
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.newRows.add(arrayList);
                    --n;
                }
            }
            catch (InterruptedException interruptedException) {
                if (this.backUpRows != null && !this.backUpRows.isEmpty()) {
                    this.rows.addAll(this.backUpRows);
                }
            }
            catch (Exception exception) {
                this.error = true;
            }
            List list = this.newRows;
            int n3 = list.size();
            if (n3 > 0) {
                this.rows.addAll(list);
            }
            if (n3 < this.fetchSize || this.areAllFetched) {
                this.areAllFetched = true;
            }
        }
        this.setRunning(false);
        this.fireTableStructureChanged();
        this.uiUpdated = true;
        return null;
    }

    @Override
    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    private class FetchWorker
    extends ODMrSwingWorker<Void, Void> {
        private FetchWorker() {
            super(null, ODMrResultSetTableModel.this.editor instanceof DataEditor ? ((DataEditor)ODMrResultSetTableModel.this.editor).getOverLayPanel() : null);
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            if (ODMrResultSetTableModel.this.state.isClosing()) {
                ODMrResultSetTableModel.this.closeConnection();
                return;
            }
            ODMrResultSetTableModel.this.updateUI();
            if (ODMrResultSetTableModel.this.state.isClosing()) {
                ODMrResultSetTableModel.this.closeConnection();
            }
        }

        @Override
        protected Void doInBackground() throws Exception {
            ODMrResultSetTableModel.this.loadData();
            return null;
        }
    }
}

