/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.common.GetCoefficientStatisticsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.common.GetCoefficientsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.common.GetFeaturesQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.common.GetSingularValuesQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.pca.GetScreePlotDataQuery;
import oracle.dmt.dataminer.core.model.clas.common.FilterSetting;
import oracle.dmt.dataminer.core.model.common.queries.Tuple2;
import oracle.dmt.dataminer.core.model.common.queries.Tuple3;
import oracle.dmt.dataminer.core.model.fe.svd.SVDCoefficient;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.FeatureExtraction;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.jdbc.OraclePreparedStatement;

public class SingularValueDecomposition
extends FeatureExtraction {
    private boolean loading;
    private Map<String, Double> featureIdSingularValue = new HashMap<String, Double>();
    private List<SVDCoefficient> singularValuesList;

    public SingularValueDecomposition(ConnectionManager connectionManager, String string, String string2) {
        super(connectionManager, string, string2);
    }

    public List<SVDCoefficient> getSVDCoefficients(FilterSetting filterSetting) throws ODMrDAOException {
        GetCoefficientsQuery getCoefficientsQuery = new GetCoefficientsQuery(this.connectionManager.getDbVersion(), this.modelDescriptor, filterSetting.getTargetValue(), filterSetting.getSortSpecification(), filterSetting.getFilterAndSortByAbsolute(), Integer.valueOf(filterSetting.getFetchSize()));
        List list = this.dao.readItems((Query)getCoefficientsQuery);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initFeatures() throws ODMrDAOException {
        try {
            this.loading = true;
            this.featureIDToLabelMap.clear();
            GetFeaturesQuery getFeaturesQuery = new GetFeaturesQuery(this.connectionManager.getDbVersion(), this.modelDescriptor);
            List list = this.dao.readItems((Query)getFeaturesQuery);
            for (Tuple2 tuple2 : list) {
                this.featureIDToLabelMap.put((Integer)tuple2.getFirst(), (String)tuple2.getSecond());
            }
        }
        finally {
            this.loading = false;
        }
    }

    public List<SVDCoefficient> getSingularValues() throws ODMrDAOException {
        GetSingularValuesQuery getSingularValuesQuery = new GetSingularValuesQuery(this.connectionManager.getDbVersion(), this.modelDescriptor);
        this.singularValuesList = this.dao.readItems((Query)getSingularValuesQuery);
        return this.singularValuesList;
    }

    public void loadSingularValuesToIdValueMap() throws ODMrDAOException {
        this.getFeatureIdSingularValueMap().clear();
        GetSingularValuesQuery getSingularValuesQuery = new GetSingularValuesQuery(this.connectionManager.getDbVersion(), this.modelDescriptor);
        List list = this.dao.readItems((Query)getSingularValuesQuery);
        for (SVDCoefficient sVDCoefficient : list) {
            this.featureIdSingularValue.put(sVDCoefficient.getAttributeName(), sVDCoefficient.getSingularValue());
        }
    }

    public void loadScreePlotValues(List<String> list, List<Double> list2, List<Double> list3) throws ODMrDAOException {
        GetScreePlotDataQuery getScreePlotDataQuery = new GetScreePlotDataQuery(this.connectionManager.getDbVersion(), this.modelDescriptor);
        List list4 = this.dao.readItems((Query)getScreePlotDataQuery);
        for (Tuple3 tuple3 : list4) {
            list.add((String)tuple3.getFirst());
            list2.add((Double)tuple3.getSecond());
            list3.add((Double)tuple3.getThird());
        }
    }

    @Override
    public Map<String, Object> getCoefficientStatistics(List<Object> list) throws ODMrDAOException {
        GetCoefficientStatisticsQuery getCoefficientStatisticsQuery = new GetCoefficientStatisticsQuery(this.connectionManager.getDbVersion(), this.modelDescriptor, list);
        Optional optional = this.dao.readItem((Query)getCoefficientStatisticsQuery);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (optional.isPresent()) {
            Tuple2 tuple2 = (Tuple2)optional.get();
            hashMap.put("TOTAL_COEFFICIENTS", tuple2.getFirst());
            hashMap.put("MAXIMUM_ABS_COEFFICIENT_VALUE", tuple2.getSecond());
        } else {
            hashMap.put("TOTAL_COEFFICIENTS", 0);
            hashMap.put("MAXIMUM_ABS_COEFFICIENT_VALUE", 0.0);
        }
        return hashMap;
    }

    public boolean isFeatureLabelUnique(String string) {
        return !this.featureIDToLabelMap.containsValue(string);
    }

    @Override
    public boolean isFeatureUnique(String string) {
        assert (this.singularValuesList != null) : "Load singular values first";
        long l = this.singularValuesList.stream().filter(sVDCoefficient -> sVDCoefficient.getAttributeName().equals(string)).count();
        return l == 0L;
    }

    public void renameFeatureInSVList(String string, String string2) throws ODMrDAOException {
        assert (this.singularValuesList != null) : "Load singular values first";
        Optional<SVDCoefficient> optional = this.singularValuesList.stream().filter(sVDCoefficient -> sVDCoefficient.getAttributeName().equals(string2)).findFirst();
        Integer n = optional.get().getId();
        StringBuilder stringBuilder = new StringBuilder("case ");
        for (SVDCoefficient sVDCoefficient2 : this.singularValuesList) {
            Integer n2 = sVDCoefficient2.getId();
            String string3 = sVDCoefficient2.getAttributeName();
            StringBuilder stringBuilder2 = new StringBuilder();
            String string4 = StringUtils.getReplacedString("when value = [FEATURE_ID] then ", "[FEATURE_ID]", n2.toString());
            stringBuilder2.append(string4);
            if (n2.equals(n)) {
                sVDCoefficient2.setAttributeName(string);
                string4 = StringUtils.getReplacedString("'[NEW_NAME]'\n", "[NEW_NAME]", string);
            } else {
                string4 = StringUtils.getReplacedString("'[OLD_NAME]'\n", "[OLD_NAME]", string3);
            }
            stringBuilder2.append(string4);
            stringBuilder.append(stringBuilder2.toString());
        }
        stringBuilder.append("                else TO_CHAR(value) end");
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this.connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement("BEGIN\n  dbms_data_mining.alter_reverse_expression(\n :MODEL_NAME, :CASE_STATEMENT);\nEND;\n");
            sQLHelper.opstmt.setStringAtName("MODEL_NAME", Model.getCombinedUserNameModelName(this.getUserName(), this.getModelName(), true));
            sQLHelper.opstmt.setStringAtName("CASE_STATEMENT", stringBuilder.toString());
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
        }
    }

    public Double getSingularByFeatureIdValue(String string) {
        return this.featureIdSingularValue.get(string);
    }

    private Map<String, Double> getFeatureIdSingularValueMap() {
        if (this.featureIdSingularValue == null) {
            this.featureIdSingularValue = new HashMap<String, Double>();
        }
        return this.featureIdSingularValue;
    }
}

