/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.ConnectionProperties;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.CostMatrixExistsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.GetModelsWithCostMatrixQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.GetScoringCostMatrixQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.GetWeightsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.glm.ClassReferenceValuesQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.nb.PriorProbabilitiesQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetModelAttributesQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetModelGeneralDescriptionsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetModelPartitionsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetModelSettingsQuery;
import oracle.dmt.dataminer.core.model.clas.common.CostMatrixInfo;
import oracle.dmt.dataminer.core.model.clas.common.MatrixInfo;
import oracle.dmt.dataminer.core.model.clas.common.PerformanceInfo;
import oracle.dmt.dataminer.core.model.clas.common.PriorsInfo;
import oracle.dmt.dataminer.core.model.common.build.MiningAttributeInfo;
import oracle.dmt.dataminer.core.model.common.build.MiningModelSettings;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.common.build.ModelGeneralDescription;
import oracle.dmt.dataminer.core.model.common.build.partition.ModelPartitions;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbMetadataUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.server.model.AssociationRules;
import oracle.dmt.dataminer.server.model.Classification;
import oracle.dmt.dataminer.server.model.ClusteringDefault;
import oracle.dmt.dataminer.server.model.ClusteringEM;
import oracle.dmt.dataminer.server.model.ClusteringKM;
import oracle.dmt.dataminer.server.model.ClusteringOC;
import oracle.dmt.dataminer.server.model.DecisionTree;
import oracle.dmt.dataminer.server.model.FeatureExtraction;
import oracle.dmt.dataminer.server.model.GeneralizedLinearModelC;
import oracle.dmt.dataminer.server.model.GeneralizedLinearModelR;
import oracle.dmt.dataminer.server.model.NaiveBayes;
import oracle.dmt.dataminer.server.model.RegressionDefault;
import oracle.dmt.dataminer.server.model.SingularValueDecomposition;
import oracle.dmt.dataminer.server.model.SupportVectorMachinesC;
import oracle.dmt.dataminer.server.model.SupportVectorMachinesR;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Version;

public class Model {
    private static final String _TARGET_VALUE = "TARGET_VALUE";
    private boolean loaded;
    protected ModelDescriptor modelDescriptor;
    protected ConnectionManager connectionManager;
    protected SqlDataAccessObject dao;
    private List<MiningModelSettings> modelSettings;
    private ModelGeneralDescription modelGeneralDescription;

    public Model(ConnectionManager connectionManager, String string, String string2) {
        assert (connectionManager != null) : "ConnectionManager cannot be null.";
        this.connectionManager = connectionManager;
        this.modelDescriptor = new ModelDescriptor(string, string2);
        this.dao = new SqlDataAccessObject(connectionManager);
    }

    public synchronized void load() throws ODMrDAOException {
        assert (this.getModelName().trim().length() > 0) : "Model name is empty. Unable to load model.";
        if (this.loaded) {
            return;
        }
        this.modelSettings = this.getModelSetting();
        this.modelGeneralDescription = this.loadModelGeneralDescription();
        this.loaded = true;
    }

    public ModelGeneralDescription loadModelGeneralDescription() throws ODMrDAOException {
        GetModelGeneralDescriptionsQuery getModelGeneralDescriptionsQuery = new GetModelGeneralDescriptionsQuery(this.connectionManager.getDbVersion()).setOwner(this.getUserName()).setModelName(this.getModelName());
        this.dao.setConnectionProperties(new ConnectionProperties[]{ConnectionProperties.ALTER_SESSION_FIXES});
        List list = this.dao.readItems((Query)getModelGeneralDescriptionsQuery);
        this.dao.setConnectionProperties((ConnectionProperties[])null);
        if (list.isEmpty()) {
            return ModelGeneralDescription._NONE;
        }
        return (ModelGeneralDescription)list.get(0);
    }

    public static Model makeModel(ConnectionManager connectionManager, ModelGeneralDescription modelGeneralDescription) {
        String string;
        Model model = null;
        String string2 = modelGeneralDescription.getOwner();
        String string3 = modelGeneralDescription.getModelName();
        String string4 = modelGeneralDescription.getAlgorithm();
        switch (string = modelGeneralDescription.getMiningFunction()) {
            case "ASSOCIATION_RULES": {
                model = new AssociationRules(connectionManager, string2, string3);
                break;
            }
            case "CLASSIFICATION": {
                if ("GENERALIZED_LINEAR_MODEL".equals(string4)) {
                    model = new GeneralizedLinearModelC(connectionManager, string2, string3);
                    break;
                }
                if ("SUPPORT_VECTOR_MACHINES".equals(string4)) {
                    model = new SupportVectorMachinesC(connectionManager, string2, string3);
                    break;
                }
                if ("DECISION_TREE".equals(string4)) {
                    model = new DecisionTree(connectionManager, string2, string3);
                    break;
                }
                if ("NAIVE_BAYES".equals(string4)) {
                    model = new NaiveBayes(connectionManager, string2, string3);
                    break;
                }
                model = new Classification(connectionManager, string2, string3);
                break;
            }
            case "REGRESSION": {
                if ("SUPPORT_VECTOR_MACHINES".equals(string4)) {
                    model = new SupportVectorMachinesR(connectionManager, string2, string3);
                    break;
                }
                if ("GENERALIZED_LINEAR_MODEL".equals(string4)) {
                    model = new GeneralizedLinearModelR(connectionManager, string2, string3);
                    break;
                }
                model = new RegressionDefault(connectionManager, string2, string3);
                break;
            }
            case "CLUSTERING": {
                if ("KMEANS".equals(string4)) {
                    model = new ClusteringKM(connectionManager, string2, string3);
                    break;
                }
                if ("EXPECTATION_MAXIMIZATION".equals(string4)) {
                    model = new ClusteringEM(connectionManager, string2, string3);
                    break;
                }
                if ("O_CLUSTER".equals(string4)) {
                    model = new ClusteringOC(connectionManager, string2, string3);
                    break;
                }
                model = new ClusteringDefault(connectionManager, string2, string3);
                break;
            }
            case "FEATURE_EXTRACTION": {
                if ("PRINCIPAL_COMPONENT_ANALYSIS".equals(string4) || "SINGULAR_VALUE_DECOMP".equals(string4)) {
                    model = new SingularValueDecomposition(connectionManager, string2, string3);
                    break;
                }
                model = new FeatureExtraction(connectionManager, string2, string3);
                break;
            }
            default: {
                model = new Model(connectionManager, string2, string3);
            }
        }
        return model;
    }

    public static ModelGeneralDescription getModelGeneralDescription(ConnectionManager connectionManager, ModelDescriptor modelDescriptor) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(modelDescriptor.getName());
        ModelGeneralDescription modelGeneralDescription = ModelGeneralDescription._NONE;
        try {
            List<ModelGeneralDescription> list = Model.getModelGeneralDescriptions(connectionManager, modelDescriptor.getSchema(), arrayList);
            if (!list.isEmpty()) {
                modelGeneralDescription = list.get(0);
            }
        }
        catch (ODMrDAOException oDMrDAOException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)oDMrDAOException), (String)CommonLrb.get("MSG_EXCEPTION"));
        }
        return modelGeneralDescription;
    }

    public static List<ModelGeneralDescription> getModelGeneralDescriptions(ConnectionManager connectionManager, String string, List<String> list) throws ODMrDAOException {
        SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject(connectionManager);
        GetModelGeneralDescriptionsQuery getModelGeneralDescriptionsQuery = new GetModelGeneralDescriptionsQuery(connectionManager.getDbVersion()).setOwner(string).setModelNames(list);
        sqlDataAccessObject.setConnectionProperties(new ConnectionProperties[]{ConnectionProperties.ALTER_SESSION_FIXES});
        List list2 = sqlDataAccessObject.readItems((Query)getModelGeneralDescriptionsQuery);
        sqlDataAccessObject.setConnectionProperties((ConnectionProperties[])null);
        return list2;
    }

    public List<ModelGeneralDescription> getAllSchemaModelGeneralDescriptions() throws ODMrDAOException {
        GetModelGeneralDescriptionsQuery getModelGeneralDescriptionsQuery = new GetModelGeneralDescriptionsQuery(this.connectionManager.getDbVersion()).setOwner(this.getUserName());
        return this.dao.readItems((Query)getModelGeneralDescriptionsQuery);
    }

    public static ModelPartitions getModelPartitions(ConnectionManager connectionManager, String string, String ... stringArray) throws ODMrDAOException {
        GetModelPartitionsQuery getModelPartitionsQuery = new GetModelPartitionsQuery(connectionManager.getDbVersion(), stringArray).setOwner(string);
        SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject(connectionManager);
        return sqlDataAccessObject.readItem((Query)getModelPartitionsQuery).orElse(new ModelPartitions());
    }

    public boolean isModelExists() throws ODMrDAOException {
        GetModelGeneralDescriptionsQuery getModelGeneralDescriptionsQuery = new GetModelGeneralDescriptionsQuery(this.connectionManager.getDbVersion()).setOwner(this.getUserName()).setModelName(this.getModelName());
        return !this.dao.readItems((Query)getModelGeneralDescriptionsQuery).isEmpty();
    }

    public List<MiningModelSettings> getModelSetting() throws ODMrDAOException {
        GetModelSettingsQuery getModelSettingsQuery = new GetModelSettingsQuery(this.connectionManager.getDbVersion()).setOwner(this.getUserName()).setModel(this.getModelName());
        return this.dao.readItems((Query)getModelSettingsQuery);
    }

    public List<MiningModelSettings> getModelSetting(List<String> list) throws ODMrDAOException {
        GetModelSettingsQuery getModelSettingsQuery = new GetModelSettingsQuery(this.connectionManager.getDbVersion()).setOwner(this.getUserName()).setModel(this.getModelName()).setSettingsFilter(list);
        return this.dao.readItems((Query)getModelSettingsQuery);
    }

    public String getRegressionModelTarget() throws ODMrDAOException {
        GetModelAttributesQuery getModelAttributesQuery = new GetModelAttributesQuery(this.connectionManager.getDbVersion()).setOwner(this.getUserName()).setModel(this.getModelName()).setTarget("YES");
        List list = this.dao.readItems((Query)getModelAttributesQuery);
        if (list.isEmpty()) {
            return "";
        }
        return ((MiningAttributeInfo)list.get(0)).getAttributeName();
    }

    public String getBFILEColumns() throws ODMrDAOException {
        GetModelAttributesQuery getModelAttributesQuery = new GetModelAttributesQuery(this.connectionManager.getDbVersion()).setOwner(this.getUserName()).setModel(this.getModelName()).setDataType("BFILE").setUsageType("ACTIVE");
        List list = this.dao.readItems((Query)getModelAttributesQuery);
        String string = list.stream().map(miningAttributeInfo -> "bfilename(NULL,NULL) " + miningAttributeInfo.getAttributeName()).collect(Collectors.joining(","));
        return string;
    }

    public List<String> getModelAttributes() throws ODMrDAOException {
        GetModelAttributesQuery getModelAttributesQuery = new GetModelAttributesQuery(this.connectionManager.getDbVersion()).setOwner(this.getUserName()).setModel(this.getModelName());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MiningAttributeInfo miningAttributeInfo : this.dao.readItems((Query)getModelAttributesQuery)) {
            arrayList.add(miningAttributeInfo.getAttributeName());
        }
        return arrayList;
    }

    public List<MiningAttributeType> getMiningAttributeTypes() throws ODMrDAOException {
        GetModelAttributesQuery getModelAttributesQuery = new GetModelAttributesQuery(this.connectionManager.getDbVersion()).setOwner(this.getUserName()).setModel(this.getModelName());
        List list = this.dao.readItems((Query)getModelAttributesQuery);
        List<MiningAttributeType> list2 = list.stream().map(miningAttributeInfo -> {
            MiningAttributeType miningAttributeType = new MiningAttributeType();
            miningAttributeType.setName(miningAttributeInfo.getAttributeName());
            miningAttributeType.setDataType(miningAttributeInfo.getDataType());
            miningAttributeType.setInput("Yes");
            return miningAttributeType;
        }).collect(Collectors.toList());
        return list2;
    }

    public static List<MiningModelSettings> getModelSettings(ConnectionManager connectionManager, List<String> list) throws ODMrDAOException {
        GetModelSettingsQuery getModelSettingsQuery = new GetModelSettingsQuery(connectionManager.getDbVersion()).setQualifiedModels(true).setModels(list);
        SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject(connectionManager);
        return sqlDataAccessObject.readItems((Query)getModelSettingsQuery);
    }

    public static List<MiningModelSettings> getModelSettings(ConnectionManager connectionManager, String string, List<String> list) throws ODMrDAOException {
        SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject(connectionManager);
        GetModelSettingsQuery getModelSettingsQuery = new GetModelSettingsQuery(connectionManager.getDbVersion()).setOwner(string).setModels(list);
        sqlDataAccessObject.setConnectionProperties(new ConnectionProperties[]{ConnectionProperties.ALTER_SESSION_FIXES});
        List list2 = sqlDataAccessObject.readItems((Query)getModelSettingsQuery);
        sqlDataAccessObject.setConnectionProperties((ConnectionProperties[])null);
        return list2;
    }

    public List<MiningModelSettings> getModelSettings() throws ODMrDAOException {
        if (this.modelSettings == null) {
            GetModelSettingsQuery getModelSettingsQuery = new GetModelSettingsQuery(this.connectionManager.getDbVersion()).setOwner(this.getUserName()).setModel(this.getModelName());
            this.modelSettings = this.dao.readItems((Query)getModelSettingsQuery);
        }
        return this.modelSettings;
    }

    public static List<String> getModelNames(ConnectionManager connectionManager, String string3, String string4, boolean bl) throws ODMrDAOException {
        SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject(connectionManager);
        GetModelGeneralDescriptionsQuery getModelGeneralDescriptionsQuery = new GetModelGeneralDescriptionsQuery(connectionManager.getDbVersion()).setMiningFunction(string3).setAlgorithm(string4).setOwnerAccountOnly(bl);
        List list = sqlDataAccessObject.readItems((Query)getModelGeneralDescriptionsQuery);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ModelGeneralDescription modelGeneralDescription : list) {
            arrayList.add(modelGeneralDescription.getModelName());
        }
        arrayList.sort((string, string2) -> string.length() - string2.length());
        return arrayList;
    }

    public boolean modelCostMatrixExists() throws ODMrDAOException {
        CostMatrixExistsQuery costMatrixExistsQuery = new CostMatrixExistsQuery(this.connectionManager.getDbVersion(), this.modelDescriptor.isPartitioned(), this.getUserName(), this.getModelName());
        return this.dao.readItem((Query)costMatrixExistsQuery).orElse(-1) > 0;
    }

    public CostMatrixInfo getModelScoreCostMatrix() throws ODMrDAOException {
        GetScoringCostMatrixQuery getScoringCostMatrixQuery = new GetScoringCostMatrixQuery(this.connectionManager.getDbVersion(), this.modelDescriptor);
        return this.dao.readItem((Query)getScoringCostMatrixQuery).orElse(CostMatrixInfo._NONE);
    }

    public MatrixInfo getClassWeights() throws ODMrDAOException {
        Object object = null;
        String string = null;
        String string2 = this.getUserName();
        String string3 = this.getModelName();
        String string4 = this.getPartitionId();
        if (DbVersionHelper.isDB122Up((Version)this.connectionManager.getDbVersion())) {
            object = "DM$VT" + string3;
            string = DbMetadataUtils.getColumnDataType((ConnectionManager)this.connectionManager, (String)string2, (String)object, (String)_TARGET_VALUE);
            GetWeightsQuery getWeightsQuery = new GetWeightsQuery(this.connectionManager.getDbVersion(), string2, (String)object, string4, string);
            PerformanceInfo performanceInfo = this.dao.readItem((Query)getWeightsQuery).orElse(null);
            return performanceInfo.isEmpty() ? null : performanceInfo;
        }
        if (this.getModelGeneralDescription().isSupportVectorMachinesAlgorithm() || this.getModelGeneralDescription().isGeneralizedLinearModelAlgorithm()) {
            String string5 = this.getSettingValue("CLAS_WEIGHTS_TABLE_NAME");
            object = string5.toUpperCase();
            string = DbMetadataUtils.getColumnDataType((ConnectionManager)this.connectionManager, (String)string2, (String)object, (String)_TARGET_VALUE);
            GetWeightsQuery getWeightsQuery = new GetWeightsQuery(this.connectionManager.getDbVersion(), string2, (String)object, string4, string);
            PerformanceInfo performanceInfo = this.dao.readItem((Query)getWeightsQuery).orElse(null);
            return performanceInfo.isEmpty() ? null : performanceInfo;
        }
        if (this.getModelGeneralDescription().isNaiveBayesAlgorithm()) {
            String string6 = this.getSettingValue("CLAS_PRIORS_TABLE_NAME");
            object = string6.toUpperCase();
            string = DbMetadataUtils.getColumnDataType((ConnectionManager)this.connectionManager, (String)string2, (String)object, (String)_TARGET_VALUE);
            PriorProbabilitiesQuery priorProbabilitiesQuery = new PriorProbabilitiesQuery(this.connectionManager.getDbVersion(), string2, string6, string);
            PriorsInfo priorsInfo = this.dao.readItem((Query)priorProbabilitiesQuery).orElse(PriorsInfo._NO_PRIOR);
            return priorsInfo.isEmpty() ? null : priorsInfo;
        }
        return null;
    }

    private String getSettingValue(String string) throws ODMrDAOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        GetModelSettingsQuery getModelSettingsQuery = new GetModelSettingsQuery(this.connectionManager.getDbVersion()).setOwner(this.getUserName()).setModel(this.getModelName()).setSettingsFilter(arrayList);
        List list = this.dao.readItems((Query)getModelSettingsQuery);
        return list.isEmpty() ? null : ((MiningModelSettings)list.get(0)).getSettingValue();
    }

    public static void doModelsContainScoringCostMatrix(ConnectionManager connectionManager, ModelNodeType.Models models, List<MiningModelSettings> list) throws ODMrDAOException {
        ModelNodeType.Models.Model model2;
        String string = "IMBEDDED_SCORING_COST_MATRIX";
        String string2 = "TRUE";
        String string3 = "INPUT";
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (ModelNodeType.Models.Model model2 : models.getModel()) {
            PartitionExpressionType partitionExpressionType;
            List list2;
            PartitionExpressions partitionExpressions;
            if (DbVersionHelper.isDB122Up((Version)connectionManager.getDbVersion()) && (partitionExpressions = model2.getPartitionExpressions()) != null && (list2 = partitionExpressions.getPartitionExpression()) != null && list2.size() > 0 && (partitionExpressionType = (PartitionExpressionType)list2.get(0)).getPartitionAttribute() != null && !"".equals(partitionExpressionType.getPartitionAttribute().getName().trim())) {
                boolean bl = false;
                for (MiningModelSettings miningModelSettings : list) {
                    if (miningModelSettings.getModelName().compareTo(model2.getName()) != 0 || miningModelSettings.getOwner().compareTo(model2.getSchema()) != 0 || !miningModelSettings.getSettingName().equals("CLAS_WEIGHTS_BALANCED") || !miningModelSettings.getSettingValue().equals("ON")) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                MiningModelSettings miningModelSettings = new MiningModelSettings(model2.getSchema(), model2.getName(), string, string2, string3);
                list.add(miningModelSettings);
                continue;
            }
            arrayList.add(model2.getSchema());
            arrayList2.add(model2.getName());
        }
        if (arrayList2.isEmpty()) {
            return;
        }
        SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject(connectionManager);
        model2 = new GetModelsWithCostMatrixQuery(connectionManager.getDbVersion(), string3, string2, string, arrayList, arrayList2);
        list.addAll(sqlDataAccessObject.readItems((Query)model2));
    }

    public List<String> getGLMClassRefValues() throws ODMrDAOException {
        ClassReferenceValuesQuery classReferenceValuesQuery = new ClassReferenceValuesQuery(this.connectionManager.getDbVersion(), this.modelDescriptor);
        return this.dao.readItems((Query)classReferenceValuesQuery);
    }

    public String getModelName() {
        return this.modelDescriptor.getName();
    }

    public String getUserName() {
        return this.modelDescriptor.getSchema();
    }

    public String getPartitionId() {
        return this.modelDescriptor.getPartitionId();
    }

    public void setPartitionId(String string) {
        this.modelDescriptor.setPartitionId(string);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public ModelGeneralDescription getModelGeneralDescription() {
        assert (this.loaded) : "Accesing model details prior to loading.";
        return this.modelGeneralDescription;
    }

    public static String getCombinedUserNameModelName(String string, String string2, boolean bl) {
        Object object = "\"" + string + "\".\"" + string2.toUpperCase() + "\"";
        if (bl) {
            object = StringUtils.escapeSingleQuotesForSQL((String)object);
        }
        return object;
    }
}

