/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.glm.GetAllPropensitiesQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.glm.GetCoefficientsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.glm.GetMinMaxCoefficientQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.glm.GetTotalCoefficientsForTargetQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.glm.GetTotalPropensitiesQuery;
import oracle.dmt.dataminer.core.model.clas.common.FilterSetting;
import oracle.dmt.dataminer.core.model.clas.common.GLMCoefficient;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.model.common.build.AttributeBiCoefficient;
import oracle.dmt.dataminer.core.model.common.build.GLMModelDetail;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.server.model.GLMModelDetails;
import oracle.dmt.dataminer.server.model.GlobalDetails;
import oracle.javatools.util.Version;

public class GLMModelDetailsImpl
implements GLMModelDetails {
    private ModelType modelType;
    private ModelDescriptor modelDesc;
    private SqlDataAccessObject dao;
    private ConnectionManager connManager;

    public GLMModelDetailsImpl(ModelType modelType, ConnectionManager connectionManager, String string, String string2) {
        this.modelType = modelType;
        this.connManager = connectionManager;
        this.dao = new SqlDataAccessObject(connectionManager);
        this.modelDesc = new ModelDescriptor(string, string2);
    }

    public void setPartitionId(String string) {
        this.modelDesc.setPartitionId(string);
    }

    @Override
    public List<GLMCoefficient> getAllCoefficients(FilterSetting filterSetting) throws ODMrDAOException {
        return Collections.emptyList();
    }

    @Override
    public List<GLMCoefficient> getCoefficients(CoefficientFilterSetting coefficientFilterSetting) throws ODMrDAOException {
        List list = null;
        if (this.modelType == ModelType.REGRESSION) {
            GetCoefficientsQuery getCoefficientsQuery = new GetCoefficientsQuery(this.connManager.getDbVersion(), this.modelDesc, false, coefficientFilterSetting.getFilterAndSortByAbsolute(), coefficientFilterSetting.getSortSpecification(), Integer.valueOf(coefficientFilterSetting.getFetchSize()));
            list = this.dao.readItems((Query)getCoefficientsQuery);
        } else if (coefficientFilterSetting.isBinaryClassModel()) {
            GetCoefficientsQuery getCoefficientsQuery = new GetCoefficientsQuery(this.connManager.getDbVersion(), this.modelDesc, coefficientFilterSetting.getTargetValue(), false, coefficientFilterSetting.getFilterAndSortByAbsolute(), coefficientFilterSetting.getSortSpecification(), Integer.valueOf(coefficientFilterSetting.getFetchSize()));
            list = this.dao.readItems((Query)getCoefficientsQuery);
            if (list.isEmpty()) {
                getCoefficientsQuery = new GetCoefficientsQuery(this.connManager.getDbVersion(), this.modelDesc, coefficientFilterSetting.getNonSelectedBinaryClassValue(), true, coefficientFilterSetting.getFilterAndSortByAbsolute(), coefficientFilterSetting.getSortSpecification(), Integer.valueOf(coefficientFilterSetting.getFetchSize()));
                list = this.dao.readItems((Query)getCoefficientsQuery);
            }
        } else assert (false) : "MK GLM does not support multi class";
        return list;
    }

    public Map<String, Object> getCoefficientStatistics(List<Object> list, FilterSetting filterSetting) throws ODMrDAOException {
        Integer n;
        assert (list != null && list.size() > 0) : "Must provide at least one target value";
        GetTotalCoefficientsForTargetQuery getTotalCoefficientsForTargetQuery = new GetTotalCoefficientsForTargetQuery(this.connManager.getDbVersion(), this.modelDesc, list);
        Map<String, Object> map = this.dao.readItem((Query)getTotalCoefficientsForTargetQuery).orElse(Collections.emptyMap());
        if (filterSetting.isBinaryClassModel() && (n = (Integer)map.get("TOTAL_COEFFICIENTS")) == 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(filterSetting.getNonSelectedBinaryClassValue());
            getTotalCoefficientsForTargetQuery = new GetTotalCoefficientsForTargetQuery(this.connManager.getDbVersion(), this.modelDesc, arrayList);
            map = this.dao.readItem((Query)getTotalCoefficientsForTargetQuery).orElse(Collections.emptyMap());
        }
        return map;
    }

    public Map<String, Object> getCoefficientStatistics() throws ODMrDAOException {
        GetTotalCoefficientsForTargetQuery getTotalCoefficientsForTargetQuery = new GetTotalCoefficientsForTargetQuery(this.connManager.getDbVersion(), this.modelDesc);
        Map<String, Object> map = this.dao.readItem((Query)getTotalCoefficientsForTargetQuery).orElse(Collections.emptyMap());
        return map;
    }

    @Override
    public List<GLMModelDetail> getGlobalDetails() throws ODMrDAOException {
        List<NameValuePair> list = GlobalDetails.getModelDetailsGlobal(this.connManager, this.modelDesc);
        boolean bl = DbVersionHelper.isDB122Up((Version)this.connManager.getDbVersion());
        ArrayList<GLMModelDetail> arrayList = new ArrayList<GLMModelDetail>(list.size());
        for (NameValuePair nameValuePair : list) {
            String string = nameValuePair.getName();
            Object object = nameValuePair.getValue();
            if (!bl && (string.equalsIgnoreCase("MODEL_CONVERGED") || string.equalsIgnoreCase("VALID_COVARIANCE_MATRIX"))) {
                object = !object.equals(0.0);
            }
            GLMModelDetail gLMModelDetail = new GLMModelDetail(string, object);
            arrayList.add(gLMModelDetail);
        }
        return arrayList;
    }

    public Double[] getMinMaxValue() throws ODMrDAOException {
        GetMinMaxCoefficientQuery getMinMaxCoefficientQuery = new GetMinMaxCoefficientQuery(this.connManager.getDbVersion(), this.modelDesc);
        Double[] doubleArray = this.dao.readItem((Query)getMinMaxCoefficientQuery).orElse(new Double[0]);
        return doubleArray;
    }

    public List<AttributeBiCoefficient> getPropensities(FilterSetting filterSetting) throws ODMrDAOException {
        GetAllPropensitiesQuery getAllPropensitiesQuery = new GetAllPropensitiesQuery(this.connManager.getDbVersion(), this.modelDesc, filterSetting.getTargetValue(), filterSetting.getSecondTargetValue(), filterSetting.getFilterAndSortByAbsolute(), filterSetting.getSortSpecification(), Integer.valueOf(filterSetting.getFetchSize()));
        List list = this.dao.readItems((Query)getAllPropensitiesQuery);
        return list;
    }

    public Integer getTotalCountPropensities(FilterSetting filterSetting) throws ODMrDAOException {
        GetTotalPropensitiesQuery getTotalPropensitiesQuery = new GetTotalPropensitiesQuery(this.connManager.getDbVersion(), this.modelDesc, filterSetting.getTargetValue(), filterSetting.getSecondTargetValue(), filterSetting.getFilterAndSortByAbsolute(), filterSetting.getSortSpecification());
        Integer n = null;
        if (filterSetting.isBinaryClassModel()) {
            n = this.dao.readItem((Query)getTotalPropensitiesQuery).orElse(0);
        }
        return n;
    }

    public static enum ModelType {
        CLASSIFICATION,
        REGRESSION;

    }
}

