/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.common.build.ModelGeneralDescription;
import oracle.dmt.dataminer.mviewer.dt.schema.PMML;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.Classification;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.CLOB;

public class DecisionTree
extends Classification {
    private static final Logger theLogger = Logger.getLogger(DecisionTree.class.getName());
    private static volatile JAXBContext jaxbContext;
    private static Unmarshaller unmarshaller;
    private PMML root;
    private static final String GET_DT_MODEL_XML_SQL = "DECLARE   xml_result XMLTYPE;  clob_val   CLOB;   xml_string VARCHAR2(32627);BEGIN  xml_result := DBMS_DATA_MINING.GET_MODEL_DETAILS_XML (?);  clob_val := xml_result.getClobVal();   ? := clob_val;END;";
    private static final String GET_DT_MODEL_XML_SQL_PARTITION = "DECLARE   xml_result XMLTYPE;  clob_val   CLOB; BEGIN  xml_result := DBMS_DATA_MINING.GET_MODEL_DETAILS_XML (?, ?);  clob_val := xml_result.getClobVal();   ? := clob_val;END;";

    public DecisionTree(ConnectionManager connectionManager, String string, String string2) {
        super(connectionManager, string, string2);
    }

    public PMML getRootObject() {
        return this.root;
    }

    @Override
    public void load() throws ODMrDAOException {
        String string = StringUtils.addDoubleQuotes(this.getPartitionId());
        super.load();
        if (this.getModelGeneralDescription().equals(ModelGeneralDescription._NONE)) {
            return;
        }
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this.connectionManager.getConnection();
            if (StringUtils.isNotEmpty(string)) {
                sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall(GET_DT_MODEL_XML_SQL_PARTITION);
                sQLHelper.cstmt.setString(1, "\"" + this.getUserName() + "\".\"" + this.getModelName() + "\"");
                sQLHelper.cstmt.setString(2, string);
                sQLHelper.cstmt.registerOutParameter(3, 2005);
            } else {
                sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall(GET_DT_MODEL_XML_SQL);
                sQLHelper.cstmt.setString(1, "\"" + this.getUserName() + "\".\"" + this.getModelName() + "\"");
                sQLHelper.cstmt.registerOutParameter(2, 2005);
            }
            sQLHelper.cstmt.execute();
            CLOB cLOB = StringUtils.isNotEmpty(string) ? sQLHelper.cstmt.getCLOB(3) : sQLHelper.cstmt.getCLOB(2);
            Reader reader = cLOB.getCharacterStream();
            Unmarshaller unmarshaller = DecisionTree.createUnmarshaller();
            this.root = (PMML)unmarshaller.unmarshal(reader);
        }
    }

    private static Unmarshaller createUnmarshaller() throws JAXBException {
        unmarshaller = DecisionTree.getJAXBContextInstance().createUnmarshaller();
        return unmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JAXBContext getJAXBContextInstance() throws JAXBException {
        if (jaxbContext != null) return jaxbContext;
        Class<DecisionTree> clazz = DecisionTree.class;
        synchronized (DecisionTree.class) {
            if (jaxbContext != null) return jaxbContext;
            try {
                DecisionTree.class.getClassLoader().loadClass("oracle.dmt.dataminer.mviewer.dt.schema.TreeModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                theLogger.log(Level.WARNING, classNotFoundException.getMessage(), classNotFoundException);
            }
            jaxbContext = JAXBContext.newInstance((String)"oracle.dmt.dataminer.mviewer.dt.schema");
            // ** MonitorExit[var0] (shouldn't be in output)
            return jaxbContext;
        }
    }
}

