/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dmt.dataminer.core.model.clas.common.FilterSetting;
import oracle.dmt.dataminer.core.model.common.build.AttributeBiCoefficient;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.model.filter.WhereSpec;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.compare.CompareState;
import oracle.dmt.dataminer.server.model.TargetPriorsPredictionSet;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class CompareFilterSetting
implements FilterSetting {
    private BigDecimal _minCoefficient;
    private BigDecimal _maxCoefficient;
    private int _fetchSize;
    private boolean _filterAndSortByAbsolute;
    private List<SortSpec> _sortSpecs;
    private List<WhereSpec> _whereSpecs;
    private Object _targetValue;
    private Object _secondTargetValue;
    private CompareState _viewerState;
    private boolean bUseFilterSpec = false;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private List<TargetPriorsPredictionSet> _targetValuePriors;

    public CompareFilterSetting() {
        this._fetchSize = this._modelViewerPrefenceSettings.getFetchSizeClusteringModel();
        this._filterAndSortByAbsolute = true;
        this._minCoefficient = new BigDecimal(0.0);
        this._maxCoefficient = new BigDecimal(1.0);
        this._sortSpecs = new ArrayList<SortSpec>();
        this._sortSpecs.add(new SortSpec("propensity_target", SortDirection.DESCENDING, true));
        this._sortSpecs.add(new SortSpec("attribute_name_subname", SortDirection.ASCENDING, true));
        this._sortSpecs.add(new SortSpec("attribute_value", SortDirection.ASCENDING, true));
        this._targetValuePriors = null;
        this._whereSpecs = new ArrayList<WhereSpec>();
        this._whereSpecs.add(new WhereSpec("attribute_name_subname", 1, "", false));
    }

    public CompareFilterSetting(CompareState compareState) {
        this._viewerState = compareState;
        this._fetchSize = this._modelViewerPrefenceSettings.getFetchSizeClusteringModel();
        this._filterAndSortByAbsolute = true;
        this._sortSpecs = new ArrayList<SortSpec>();
        if (this._viewerState.isSVM() || this._viewerState.isGLM() || this._viewerState.isAnomaly()) {
            this._sortSpecs.add(new SortSpec("propensity_target", SortDirection.DESCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_name_subname", SortDirection.ASCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_value", SortDirection.ASCENDING, true));
            this._minCoefficient = new BigDecimal(0.0);
            this._maxCoefficient = new BigDecimal(1.0);
        } else if (this._viewerState.isNB()) {
            this._sortSpecs.add(new SortSpec("propensity_target", SortDirection.DESCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_name_subname", SortDirection.ASCENDING, true));
            this._sortSpecs.add(new SortSpec("attribute_value", SortDirection.ASCENDING, true));
            this._minCoefficient = new BigDecimal(0.0);
            this._maxCoefficient = new BigDecimal(1.0);
        } else assert (false) : "Filter Panel does not supported specified model type.";
        this._targetValuePriors = null;
        this._whereSpecs = new ArrayList<WhereSpec>();
        this._whereSpecs.add(new WhereSpec("attribute_name_subname", 1, "", false));
    }

    public CompareFilterSetting(int n, BigDecimal bigDecimal, BigDecimal bigDecimal2, boolean bl, List<SortSpec> list, List<WhereSpec> list2, String string) {
        this._fetchSize = n;
        this.setMinCoefficient(bigDecimal);
        this.setMaxCoefficient(bigDecimal2);
        this._filterAndSortByAbsolute = false;
        this._sortSpecs = list;
        this._whereSpecs = list2;
        this._targetValuePriors = null;
    }

    public void setMinCoefficient(BigDecimal bigDecimal) {
        this._minCoefficient = bigDecimal;
    }

    public BigDecimal getMinCoefficient() {
        return this._minCoefficient;
    }

    public void setMaxCoefficient(BigDecimal bigDecimal) {
        this._maxCoefficient = bigDecimal;
    }

    public BigDecimal getMaxCoefficient() {
        return this._maxCoefficient;
    }

    public boolean getFilterAndSortByAbsolute() {
        return this._filterAndSortByAbsolute;
    }

    public void setFilterByAbsolute(boolean bl) {
        this._filterAndSortByAbsolute = bl;
    }

    public int getFetchSize() {
        return this._fetchSize;
    }

    public void setFetchSize(int n) {
        this._fetchSize = n;
    }

    public List<SortSpec> getSortSpecification() {
        return this._sortSpecs;
    }

    public void setSortSpecification(List<SortSpec> list) {
        this._sortSpecs = list;
    }

    public List<WhereSpec> getWhereSpecification() {
        return this._whereSpecs;
    }

    public void setWhereSpecification(List<WhereSpec> list) {
        this._whereSpecs = list;
    }

    public void setTargetValue(Object object) {
        this._targetValue = object;
    }

    public Object getTargetValue() {
        return this._targetValue;
    }

    public void setTargetValuePriors(List<TargetPriorsPredictionSet> list) {
        this._targetValuePriors = list;
    }

    public List<TargetPriorsPredictionSet> getTargetValuePriors() {
        return this._targetValuePriors;
    }

    public Object getNonSelectedBinaryClassValue() {
        if (this._targetValuePriors == null) {
            return null;
        }
        Object object = null;
        for (TargetPriorsPredictionSet targetPriorsPredictionSet : this._targetValuePriors) {
            if (this.getTargetValue().equals(targetPriorsPredictionSet.getPrediction())) continue;
            object = targetPriorsPredictionSet.getPrediction();
        }
        return object;
    }

    public Object getAnomalyNonSelectedBinaryClassValue() {
        if (this._targetValuePriors == null) {
            return null;
        }
        Object object = null;
        for (TargetPriorsPredictionSet targetPriorsPredictionSet : this._targetValuePriors) {
            if (this.getTargetValue().equals(targetPriorsPredictionSet.getPrediction())) continue;
            object = targetPriorsPredictionSet.getPrediction();
            break;
        }
        return object;
    }

    public boolean isBinaryClassModel() {
        if (this._targetValuePriors == null) {
            return false;
        }
        return this._targetValuePriors.size() == 2;
    }

    public CompareState getViewerState() {
        return this._viewerState;
    }

    public void setSecondTargetValue(Object object) {
        this._secondTargetValue = object;
    }

    public Object getSecondTargetValue() {
        return this._secondTargetValue;
    }

    public void setUseFilterSpecification(boolean bl) {
        this.bUseFilterSpec = bl;
    }

    public boolean isUseFilterSpecification() {
        return this.bUseFilterSpec;
    }

    public List<AttributeBiCoefficient> getItemFilters() {
        return Collections.emptyList();
    }
}

