/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator.modelnodes;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.common.build.MiningModelSettings;
import oracle.dmt.dataminer.navigator.modelnodes.AbstractModelNode;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.SupportVectorMachinesC;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;

public class SVMCModelNode
extends AbstractModelNode {
    private static final Logger theLogger = Logger.getLogger(SVMCModelNode.class.getName());
    private Boolean _isLinear;

    @Override
    public void setSchema(String string) {
        this._schema = string;
    }

    public Boolean isLinearKernel() {
        return this._isLinear;
    }

    @Override
    public void unload() {
        super.unload();
        this._isLinear = null;
    }

    @Override
    protected Model initModel() {
        SupportVectorMachinesC supportVectorMachinesC = new SupportVectorMachinesC(this.connManager, this._schema, this.modelName);
        this.loadLinearKernel();
        return supportVectorMachinesC;
    }

    private void loadLinearKernel() {
        if (null == this._isLinear) {
            Object object;
            Object object2;
            Object object3;
            Object object4 = this.getRepositoryData();
            String string = null;
            if (object4 instanceof ModelType) {
                object3 = (CSupportVectorMachineModelType)object4;
                object2 = object3.getCSupportVectorMachineAlgo();
                object = object2.getSVMSKERNELFUNCTION();
                if (object3.getStatus().equals((Object)ModelStatusType.COMPLETE) || object3.getStatus().equals((Object)ModelStatusType.WARNING)) {
                    if (object != null && ((String)object).equals("SVMS_LINEAR")) {
                        this._isLinear = true;
                    } else if (object != null && ((String)object).equals("SVMS_GAUSSIAN")) {
                        this._isLinear = false;
                    }
                    if (this._isLinear != null) {
                        return;
                    }
                }
                string = object3.getName();
            } else if (object4 instanceof ModelNodeType.Models.Model || object4 instanceof TestModelType.Model) {
                string = object4 instanceof ModelNodeType.Models.Model ? ((ModelNodeType.Models.Model)object4).getName() : ((TestModelType.Model)object4).getName();
            }
            try {
                object3 = this.getSchema();
                object2 = new Model(this.connManager, (String)object3, string);
                object = new ArrayList(1);
                object.add("SVMS_KERNEL_FUNCTION");
                List<MiningModelSettings> list = ((Model)object2).getModelSetting((List<String>)object);
                MiningModelSettings miningModelSettings = list.get(0);
                this._isLinear = miningModelSettings.getSettingValue().equals("SVMS_LINEAR");
            }
            catch (ODMrDAOException oDMrDAOException) {
                theLogger.log(Level.SEVERE, oDMrDAOException.getMessage(), oDMrDAOException);
            }
        }
    }
}

