/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator.modelnodes;

import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.common.build.ModelGeneralDescription;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;

public abstract class AbstractModelNode
extends BaseTreeNode
implements ModelNode {
    protected String _schema;
    protected String modelName;
    private boolean _exists;
    protected Model _odmModel;
    private Icon _icon;
    protected ConnectionManager connManager;

    public AbstractModelNode() {
    }

    public AbstractModelNode(URL uRL) {
        super(uRL);
    }

    @Override
    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("GENERIC_MODEL_NODE_ICON"));
        }
        return this._icon;
    }

    @Override
    public Model getOdmModel() {
        return this._odmModel;
    }

    @Override
    public boolean exists() {
        return this._exists;
    }

    protected void closeImpl() throws IOException {
        this.unload();
    }

    protected void openImpl() throws IOException {
        this.load();
    }

    @Override
    public boolean mayHaveChildren() {
        return false;
    }

    public void unload() {
        this._exists = false;
        this._odmModel = null;
    }

    @Override
    public void load() {
        this.loadImpl();
    }

    private void loadImpl() {
        try {
            this.connManager = (ConnectionFolder)this.getParent().getAncestor(ConnectionFolder.class, true);
            Object object = this.getRepositoryData();
            if (object instanceof ModelType) {
                ModelType modelType = (ModelType)object;
                this.modelName = modelType.getName();
            } else if (object instanceof TestModelType.Model) {
                TestModelType.Model model = (TestModelType.Model)object;
                this.modelName = model.getName();
            } else if (object instanceof ModelNodeType.Models.Model) {
                ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)object;
                this.modelName = model.getName();
            } else {
                throw new RuntimeException("Invalid state detected");
            }
            this._odmModel = this.initModel();
            this._odmModel.load();
            this._exists = !ModelGeneralDescription._NONE.equals(this._odmModel.getModelGeneralDescription());
        }
        catch (ODMrDAOException oDMrDAOException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)oDMrDAOException), (String)CommonLrb.get("MSG_EXCEPTION"));
        }
    }

    protected abstract Model initModel();

    @Override
    public void setSchema(String string) {
        this._schema = string;
    }

    @Override
    public String getSchema() {
        return this._schema;
    }
}

