/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.DatabaseProviderHelper;
import oracle.dbtools.connections.db.PasswordPrompter;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.sql.ConnectionProperties;
import oracle.dmt.dataminer.core.dal.sql.ReusableConnection;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.DataMinerNode;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.navigator.net.DMURLFormatHelper;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DataMinerConnections;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.i18n.text.OraDecimalFormatSymbols;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Version;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class ConnectionFolder
extends BaseTreeNode
implements ConnectionManager {
    private static final Logger theLogger = Logger.getLogger(ConnectionFolder.class.getName());
    private static final int SHARED_CONN_USE_CUTOFF = 3000;
    private static final Set<ConnectionFolder> instancesSet = new HashSet<ConnectionFolder>();
    private static final char DECIMAL_SEPARATOR = '.';
    private static final char GROUPING_SEPARATOR = ',';
    private static final String[] ALTER_SESSION_FIXES_11_2_0_3_UP = new String[]{"ALTER SESSION set NLS_NUMERIC_CHARACTERS = \".,\" "};
    private static final String[] RESET_SESSION_FIXES_11_2_0_3_UP = new String[]{"ALTER SESSION set NLS_NUMERIC_CHARACTERS = "};
    private static final String[] ALTER_SESSION_FIXES = new String[]{"ALTER SESSION set \"_optimizer_reuse_cost_annotations\" = false", "ALTER SESSION set NLS_NUMERIC_CHARACTERS = \".,\" "};
    private static final String[] RESET_SESSION_FIXES = new String[]{"ALTER SESSION set \"_optimizer_reuse_cost_annotations\" = true", "ALTER SESSION set NLS_NUMERIC_CHARACTERS = "};
    private long maxUniqueConnUseTime;
    private long maxSharedConnUseTime;
    private long uniqueConnectionOpened;
    private long shareConnectionUseCount;
    private long cumulativeSharedConnUseTime;
    private long cumulativeUniqueConnUseTime;
    private long uniqueConnectionCreatedCount;
    private boolean isConfiguring;
    private boolean isSharedConnAvailable;
    private String defaultNlsNumericChar = ".,";
    private String userName;
    private Boolean connectionIsValid;
    private Connection sharedConnection;
    private ReusableConnection sharedWrapper;
    private Boolean extendedTypeEnabled;
    private Boolean expandedObjNameEnabled;
    private Boolean legacyApplyOutputTypesEnabled;
    private Map<ConfigUtils.VersionInfoType, Version> connectionVersionInformation;

    public ConnectionFolder() {
        instancesSet.add(this);
        this.isSharedConnAvailable = true;
        this.connectionIsValid = false;
    }

    @Override
    public boolean isDeleteable() {
        return true;
    }

    public void setConfiguring(boolean bl) {
        this.isConfiguring = bl;
    }

    public boolean isConfiguring() {
        return this.isConfiguring;
    }

    private ReusableConnection getSharedConnection(ConnectionProperties[] connectionPropertiesArray) throws SQLException {
        if (this.sharedConnection == null || this.sharedConnection.isClosed()) {
            if (this.isConfiguring()) {
                throw new RuntimeException("Shared connection use is not allowed during configuration");
            }
            try {
                this.sharedConnection = DataMinerConnections.createPrivateConnection(this.getConnectionName());
                this.defaultNlsNumericChar = "\"" + ConnectionFolder.getCurrentNumericNLSSettingsFromDB(this.sharedConnection) + "\"";
                this.sharedWrapper = new ReusableConnection(this.sharedConnection, (ConnectionManager)this, connectionPropertiesArray);
            }
            catch (SQLException sQLException) {
                this.isSharedConnAvailable = true;
                throw sQLException;
            }
            catch (ConnectionException connectionException) {
                this.isSharedConnAvailable = true;
                if (connectionException.getCause() instanceof SQLException) {
                    throw (SQLException)connectionException.getCause();
                }
                throw new RuntimeException(connectionException);
            }
        } else {
            this.sharedWrapper.reuseConnection(this.sharedConnection, connectionPropertiesArray);
        }
        return this.sharedWrapper;
    }

    public Map<ConfigUtils.VersionInfoType, Version> getVersionInfo() throws SQLException {
        if (this.connectionVersionInformation == null) {
            Connection connection = null;
            try {
                connection = this.getConnection();
                this.connectionVersionInformation = ConfigUtils.getVersionInfo(connection);
            }
            finally {
                SQLHelper.close(connection);
            }
        }
        return this.connectionVersionInformation;
    }

    public boolean isExtendedTypeEnabled() {
        if (this.extendedTypeEnabled == null) {
            this.extendedTypeEnabled = ConfigUtils.isExtendedTypeEnabled(this);
        }
        return this.extendedTypeEnabled;
    }

    public boolean isExpandedObjNameEnabled() {
        if (this.expandedObjNameEnabled == null) {
            this.expandedObjNameEnabled = ConfigUtils.isExpandedObjNameEnabled(this);
        }
        return this.expandedObjNameEnabled;
    }

    public boolean isEnableLegacyApplyOutputTypes(Context context) {
        if (this.legacyApplyOutputTypesEnabled == null) {
            Version version = this.getDbVersion();
            boolean bl = DbVersionHelper.isDB121Up((Version)version);
            this.legacyApplyOutputTypesEnabled = bl ? Boolean.valueOf(DatabaseMetadataUtils.isEnableLegacyApplyOutputTypes(context)) : Boolean.TRUE;
        }
        return this.legacyApplyOutputTypesEnabled;
    }

    public String getUserAccountName() {
        if (this.userName == null) {
            this.userName = this.getUserNameFromDB();
        }
        return this.userName;
    }

    protected String getUserNameFromDB() {
        String string = null;
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string2 = "select SYS_CONTEXT ('USERENV', 'SESSION_USER') as USER_NAME from dual";
            sQLHelper.conn = this.getConnection();
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string2);
            if (sQLHelper.rs.next()) {
                string = sQLHelper.rs.getString("USER_NAME");
            }
        }
        if (!StringUtils.isDoubleQuotedString(string) && !string.equals(string.toUpperCase())) {
            string = StringUtils.addDoubleQuotes(string);
        }
        return string;
    }

    public Version getDbVersion() {
        try {
            this.getVersionInfo();
            return this.connectionVersionInformation.get((Object)ConfigUtils.VersionInfoType.DatabaseVersion);
        }
        catch (SQLException sQLException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)sQLException);
            return null;
        }
    }

    public Version getSchemaVersion() {
        try {
            this.getVersionInfo();
            return this.connectionVersionInformation.get((Object)ConfigUtils.VersionInfoType.XmlSchemaVersion);
        }
        catch (SQLException sQLException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)sQLException);
            return null;
        }
    }

    public Version getReposVersion() {
        try {
            this.getVersionInfo();
            return this.connectionVersionInformation.get((Object)ConfigUtils.VersionInfoType.RepositoryVersion);
        }
        catch (SQLException sQLException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)sQLException);
            return null;
        }
    }

    private static ReusableConnection getUniqueConnection(String string, ConnectionManager connectionManager, ConnectionProperties[] connectionPropertiesArray) {
        long l = System.currentTimeMillis();
        ReusableConnection reusableConnection = null;
        try {
            Connection connection = DataMinerConnections.createPrivateConnection(string);
            theLogger.log(Level.FINEST, "Time required to obtain unique connection in milliseconds: " + (System.currentTimeMillis() - l));
            reusableConnection = new ReusableConnection(connection, connectionManager, connectionPropertiesArray);
        }
        catch (ConnectionException connectionException) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)connectionException, (String)DialogsLrb.get("ERROR_TITLE"), (String)CommonLrb.get("MSG_EXCEPTION"), null);
        }
        return reusableConnection;
    }

    public static boolean isNumericFormatChangeRequired() {
        boolean bl = false;
        OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance((Locale)Locale.getDefault());
        OraDecimalFormatSymbols oraDecimalFormatSymbols = new OraDecimalFormatSymbols(oraLocaleInfo);
        bl = oraDecimalFormatSymbols.getDecimalSeparator() != '.' || oraDecimalFormatSymbols.getGroupingSeparator() != ',';
        return bl;
    }

    public static String getNumericFormatForLocale() {
        OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance((Locale)Locale.getDefault());
        OraDecimalFormatSymbols oraDecimalFormatSymbols = new OraDecimalFormatSymbols(oraLocaleInfo);
        String string = String.valueOf(oraDecimalFormatSymbols.getDecimalSeparator()) + String.valueOf(oraDecimalFormatSymbols.getGroupingSeparator());
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCurrentNumericNLSSettingsFromDB(Connection connection) throws SQLException {
        String string = null;
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string2 = "select parameter, value from NLS_SESSION_PARAMETERS \nwhere parameter = 'NLS_NUMERIC_CHARACTERS'";
            sQLHelper.pstmt = connection.prepareStatement(string2);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                string = sQLHelper.rs.getString("value");
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConnectionLocaleNumberFormat(Connection connection, String string) throws SQLException {
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string2 = "alter session set NLS_NUMERIC_CHARACTERS=\"" + string + "\"";
            sQLHelper.pstmt = connection.prepareStatement(string2);
            sQLHelper.pstmt.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setConnectionAlterSessionFixes(ReusableConnection reusableConnection) throws SQLException {
        try (SQLHelper sQLHelper = new SQLHelper();){
            String[] stringArray;
            Version version = reusableConnection.getDatabaseVersion();
            boolean bl = DbVersionHelper.isDB11203Up((Version)version);
            for (String string : stringArray = bl ? ALTER_SESSION_FIXES_11_2_0_3_UP : ALTER_SESSION_FIXES) {
                sQLHelper.pstmt = reusableConnection.prepareStatement(string);
                sQLHelper.pstmt.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetConnectionAlterSessionFixes(ReusableConnection reusableConnection) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        Version version = this.getDbVersion();
        boolean bl = DbVersionHelper.isDB11203Up((Version)version);
        String[] stringArray = bl ? RESET_SESSION_FIXES_11_2_0_3_UP : RESET_SESSION_FIXES;
        int n = bl ? 0 : 1;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                Object object = stringArray[i];
                if (i == n) {
                    object = (String)object + reusableConnection.getDefaultNlsNumericCharacters();
                }
                sQLHelper.pstmt = reusableConnection.prepareStatement((String)object);
                sQLHelper.pstmt.execute();
            }
        }
        finally {
            sQLHelper.close();
        }
    }

    public static String[] getConnectionAlterSessionFixes() {
        return ALTER_SESSION_FIXES;
    }

    public static Connection getSYSDBAConnection(String string, String string2, Properties properties) {
        Connection connection = null;
        try {
            connection = ConnectionFolder.getConnectionAs(string, string2, "SYSDBA", properties);
            connection = new ReusableConnection(connection, null, null);
        }
        catch (ConnectionException connectionException) {
            SQLException sQLException;
            int n;
            Throwable throwable = connectionException.getCause();
            if (throwable instanceof SQLException && (n = (sQLException = (SQLException)throwable).getErrorCode()) == 1017) {
                MessageDialog.critical((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("AUTHENTICATION_FAIL_MSG"), (String)DataminerNavigatorLrb.get("AUTHENTICATION_FAIL_TITLE"), null);
                return null;
            }
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)connectionException), (String)"Failed to connect to database.");
            return null;
        }
        catch (ConnectionCanceledException connectionCanceledException) {
            return null;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection getConnectionAs(String string, String string2, String string3, Properties properties) throws ConnectionException, ConnectionCanceledException {
        Properties properties2 = DatabaseConnections.getInstance().getProperties(string);
        Properties properties3 = (Properties)properties2.clone();
        properties3.remove("IS_PROXY");
        properties3.remove("PROXY_USER_PASSWORD");
        properties3.remove("PROXY_TYPE");
        properties3.remove("PROXY_USER_NAME");
        properties3.put("user", string2);
        properties3.remove("password");
        properties3.put("role", string3);
        properties3.put("SavePassword", "false");
        properties3.put("NoPasswordConnection", "true");
        properties3.remove("ConnName");
        properties3.remove("UnsharedWorksheetOriginalConnectionName");
        DatabaseProvider databaseProvider = DatabaseProvider.createFromProperties((Properties)properties3);
        Connection connection = null;
        boolean bl = true;
        try {
            while (bl) {
                try {
                    properties3.remove("password");
                    connection = databaseProvider.getConnection();
                    bl = false;
                    properties.putAll((Map<?, ?>)((Properties)properties3.clone()));
                }
                catch (ConnectionCanceledException connectionCanceledException) {
                    throw connectionCanceledException;
                }
                catch (SQLException sQLException) {
                    int n = sQLException.getErrorCode();
                    if (n != 1017 && n != 28150) continue;
                    MessageDialog.critical((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), (String)"Authentication Failure", null);
                }
            }
        }
        finally {
            PasswordPrompter passwordPrompter = DatabaseProviderHelper.getPasswordPrompter();
            passwordPrompter.disconnect(properties3);
        }
        return connection;
    }

    public String getUserAccountNameFromConnectionProperties() throws ConnectionException, DBException {
        Properties properties = DatabaseConnections.getInstance().getProperties(this.getLabel());
        String string = properties.getProperty("user");
        String string2 = string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase();
        assert (string != null) : "Username of a connection cannot be null";
        return string;
    }

    public Icon getIcon() {
        if (this.sharedConnection == null) {
            return OracleIcons.getIcon((String)"database.png");
        }
        return OracleIcons.getIcon((String)"dbconn.png");
    }

    public boolean isConnected() {
        return this.sharedConnection != null;
    }

    public static ConnectionFolder getConnectionFolder(Context context) {
        Object object;
        ConnectionFolder connectionFolder = null;
        Object object2 = context.getNode();
        if (object2 == null) {
            object = context.getSelection();
            assert (object != null) : "Selection is null";
            object2 = ((Element[])object).length != 0 ? (Node)object[0] : null;
        }
        object = (DataMinerNode)object2;
        connectionFolder = object2 == null ? null : (object2 instanceof Connections ? null : (object2 instanceof ConnectionFolder ? (ConnectionFolder)object2 : object.getConnectionFolder()));
        if (connectionFolder == null) {
            throw new RuntimeException("Expected state: could not find the connection folder that is a parent of the context");
        }
        return connectionFolder;
    }

    protected void closeConnection() {
        if (this.sharedConnection != null) {
            try {
                DataMinerConnections.closePrivateConnection(this.getLabel());
                this.connectionIsValid = false;
                this.connectionVersionInformation = null;
                this.extendedTypeEnabled = null;
                this.legacyApplyOutputTypesEnabled = null;
                this.sharedConnection.close();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            finally {
                this.sharedConnection = null;
            }
        }
    }

    public String getConnectionName() {
        return this.getLabel();
    }

    public static void delete(Element[] elementArray) throws ConnectionException, InterruptedException, InvocationTargetException {
        DatabaseConnections databaseConnections = DatabaseConnections.getInstance();
        final Connections connections = Connections.getInstance();
        for (Element element : elementArray) {
            final ConnectionFolder connectionFolder = (ConnectionFolder)element;
            databaseConnections.removeConnection(connectionFolder.getConnectionName());
            connectionFolder.closeConnection();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Iterator<Element> iterator = connectionFolder.getChildren();
                    while (iterator.hasNext()) {
                        ((DataMinerNode)iterator.next()).closeChildren();
                    }
                    connections.remove((Element)connectionFolder, true);
                    UpdateMessage.fireChildRemoved((Subject)connections, (Element)connectionFolder);
                    connections.markDirty(false);
                }
            });
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            this.closeNode();
        }
    }

    public void setConnectionValidated(Boolean bl) {
        this.connectionIsValid = bl;
    }

    public Boolean isConnectionValidated() {
        return this.connectionIsValid;
    }

    public boolean checkDatabase() throws SQLException {
        Boolean bl = ConfigUtils.isCompatibleDatabase(Context.newIdeContext((Node)this));
        if (bl == null) {
            return false;
        }
        if (!bl.booleanValue()) {
            MessageDialog.critical((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("INCOMPATIBLE_DB"), (String)DataminerNavigatorLrb.get("CONNECTION_ERROR"), null);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnection() throws ConnectionException, SQLException {
        ConfigUtils.ODMRSYS_STATUS oDMRSYS_STATUS;
        if (this.isConnectionValidated().booleanValue()) {
            return true;
        }
        if (!ConfigUtils.isValidUserConnection(this.getLabel()).booleanValue()) {
            MessageDialog.critical((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("SYSDBA_CONN_NOT_ALLOWED"), (String)DataminerNavigatorLrb.get("SYSDBA_CONN_NOT_ALLOWED_TITLE"), null);
            return false;
        }
        if (!this.checkDatabase()) {
            return false;
        }
        ConfigUtils.TextAndXMLDBState textAndXMLDBState = ConfigUtils.isTextAndXMLDBInstalled(this);
        if (textAndXMLDBState != ConfigUtils.TextAndXMLDBState.BOTH) {
            String string = "";
            switch (textAndXMLDBState) {
                case NONE: {
                    string = DataminerNavigatorLrb.get("NO_TEXT_OR_XMLDB_OPTION");
                    break;
                }
                case XML_DB_ONLY: {
                    string = DataminerNavigatorLrb.get("NO_TEXT_OPTION");
                    break;
                }
                case TEXT_ONLY: {
                    string = DataminerNavigatorLrb.get("NO_XMLDB_OPTION");
                    break;
                }
                default: {
                    string = DataminerNavigatorLrb.get("NO_DATAMINING_OPTION");
                }
            }
            MessageDialog.critical((Component)Ide.getMainWindow(), (Object)string, (String)DataminerNavigatorLrb.get("CONNECTION_ERROR"), (String)"textOrXMLDBAreMissing");
            return false;
        }
        if (this.getDbVersion().toCanonicalString().startsWith("13")) {
            MessageDialog.optionalInformation((String)"dbCompatibilityWarningId", (Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("NOT_CERTIFIED_ON_DB"), (String)"CONNECTION_WARNING", null);
        }
        if (!(oDMRSYS_STATUS = ConfigUtils.getODMRSYSRepositoryStatus(this)).equals((Object)ConfigUtils.ODMRSYS_STATUS.LOADED)) {
            String string = "";
            if (oDMRSYS_STATUS.equals((Object)ConfigUtils.ODMRSYS_STATUS.UNKNOWN)) {
                string = DataminerNavigatorLrb.get("REPOSITORY_MISSING_MSG");
            } else if (oDMRSYS_STATUS.equals((Object)ConfigUtils.ODMRSYS_STATUS.NOT_LOADED) || oDMRSYS_STATUS.equals((Object)ConfigUtils.ODMRSYS_STATUS.DETECT_ODMRSYS_PRESENT_BUT_NO_STATUS)) {
                string = DataminerNavigatorLrb.get("REPOSITORY_NOT_LOADED_MSG");
            }
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)DataminerNavigatorLrb.get("REPOSITORY_MISSING_TITLE"), null)) {
                return false;
            }
            boolean bl = ConfigUtils.privsForTablespace(this);
            if (!bl) {
                MessageDialog.critical((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("TABLESPACE_MISSING_PRIVS"), (String)DataminerNavigatorLrb.get("TABLESPACE_MISSING_PRIVS_TITTLE"), null);
                return false;
            }
            Connection connection = null;
            try {
                connection = this.getConnection();
                if (!ConfigUtils.isDatabaseCompatibilityLevelAcceptable(Context.newIdeContext((Node)this), connection, this.getDbVersion(), true)) {
                    boolean bl2 = false;
                    return bl2;
                }
            }
            finally {
                SQLHelper.close(connection);
            }
            this.configureConnection(Context.newIdeContext((Node)this), this.getShortLabel(), ConfigUtils.isBinaryInstallationRequired(this.getDbVersion()) ? ConfigUtils.RunMode.INSTALLSCHEMA_BINARY : ConfigUtils.RunMode.INSTALLSCHEMA_OR);
            return false;
        }
        ConfigUtils.Compatibility compatibility = null;
        try {
            compatibility = ConfigUtils.Compatibility.getCompatibility(Context.newIdeContext((Node)this));
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
            return false;
        }
        int n = compatibility.getCompatibilityLevel();
        Object object = null;
        try {
            object = this.getConnection();
            if (!(ConfigUtils.isODMPrivsPresent((Connection)object) || n != 1 && n != 9)) {
                SQLHelper.close((Connection)object);
                boolean bl = this.setupForUserAccountGranting();
                return bl;
            }
        }
        finally {
            SQLHelper.close((Connection)object);
        }
        if (n != 1) {
            String string = UtilsLrb.get("CLIENT_VERSION");
            String string2 = UtilsLrb.get("REPOS_VERSION");
            String string3 = UtilsLrb.get("DB_VERSION");
            if (n == 2) {
                String string4 = UtilsLrb.get("NOT_COMPAT_OLD_APP") + (String)string + compatibility.getClientVersion().toString() + "\n" + string2 + compatibility.getReposVersion().toString() + "\n";
                MessageDialog.critical((Component)Ide.getMainWindow(), (Object)string4, (String)UtilsLrb.get("NOT_COMPAT_OLD_APP_TITLE"), null);
                return false;
            }
            if (n == 5) {
                String string5 = UtilsLrb.get("REPOS_NOT_COMPATIBLE_OVERWRITE_PROMPT") + (String)string + compatibility.getClientVersion().toString() + "\n" + string2 + compatibility.getReposVersion().toString() + "\n";
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string5, (String)UtilsLrb.get("NOT_COMPAT_OLD_REPOS_TITLE"), null)) {
                    return false;
                }
                this.configureConnection(Context.newIdeContext((Node)this), this.getShortLabel(), ConfigUtils.isBinaryInstallationRequired(compatibility.getDBVersion()) ? ConfigUtils.RunMode.INSTALLSCHEMA_BINARY : ConfigUtils.RunMode.INSTALLSCHEMA_OR);
                return false;
            }
            if (n == 3 || n == 9) {
                String string6 = n == 9 ? UtilsLrb.get("DB_UPGRADE_BINARY_STORAGE_MIGRATE_PROMPT") + (String)string + compatibility.getClientVersion().toString() + "\n" + string2 + compatibility.getReposVersion().toString() + "\n" + string3 + compatibility.getDBVersion().toString() : UtilsLrb.get("REPOS_NOT_COMPATIBLE_UPGRADE_PROMPT") + (String)string + compatibility.getClientVersion().toString() + "\n" + string2 + compatibility.getReposVersion().toString() + "\n" + UtilsLrb.get("REPOS_VERSION_AFTER_UPGRADE") + ConfigUtils.getCurrentRepositoryVersion();
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string6, (String)UtilsLrb.get("REPOS_NOT_COMPATIBLE_UPGRADE_TITLE"), (String)"UpgradeRepository")) {
                    return false;
                }
                this.configureConnection(Context.newIdeContext((Node)this), this.getShortLabel(), ConfigUtils.isBinaryInstallationRequired(compatibility.getDBVersion()) ? ConfigUtils.RunMode.UPGRADE_REPOS_BINARY : ConfigUtils.RunMode.UPGRADE_REPOS_OR);
                return false;
            }
            if (n == 4) {
                String string7 = UtilsLrb.get("REPOS_NOT_COMPATIBLE_MIGRATE_PROMPT") + (String)string + compatibility.getClientVersion().toString() + "\n" + string2 + compatibility.getReposVersion().toString() + "\n" + UtilsLrb.get("REPOS_VERSION_AFTER_MIGRATE") + ConfigUtils.getCurrentRepositoryVersion();
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string7, (String)UtilsLrb.get("REPOS_NOT_COMPATIBLE_MIGRATE_TITLE"), null)) {
                    return false;
                }
                return false;
            }
            if (n == 6) {
                String string8 = UtilsLrb.get("REPOS_NOT_COMPATIBLE_OR_MIGRATABLE_PROMPT") + (String)string + compatibility.getClientVersion().toString() + "\n" + string2 + compatibility.getReposVersion().toString() + "\n";
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string8, (String)UtilsLrb.get("NOT_COMPAT_UNKNOWN_REPOS_TITLE"), null)) {
                    return false;
                }
                this.configureConnection(Context.newIdeContext((Node)this), this.getShortLabel(), ConfigUtils.isBinaryInstallationRequired(compatibility.getDBVersion()) ? ConfigUtils.RunMode.INSTALLSCHEMA_BINARY : ConfigUtils.RunMode.INSTALLSCHEMA_OR);
                return false;
            }
            if (n == 7) {
                String string9 = UtilsLrb.get("XML_SCHEMA_VERSION");
                String string10 = UtilsLrb.get("REPOS_NOT_COMPATIBLE_SCHEMA_MIGRATE_PROMPT") + (String)string + compatibility.getClientVersion().toString() + "\n" + string2 + compatibility.getReposVersion().toString() + "\n" + string3 + compatibility.getDBVersion().toString() + "\n" + string9 + compatibility.getXmlSchemaVersion().toString() + "\n";
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string10, (String)UtilsLrb.get("XML_SCHEMA_NOT_COMPATIBLE_MIGRATE_TITLE"), null)) {
                    return false;
                }
                this.configureConnection(Context.newIdeContext((Node)this), this.getShortLabel(), ConfigUtils.isBinaryInstallationRequired(compatibility.getDBVersion()) ? ConfigUtils.RunMode.UPGRADE_REPOS_BINARY : ConfigUtils.RunMode.UPGRADE_REPOS_OR);
                return false;
            }
        }
        compatibility = this.getDbVersion();
        ArrayList<String> arrayList = ConfigUtils.isODMUserPrivsPresent(this);
        if (!arrayList.isEmpty()) {
            object = new StringBuilder();
            for (String string2 : arrayList) {
                ((StringBuilder)object).append(string2 + "\n");
            }
            theLogger.log(Level.FINEST, "Missing DataMiner Grants:\n" + (StringBuilder)object);
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("GRANTS_DIRECT_USER_MISSING_MSG"), (String)DataminerNavigatorLrb.get("GRANTS_MISSING_TITLE"), null)) {
                return false;
            }
            this.configureConnection(Context.newIdeContext((Node)this), this.getShortLabel(), ConfigUtils.RunMode.GRANTS);
            return false;
        }
        boolean bl = DbVersionHelper.isDB12102Up((Version)compatibility);
        boolean bl3 = DbVersionHelper.isDB122Up((Version)compatibility);
        boolean bl4 = ConfigUtils.isJSONSchemaGeneratorInstalled(this);
        if (bl && !bl3 && !bl4) {
            theLogger.log(Level.FINEST, "Missing Data Miner Repository Support for generating JSON Schema");
            MessageDialog.optionalInformation((String)"odmrMissingJSONSchemaWarningId", (Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("JSON_SCHEMA_GEN_NOT_INSTALLED"), (String)DataminerNavigatorLrb.get("CONNECTION_WARNING"), null);
        }
        this.setConnectionValidated(Boolean.TRUE);
        return true;
    }

    private boolean setupForUserAccountGranting() {
        boolean bl = ConfigUtils.privsForTablespace(this);
        if (!bl) {
            MessageDialog.critical((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("TABLESPACE_MISSING_PRIVS"), (String)DataminerNavigatorLrb.get("TABLESPACE_MISSING_PRIVS_TITTLE"), null);
            return false;
        }
        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DataminerNavigatorLrb.get("GRANTS_MISSING_MSG"), (String)DataminerNavigatorLrb.get("GRANTS_MISSING_TITLE"), null)) {
            return false;
        }
        this.configureConnection(Context.newIdeContext((Node)this), this.getShortLabel(), ConfigUtils.RunMode.GRANTS);
        return false;
    }

    public String getQualifiedConnectionName() {
        String string = DMURLFormatHelper.getConnectionName(this.getURL());
        return DataMinerConnections.getQualifiedName(string);
    }

    private void configureConnection(final Context context, final String string, final ConfigUtils.RunMode runMode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigUtils.configureConnection(context, string, runMode);
            }
        });
    }

    protected void closeImpl() throws IOException {
        this.closeConnection();
    }

    public static final Connection getConnection(String string) {
        return ConnectionFolder.getConnection(string, new ConnectionProperties[0]);
    }

    public static final Connection getConnection(String string, ConnectionProperties ... connectionPropertiesArray) {
        ReusableConnection reusableConnection = ConnectionFolder.getUniqueConnection(string, null, connectionPropertiesArray);
        ConnectionFolder.setConnectionProperties(reusableConnection, connectionPropertiesArray);
        return reusableConnection;
    }

    public static final Connection getConnection(Context context) throws SQLException {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        assert (connectionFolder != null) : "ConnectionFolder object cannot be null";
        return connectionFolder.getConnection();
    }

    public static final Connection getConnection(Context context, ConnectionProperties ... connectionPropertiesArray) throws SQLException {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        assert (connectionFolder != null) : "ConnectionFolder object cannot be null";
        return connectionFolder.getConnection(connectionPropertiesArray);
    }

    public static String getUserAccountName(Context context) {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        assert (connectionFolder != null) : "Unable to get connection information.";
        return connectionFolder.getUserAccountName();
    }

    public static String getConnectionName(Context context) {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        assert (connectionFolder != null) : "ConnectionFolder object cannot be null";
        return connectionFolder.getConnectionName();
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(new ConnectionProperties[0]);
    }

    public synchronized Connection getConnection(ConnectionProperties ... connectionPropertiesArray) throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        for (ConnectionProperties connectionProperties : connectionPropertiesArray) {
            if (connectionProperties != ConnectionProperties.UNIQUE) continue;
            bl2 = true;
            break;
        }
        Object[] objectArray = null;
        if (this.isSharedConnAvailable && !bl2) {
            bl = true;
            this.isSharedConnAvailable = false;
            ++this.shareConnectionUseCount;
            objectArray = new Object[]{"Shared", this.shareConnectionUseCount, this.uniqueConnectionCreatedCount, this.uniqueConnectionOpened};
        } else {
            ++this.uniqueConnectionCreatedCount;
            ++this.uniqueConnectionOpened;
            objectArray = new Object[]{"Unique", this.shareConnectionUseCount, this.uniqueConnectionCreatedCount, this.uniqueConnectionOpened};
        }
        theLogger.log(Level.FINEST, "Connection obtained [{0}] Shared: {1} Unique: {2} Unique Opened: {3}", objectArray);
        if (ConfigUtils.isDebugBuild()) {
            StringBuilder stringBuilder = new StringBuilder(objectArray[0].toString());
            stringBuilder.append(" connection obtained by: \n");
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                stringBuilder.append(stackTraceElement.toString());
                stringBuilder.append("\n");
            }
            theLogger.log(Level.FINEST, stringBuilder.toString());
        }
        ReusableConnection reusableConnection = bl ? this.getSharedConnection(connectionPropertiesArray) : ConnectionFolder.getUniqueConnection(this.getLabel(), this, connectionPropertiesArray);
        ConnectionFolder.setConnectionProperties(reusableConnection, connectionPropertiesArray);
        reusableConnection.setDefaultNlsNumericCharacters(this.defaultNlsNumericChar);
        return reusableConnection;
    }

    private static void setConnectionProperties(ReusableConnection reusableConnection, ConnectionProperties[] connectionPropertiesArray) {
        block5: for (ConnectionProperties connectionProperties : connectionPropertiesArray) {
            switch (connectionProperties) {
                case ALTER_SESSION_FIXES: {
                    try {
                        ConnectionFolder.setConnectionAlterSessionFixes(reusableConnection);
                    }
                    catch (SQLException sQLException) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)sQLException, (String)DialogsLrb.get("ERROR_TITLE"), (String)CommonLrb.get("MSG_EXCEPTION"), null);
                    }
                    continue block5;
                }
            }
        }
    }

    private void resetConnectionProperties(ReusableConnection reusableConnection, ConnectionProperties[] connectionPropertiesArray) {
        block5: for (ConnectionProperties connectionProperties : connectionPropertiesArray) {
            switch (connectionProperties) {
                case ALTER_SESSION_FIXES: {
                    try {
                        this.resetConnectionAlterSessionFixes(reusableConnection);
                    }
                    catch (SQLException sQLException) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)sQLException, (String)DialogsLrb.get("ERROR_TITLE"), (String)CommonLrb.get("MSG_EXCEPTION"), null);
                    }
                    continue block5;
                }
            }
        }
    }

    public synchronized void releaseConnection(ReusableConnection reusableConnection) {
        boolean bl = false;
        long l = System.currentTimeMillis();
        long l2 = l - reusableConnection.getStartTime();
        if (reusableConnection.getConnection() == this.sharedConnection) {
            this.resetConnectionProperties(reusableConnection, reusableConnection.getConnectionProperties());
            if (l2 > this.maxSharedConnUseTime) {
                this.maxSharedConnUseTime = l2;
            }
            this.cumulativeSharedConnUseTime += l2;
            this.isSharedConnAvailable = true;
            bl = true;
        } else {
            if (l2 > this.maxUniqueConnUseTime) {
                this.maxUniqueConnUseTime = l2;
            }
            this.cumulativeUniqueConnUseTime += l2;
            --this.uniqueConnectionOpened;
        }
        if (bl) {
            if (ConfigUtils.isDebugBuild() && l2 > 3000L) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Shared conn used more than ");
                stringBuilder.append(3000);
                stringBuilder.append(" miliseconds at: ");
                for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                    stringBuilder.append(stackTraceElement.toString());
                    stringBuilder.append("\n");
                }
                theLogger.finest(stringBuilder.toString());
            }
        } else {
            SQLHelper.close(reusableConnection.getConnection());
        }
    }

    public void writeStatistics() {
        if (ConfigUtils.isDebugBuild()) {
            String string = System.getProperty("ide.system.dir") + "DataMinerConnections.log";
            File file = new File(string);
            try (FileWriter fileWriter = new FileWriter(file, true);){
                fileWriter.write("[" + new Date().toString() + "] on " + this.getConnectionName());
                fileWriter.write(System.lineSeparator());
                fileWriter.write(this.getConnectionStatistics());
                fileWriter.write(System.lineSeparator());
                fileWriter.write(System.lineSeparator());
            }
            catch (IOException iOException) {
                theLogger.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    private String getConnectionStatistics() {
        return "Shared Connection Used Count = " + this.shareConnectionUseCount + ", Max Shared Connection Use Time = " + this.maxSharedConnUseTime + ", Average Shared Connection Use Time = " + Long.valueOf(this.cumulativeSharedConnUseTime).doubleValue() / (double)this.shareConnectionUseCount + ", Unique Connection Creation Count = " + this.uniqueConnectionCreatedCount + ", Max Unique Connection Use Time = " + this.maxUniqueConnUseTime + ", Average Unique Connection Use Time = " + Long.valueOf(this.cumulativeUniqueConnUseTime).doubleValue() / (double)this.uniqueConnectionCreatedCount;
    }

    public static void shutdown() {
        for (ConnectionFolder connectionFolder : instancesSet) {
            connectionFolder.writeStatistics();
        }
    }
}

