/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import oracle.dmt.dataminer.controls.CostMatrixDataProvider;
import oracle.dmt.dataminer.controls.ReadOnlyCostMatrixModel;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetMiningModelAttributesQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetModelSettingsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetTextFeaturesQuery;
import oracle.dmt.dataminer.core.model.clas.common.CostMatrixInfo;
import oracle.dmt.dataminer.core.model.clas.common.MatrixInfo;
import oracle.dmt.dataminer.core.model.common.build.MiningAttributeInfo;
import oracle.dmt.dataminer.core.model.common.build.MiningModelSettings;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.common.build.TextFeature;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerAggregatesTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerFeaturesTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerGeneralTreeTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerSignatureTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerTextAttrsTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerWeightTableModel;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ARModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.EMClusterModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ESAModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.KMModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NMFModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.OCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.PCAModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVDModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMRModelNode;
import oracle.dmt.dataminer.server.model.MiningModelAttributes;
import oracle.dmt.dataminer.server.model.PartitionModelAttributeInfo;
import oracle.dmt.dataminer.server.model.PartitionModelViewerAttributes;
import oracle.dmt.dataminer.server.model.TargetPriorsPredictionSet;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TargetValues;
import oracle.ide.Context;
import oracle.ide.explorer.TNode;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.util.Version;

public class SettingsViewerState
extends BaseViewerState {
    private boolean _loaded;
    private SettingsViewerSignatureTableModel _signatureTableModel;
    private SettingsViewerGeneralTreeTableModel _treetableModel = new SettingsViewerGeneralTreeTableModel();
    private SettingsViewerFeaturesTableModel _featuresTableModel;
    private SettingsViewerTextAttrsTableModel _textAttrsTableModel;
    private List<PartitionModelAttributeInfo> partitionColumns;
    private GenericBaseTableModel _weightsModel;
    private SettingsViewerAggregatesTableModel _aggregatesTableModel;
    private List<TextFeature> _textFeatures;
    private MiningAttributeInfo _lastSelectedAttr;
    private MiningAttributeInfo _lastSelectedTextAttr;
    private ReadOnlyCostMatrixModel _costMatrixModel;
    private TargetValues _targetValues;

    public SettingsViewerState(Context context) {
        super(context);
    }

    public HelpInfo getHelpInfo() {
        ModelNode modelNode = (ModelNode)this.context.getNode();
        String string = "Help Topic Not Specified";
        if (modelNode instanceof ARModelNode) {
            string = "ar_view_settings";
        } else if (modelNode instanceof DTModelNode) {
            string = "tree_diagram_settings";
        } else if (modelNode instanceof GLMCModelNode) {
            string = "glmc_settings";
        } else if (modelNode instanceof GLMRModelNode) {
            string = "glmr_settings_help";
        } else if (modelNode instanceof SVMCModelNode) {
            string = "svmc_settings";
        } else if (modelNode instanceof ANModelNode) {
            string = "ad_viewer_settings";
        } else if (modelNode instanceof SVMRModelNode) {
            string = "svmr_settings";
        } else if (modelNode instanceof NMFModelNode) {
            string = "nmf_viewer_settings";
        } else if (modelNode instanceof NBModelNode) {
            string = "nb_viewer_settings";
        } else if (modelNode instanceof OCModelNode) {
            string = "oc_viewer_settings";
        } else if (modelNode instanceof KMModelNode) {
            string = "km_viewer_settings";
        } else if (modelNode instanceof EMClusterModelNode) {
            string = "clus_viewer_settings";
        } else if (modelNode instanceof PCAModelNode) {
            string = "pca_viewer_settings";
        } else if (modelNode instanceof SVDModelNode) {
            string = "svd_viewer_settings";
        } else if (modelNode instanceof ESAModelNode) {
            string = "esa_viewer_settings";
        }
        return new HelpInfo(string);
    }

    public void loadTempStatusTreeTable(String string) {
        this._treetableModel.loadTempStatusNode(string);
    }

    private void loadTargetAttribute() {
        this.modelViewerState.getModelDesc().setTargetAttributeName(this._signatureTableModel.getTargetAttributeName());
    }

    private void loadTextAttributes() {
        List<MiningAttributeInfo> list = this._signatureTableModel.getTextAttributesInfo();
        this._textAttrsTableModel = new SettingsViewerTextAttrsTableModel(list);
    }

    public void loadTextFeatures(String string) throws ODMrDAOException {
        ModelDescriptor modelDescriptor = new ModelDescriptor(this.getUserName(), this.getModelName());
        GetTextFeaturesQuery getTextFeaturesQuery = new GetTextFeaturesQuery(this.connectionManager.getDbVersion(), modelDescriptor, string);
        List list = this.dao.readItems((Query)getTextFeaturesQuery);
        this._featuresTableModel = new SettingsViewerFeaturesTableModel(list);
    }

    public void load(PartitionVO partitionVO) throws Exception {
        this._loaded = false;
        this.loadPartitionKeys(partitionVO.getPartitionID());
        if (!this.isAR() && !this.isAI()) {
            ModelDescriptor modelDescriptor = new ModelDescriptor(this.modelViewerState.getUserName(), this.modelViewerState.getModelName(), partitionVO.getPartitionID());
            this.loadAttributes(modelDescriptor);
            if (!this.isAnomaly()) {
                this.loadTargetAttribute();
            }
            this.loadTextAttributes();
        }
        if (this.isClassification()) {
            this.loadCostMatrix(partitionVO.getPartitionID());
            if (!this.isAnomaly()) {
                this.loadWeights(partitionVO.getPartitionID());
                this.loadTargetValues(partitionVO);
            }
        }
        if (this.isAR()) {
            this.loadAggregates(this.modelViewerState.getUserName(), this.modelViewerState.getModelName());
        }
        this._loaded = true;
    }

    public void loadTree(String string) throws ODMrDAOException {
        this._treetableModel.loadTree(this.modelViewerState.getOdmModel(), this.connectionManager, string);
    }

    public int getMaxStringLength() {
        return this._treetableModel.getMaxStringLength();
    }

    private void loadTargetValues(PartitionVO partitionVO) throws ODMrDAOException {
        List<TargetPriorsPredictionSet> list = this.getClassification().getTargetValuePredictionSet(partitionVO);
        boolean bl = false;
        if (list.size() > 0) {
            bl = list.get(0).getPredictionDataType() == 1 || list.get(0).getPredictionDataType() == 12;
        } else {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        TargetValues targetValues = new TargetValues();
        for (TargetPriorsPredictionSet targetPriorsPredictionSet : list) {
            if (bl) {
                arrayList.add((String)targetPriorsPredictionSet.getPrediction());
                continue;
            }
            arrayList2.add(((BigDecimal)targetPriorsPredictionSet.getPrediction()).doubleValue());
        }
        if (bl) {
            targetValues.getTargetValueString().addAll(arrayList);
        } else {
            targetValues.getTargetValueNumber().addAll(arrayList2);
        }
        this._targetValues = targetValues;
    }

    private void loadPartitionKeys(String string) throws ODMrDAOException {
        if (DbVersionHelper.isDB122Up((Version)this.connectionManager.getDbVersion())) {
            PartitionModelViewerAttributes partitionModelViewerAttributes = PartitionModelViewerAttributes.getPartitionModelViewerAttributes(this.connectionManager, this.getUserName(), string, this.getModelName());
            if (partitionModelViewerAttributes == null) {
                throw new DataMinerException(SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_TITLE"));
            }
            this.partitionColumns = partitionModelViewerAttributes.getAttributes();
        } else {
            this.partitionColumns = Collections.emptyList();
        }
    }

    private void loadAttributes(ModelDescriptor modelDescriptor) throws ODMrDAOException {
        Object object;
        TNode tNode;
        WorkflowNode workflowNode;
        WorkflowModel workflowModel;
        Map<String, ModelType> map;
        ModelType modelType;
        List list = Collections.emptyList();
        MiningAttributes miningAttributes = null;
        Node node = this.context.getNode();
        if (node instanceof BaseTreeNode && (modelType = (map = (workflowModel = (workflowNode = (WorkflowNode)(tNode = ((BaseTreeNode)(object = (BaseTreeNode)node)).getParent()).getAncestor(WorkflowNode.class)).getWorkflowModel()).getAllMiningModels()).get(modelDescriptor.getName())) != null && (miningAttributes = modelType.getInputMiningData().getMiningAttributes()) != null) {
            list = miningAttributes.getMiningAttribute();
        }
        if (((MiningModelAttributes)(object = this.loadMiningModelAttributes(modelDescriptor, list))).getAttributes().isEmpty()) {
            throw new DataMinerException(SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_TITLE"));
        }
        this._signatureTableModel = new SettingsViewerSignatureTableModel(this.connectionManager.getDbVersion(), ((MiningModelAttributes)object).getAttributes());
    }

    private MiningModelAttributes loadMiningModelAttributes(ModelDescriptor modelDescriptor, List<MiningAttributeType> list) throws ODMrDAOException {
        GetMiningModelAttributesQuery getMiningModelAttributesQuery = new GetMiningModelAttributesQuery(this.connectionManager.getDbVersion(), modelDescriptor);
        List list2 = this.dao.readItems((Query)getMiningModelAttributesQuery);
        Map<String, String> map = list.stream().collect(Collectors.toMap(AttributeType::getName, MiningAttributeType::getAutoPrep));
        for (MiningAttributeInfo miningAttributeInfo : list2) {
            String string = map.get(miningAttributeInfo.getAttributeName());
            miningAttributeInfo.setDataPrep("Yes".equals(string));
        }
        MiningModelAttributes miningModelAttributes = new MiningModelAttributes(modelDescriptor.getSchema(), modelDescriptor.getName());
        miningModelAttributes.setAttributes(list2);
        return miningModelAttributes;
    }

    private void loadCostMatrix(String string) throws ODMrDAOException {
        this.getModel().setPartitionId(string);
        CostMatrixInfo costMatrixInfo = this.getModel().getModelScoreCostMatrix();
        this._costMatrixModel = !costMatrixInfo.isCostMatrixTrue() || costMatrixInfo.isEmpty() ? null : new ReadOnlyCostMatrixModel(new CostMatrixDataProvider(costMatrixInfo));
    }

    private void loadWeights(String string) throws ODMrDAOException {
        MatrixInfo matrixInfo;
        CostMatrixInfo costMatrixInfo;
        this.getModel().setPartitionId(string);
        this._weightsModel = this.isDT() ? (!(costMatrixInfo = this.getModel().getModelScoreCostMatrix()).isCostMatrixTrue() || costMatrixInfo.isEmpty() ? null : new ReadOnlyCostMatrixModel(new CostMatrixDataProvider(costMatrixInfo))) : ((matrixInfo = this.getMaxtrixInfo(string)) == null || matrixInfo.isEmpty() ? null : new SettingsViewerWeightTableModel(matrixInfo));
    }

    private MatrixInfo getMaxtrixInfo(String string) throws ODMrDAOException {
        this.getModel().setPartitionId(string);
        MatrixInfo matrixInfo = this.getModel().getClassWeights();
        return matrixInfo;
    }

    private void loadAggregates(String string, String string2) throws ODMrDAOException {
        GetModelSettingsQuery getModelSettingsQuery = new GetModelSettingsQuery(this.connectionManager.getDbVersion()).setModel(string2).setOwner(string).setSettingsFilter("ASSO_AGGREGATES", new String[0]);
        Optional optional = this.dao.readItem((Query)getModelSettingsQuery);
        List<String> list = Collections.emptyList();
        if (optional.isPresent()) {
            String[] stringArray = ((MiningModelSettings)optional.get()).getSettingValue().split(",");
            list = Arrays.asList(stringArray);
        }
        this._aggregatesTableModel = new SettingsViewerAggregatesTableModel(list);
    }

    public SettingsViewerSignatureTableModel getSignatureTableModel() {
        return this._signatureTableModel;
    }

    public List<PartitionModelAttributeInfo> getPartitionKeys() {
        return this.partitionColumns;
    }

    public GenericBaseTableModel getWeightsModel() {
        assert (this._loaded) : "Accesing model weights prior to loading.";
        return this._weightsModel;
    }

    public ReadOnlyCostMatrixModel getCostMatrix() {
        assert (this._loaded) : "Accesing model cost benefit info prior to loading.";
        return this._costMatrixModel;
    }

    public SettingsViewerGeneralTreeTableModel getGeneralTreeTableModel() {
        return this._treetableModel;
    }

    public MiningAttributeInfo getLastSelectedAttribute() {
        return this._lastSelectedAttr;
    }

    public void setLastSelectedAttribute(int n) {
        if (n == -1) {
            this._lastSelectedAttr = null;
            return;
        }
        this._lastSelectedAttr = (MiningAttributeInfo)this._signatureTableModel.getSrcData().get(n);
    }

    public TargetValues getTargetValues() {
        return this._targetValues;
    }

    public MiningAttributeInfo getLastSelectedTextAttribute() {
        return this._lastSelectedTextAttr;
    }

    public void setLastSelectedTextAttribute(int n) {
        if (n == -1) {
            this._lastSelectedTextAttr = null;
            return;
        }
        this._lastSelectedTextAttr = (MiningAttributeInfo)this._textAttrsTableModel.getSrcData().get(n);
    }

    public SettingsViewerTextAttrsTableModel getTextAttrsTableModel() {
        if (this._textAttrsTableModel == null) {
            this._textAttrsTableModel = new SettingsViewerTextAttrsTableModel();
        }
        return this._textAttrsTableModel;
    }

    public SettingsViewerFeaturesTableModel getFeaturesTableModel() {
        if (this._featuresTableModel == null) {
            this._featuresTableModel = new SettingsViewerFeaturesTableModel();
        }
        return this._featuresTableModel;
    }

    public SettingsViewerAggregatesTableModel getAggregatesTableModel() {
        if (this._aggregatesTableModel == null) {
            this._aggregatesTableModel = new SettingsViewerAggregatesTableModel();
        }
        return this._aggregatesTableModel;
    }

    public List<TextFeature> getTextFeatures() {
        return this._textFeatures;
    }
}

