/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.model.common.build.MiningAttributeInfo;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.javatools.util.Version;

class SettingsViewerSignatureTableModel
extends ODMrTableModel<MiningAttributeInfo> {
    static final int ATTRIBUTE_NAME = 0;
    static final int DATA_TYPE = 1;
    static final int MINING_TYPE = 2;
    static final int IS_TARGET = 3;
    static final int DATA_PREP = 4;
    static final int PARTITION_KEY = 5;
    private static final String[] COLUMNS = new String[]{CoreCommonLrb.get((String)"NAME"), CoreCommonLrb.get((String)"DATA_TYPE"), CoreCommonLrb.get((String)"MINING_TYPE"), CoreCommonLrb.get((String)"TARGET"), SettingsLrb.get("DATA_PREP")};
    private static final String[] COLUMNS_12_2 = new String[]{CoreCommonLrb.get((String)"NAME"), CoreCommonLrb.get((String)"DATA_TYPE"), CoreCommonLrb.get((String)"MINING_TYPE"), CoreCommonLrb.get((String)"TARGET"), SettingsLrb.get("DATA_PREP"), SettingsLrb.get("PARTITION_KEY")};

    SettingsViewerSignatureTableModel(Version version) {
        this(version, new ArrayList<MiningAttributeInfo>());
    }

    SettingsViewerSignatureTableModel(Version version, List<MiningAttributeInfo> list) {
        if (DbVersionHelper.isDB122Up((Version)version)) {
            this.setColumnIdentifiers(COLUMNS_12_2);
        } else {
            this.setColumnIdentifiers(COLUMNS);
        }
        this.setSrcData(list);
    }

    public String getTargetAttributeName() {
        String string = null;
        for (MiningAttributeInfo miningAttributeInfo : this.srcData) {
            if (!"YES".equals(miningAttributeInfo.getTarget())) continue;
            string = miningAttributeInfo.getAttributeName();
            break;
        }
        return string;
    }

    public MiningAttributeInfo getTargetAttributeInfo() {
        MiningAttributeInfo miningAttributeInfo = null;
        for (MiningAttributeInfo miningAttributeInfo2 : this.srcData) {
            if (!"YES".equals(miningAttributeInfo2.getTarget())) continue;
            miningAttributeInfo = miningAttributeInfo2;
            break;
        }
        return miningAttributeInfo;
    }

    public List<MiningAttributeInfo> getTextAttributesInfo() {
        ArrayList<MiningAttributeInfo> arrayList = new ArrayList<MiningAttributeInfo>();
        for (MiningAttributeInfo miningAttributeInfo : this.srcData) {
            if (!"TEXT".equals(miningAttributeInfo.getAttributeType())) continue;
            arrayList.add(miningAttributeInfo);
        }
        return arrayList;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        MiningAttributeInfo miningAttributeInfo = (MiningAttributeInfo)this.srcData.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = miningAttributeInfo.getAttributeName();
                break;
            }
            case 1: {
                string = miningAttributeInfo.getDataType();
                break;
            }
            case 2: {
                string = ServerConstants.MiningType.toHuman((String)miningAttributeInfo.getAttributeType());
                break;
            }
            case 3: {
                if ("YES".equals(miningAttributeInfo.getTarget())) {
                    string = CoreCommonLrb.get((String)"YES");
                    break;
                }
                string = CoreCommonLrb.get((String)"NO");
                break;
            }
            case 4: {
                StringBuilder stringBuilder = miningAttributeInfo.getExpression();
                if (miningAttributeInfo.getDataType().equals("DM_NESTED_NUMERICALS") || miningAttributeInfo.getDataType().equals("DM_NESTED_CATEGORICALS") || miningAttributeInfo.getDataType().equals("DM_NESTED_BINARY_DOUBLES") || miningAttributeInfo.getDataType().equals("DM_NESTED_BINARY_FLOATS") || miningAttributeInfo.getDataType().equals("NESTED TABLE")) {
                    if (stringBuilder.toString().equals(miningAttributeInfo.getRevExpression().toString()) && -1 != stringBuilder.toString().indexOf("value")) {
                        string = CoreCommonLrb.get((String)"NO");
                        break;
                    }
                    string = CoreCommonLrb.get((String)"YES");
                    break;
                }
                if (miningAttributeInfo.isDataPrep()) {
                    string = CoreCommonLrb.get((String)"YES");
                    break;
                }
                string = "";
                break;
            }
            case 5: {
                if ("YES".equals(miningAttributeInfo.getPartitionKey().toUpperCase())) {
                    string = CoreCommonLrb.get((String)"YES");
                    break;
                }
                string = CoreCommonLrb.get((String)"NO");
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing model attributes";
                break;
            }
        }
        if (string == null) {
            return "NULL";
        }
        return string;
    }
}

