/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.features;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.CoreServerConstantsLrb;
import oracle.dmt.dataminer.core.model.fe.common.FeatureCoefficient;
import oracle.dmt.dataminer.core.model.fe.common.FeatureItemSet;
import oracle.dmt.dataminer.core.utils.res.ARLrb;

public class ESAFeatureItemsTableModel
extends ODMrTableModel<FeatureItemSet> {
    private static final int FEATURE_ID = 0;
    private static final int ITEMS = 1;
    private static final String[] COLUMN_NAMES = new String[]{CoreServerConstantsLrb.get((String)"MODEL_PREDICTION_FEATURE_ID"), ARLrb.get((String)"ITEMSETS_ITEMS")};
    Map<String, String> featureItemMap;

    public ESAFeatureItemsTableModel() {
        super(COLUMN_NAMES);
    }

    public void setFeatureItemMappings(List<FeatureCoefficient> list) {
        if (list != null) {
            this.featureItemMap = list.stream().collect(Collectors.collectingAndThen(Collectors.groupingBy(featureCoefficient -> featureCoefficient.getFeatureId(), Collectors.mapping(featureCoefficient -> featureCoefficient.getAttributeSubname(), Collectors.joining(" "))), Collections::unmodifiableMap));
        }
        List list2 = this.featureItemMap.entrySet().stream().map(entry -> new FeatureItemSet((String)entry.getKey(), null, (String)entry.getValue())).collect(Collectors.toList());
        this.clear();
        this.addRows(list2);
    }

    public void setFeatureItemData(List<FeatureItemSet> list) {
        if (list == null) {
            return;
        }
        this.clear();
        this.addRows(list);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        FeatureItemSet featureItemSet = (FeatureItemSet)this.srcData.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = featureItemSet.getFeatureId();
                break;
            }
            case 1: {
                string = featureItemSet.getItems();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        return string == null ? "" : string;
    }
}

