/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree.model;

import ilog.views.sdm.model.IlvAbstractSDMModel;
import ilog.views.sdm.model.IlvMutableSDMNode;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.mviewer.dt.schema.Node;
import oracle.dmt.dataminer.mviewer.dt.schema.PMML;
import oracle.dmt.dataminer.mviewer.dt.schema.ScoreDistribution;
import oracle.dmt.dataminer.mviewer.dt.schema.TreeModel;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeLink;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeNode;
import oracle.ide.Context;

public class DecisionTreeSDMModel
extends IlvAbstractSDMModel {
    private static final Logger theLogger = Logger.getLogger(DecisionTreeSDMModel.class.getName());
    private PMML jaxbRoot;
    private TreeModel _treeModelMetadata;
    private Node _rootNodeMetadata;
    private Map<String, IlvSDMNode> nodeStore = null;
    private Context context;
    private long maxId = 0L;
    private Boolean isLoaded = false;
    private Map<String, Color> colorMap = new HashMap<String, Color>();
    private int colorIndex = 0;
    private static Color[] colors;
    private static Color[] standardColors;
    private static Color otherColor;
    List<String> targetValues = new ArrayList<String>();
    private int maxTargetValues = 5;
    private Boolean barChartVisible = false;
    private Boolean headerDetailVisible = true;
    private Boolean sortByConfidence = true;

    public DecisionTreeSDMModel() {
        this.setEditable(true);
    }

    public IlvSDMNode getObject(String string) {
        return this.nodeStore.get(string);
    }

    public Map<String, IlvSDMNode> getNodeStore() {
        return this.nodeStore;
    }

    public void load(PMML pMML, Context context) throws Exception {
        boolean bl = this.isAdjusting();
        this.setAdjusting(true);
        this.assignColor("other");
        this.context = context;
        this.jaxbRoot = pMML;
        this._treeModelMetadata = this.getPMMLTreeModel(pMML);
        if (this._treeModelMetadata == null) {
            throw new RuntimeException("Tree not found in content model");
        }
        this._rootNodeMetadata = null;
        for (Object e : this._treeModelMetadata.getNodeOrMiningSchemaOrExtension()) {
            if (!(e instanceof Node)) continue;
            this._rootNodeMetadata = (Node)e;
            break;
        }
        if (this._rootNodeMetadata == null) {
            throw new RuntimeException("Tree root node not found in content model");
        }
        this.nodeStore = Collections.synchronizedMap(new LinkedHashMap());
        this.loadRootTargetValues(this._rootNodeMetadata);
        DTTreeNode dTTreeNode = DTTreeNode.createNode(this._rootNodeMetadata, this.context);
        this.addNodes(dTTreeNode, null);
        this.isLoaded = true;
        this.setEditable(true);
        this.setAdjusting(bl);
    }

    private void addNodes(DTTreeNode dTTreeNode, DTTreeNode dTTreeNode2) throws Exception {
        Object object;
        Object object2;
        Node node = dTTreeNode.getData();
        List<ScoreDistribution> list = dTTreeNode.getScoreDistributions();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            object = object2.getValue();
            this.assignColor((String)object);
        }
        this.addObject(dTTreeNode, dTTreeNode2, null);
        if (dTTreeNode2 != null) {
            object3 = DTTreeLink.createLink(dTTreeNode, dTTreeNode2);
            this.addObject(object3, null, null);
        }
        if (!(object3 = this.createChildrenTreeNodes(node.getSimplePredicateOrSimpleSetPredicateOrCompoundPredicate())).isEmpty()) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (DTTreeNode)object2.next();
                this.addNodes((DTTreeNode)object, dTTreeNode);
            }
        }
    }

    private void loadRootTargetValues(Node node) {
        this.targetValues.clear();
        List<ScoreDistribution> list = DTTreeNode.getScoreDistributions(node);
        for (ScoreDistribution scoreDistribution : list) {
            this.targetValues.add(scoreDistribution.getValue());
        }
    }

    public String getRootTargetValue(int n) {
        return this.targetValues.get(n);
    }

    public int getRootTargetValueCount() {
        return this.targetValues.size();
    }

    public Boolean isLoaded() {
        return this.isLoaded;
    }

    private void assignColor(String string) {
        if (this.colorMap.get(string) == null) {
            Color color = string.equals("other") ? otherColor : (this.colorIndex < colors.length ? colors[this.colorIndex++] : colors[colors.length - 1]);
            this.colorMap.put(string, color);
        }
    }

    public String getColorForTargetValue(String string) {
        Color color = this.colorMap.get(string);
        if (color != null) {
            Object object = Integer.toHexString(color.getRed());
            Object object2 = Integer.toHexString(color.getGreen());
            Object object3 = Integer.toHexString(color.getBlue());
            object = ((String)object).length() == 1 ? "0" + (String)object : object;
            object2 = ((String)object2).length() == 1 ? "0" + (String)object2 : object2;
            object3 = ((String)object3).length() == 1 ? "0" + (String)object3 : object3;
            String string2 = "#" + (String)object + (String)object2 + (String)object3;
            return string2;
        }
        return "#FFFFFF";
    }

    private static Color[] generateColors(int n) {
        int n2;
        Color[] colorArray = new Color[n];
        int n3 = 2;
        while (!(Math.pow(++n3, 3.0) >= (double)n)) {
        }
        int n4 = 255 / n3;
        int n5 = 0;
        Color[] colorArray2 = standardColors;
        int n6 = colorArray2.length;
        for (n2 = 0; n2 < n6; ++n2) {
            Color color = colorArray2[n2];
            colorArray[n5++] = color;
        }
        block2: for (int i = 255; i >= 0; i -= n4) {
            for (n6 = 0; n6 <= 255; n6 += n4) {
                for (n2 = 255; n2 >= 0; n2 -= n4) {
                    colorArray[n5++] = new Color(i, n6, n2);
                    if (n5 == n - 1) break block2;
                }
            }
        }
        return colorArray;
    }

    public void addObject(Object object, Object object2, Object object3) {
        super.addObject(object, object2, object3);
        if (object instanceof DTTreeNode) {
            this.nodeStore.put(((IlvSDMNode)object).getID(), (IlvSDMNode)object);
        } else if (object instanceof DTTreeLink) {
            this.nodeStore.put(((IlvSDMNode)object).getID(), (IlvSDMNode)object);
        } else {
            throw new RuntimeException("Unexpected obj type");
        }
        this.fireObjectAdded(object);
    }

    public Enumeration getObjects() {
        if (this.nodeStore == null) {
            return null;
        }
        return new Vector<IlvSDMNode>(this.nodeStore.values()).elements();
    }

    public void addObjectImpl(Object object, Object object2, Object object3) {
        if (object instanceof IlvMutableSDMNode) {
            IlvMutableSDMNode ilvMutableSDMNode = (IlvMutableSDMNode)object;
            ilvMutableSDMNode.setID(this.getNextNewIdString());
        }
    }

    private List<DTTreeNode> createChildrenTreeNodes(List<Object> list) throws Exception {
        ArrayList<DTTreeNode> arrayList = new ArrayList<DTTreeNode>();
        for (Object object : list) {
            if (!(object instanceof Node)) continue;
            Node node = (Node)object;
            arrayList.add(DTTreeNode.createNode(node, this.context));
        }
        return arrayList;
    }

    private TreeModel getPMMLTreeModel(PMML pMML) {
        List list = pMML.getTreeModelOrDataDictionaryOrHeader();
        TreeModel treeModel = null;
        for (Object e : list) {
            if (!(e instanceof TreeModel)) continue;
            treeModel = (TreeModel)e;
            break;
        }
        return treeModel;
    }

    public List<DTTreeLink> findLinksToNode(IlvSDMNode ilvSDMNode) {
        ArrayList<DTTreeLink> arrayList = new ArrayList<DTTreeLink>();
        for (IlvSDMNode ilvSDMNode2 : this.nodeStore.values()) {
            DTTreeLink dTTreeLink;
            if (!(ilvSDMNode2 instanceof DTTreeLink) || !(dTTreeLink = (DTTreeLink)ilvSDMNode2).getTo().getID().equals(ilvSDMNode.getID())) continue;
            arrayList.add(dTTreeLink);
        }
        return arrayList;
    }

    public List<DTTreeLink> findLinksFromNode(IlvSDMNode ilvSDMNode) {
        ArrayList<DTTreeLink> arrayList = new ArrayList<DTTreeLink>();
        for (IlvSDMNode ilvSDMNode2 : this.nodeStore.values()) {
            DTTreeLink dTTreeLink;
            if (!(ilvSDMNode2 instanceof DTTreeLink) || !(dTTreeLink = (DTTreeLink)ilvSDMNode2).getFrom().getID().equals(ilvSDMNode.getID())) continue;
            arrayList.add(dTTreeLink);
        }
        return arrayList;
    }

    public void clear() {
        this.nodeStore.clear();
    }

    public Context getContext() {
        return this.context;
    }

    public PMML getDocumentObject() {
        return this.jaxbRoot;
    }

    public void refresh() {
        try {
            this.load(this.jaxbRoot, this.context);
            this.fireDataChanged(null);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public long getNextNewId() {
        ++this.maxId;
        return this.maxId;
    }

    public String getNextNewIdString() {
        ++this.maxId;
        return Long.valueOf(this.maxId).toString();
    }

    public void setJaxbRoot(PMML pMML) {
        this.jaxbRoot = pMML;
    }

    public Node getRootNodeMetadata() {
        return this._rootNodeMetadata;
    }

    public void toggleBarChartVisible() {
        this.barChartVisible = this.barChartVisible == false;
    }

    public void setBarChartVisible(boolean bl) {
        this.barChartVisible = bl;
    }

    public Boolean isBarChartVisible() {
        return this.barChartVisible;
    }

    public void toggleHeaderDetailVisible() {
        this.headerDetailVisible = this.headerDetailVisible == false;
    }

    public void setHeaderDetailVisible(boolean bl) {
        this.headerDetailVisible = bl;
    }

    public Boolean isHeaderDetailVisible() {
        return this.headerDetailVisible;
    }

    public void setSortByConfidence(boolean bl) {
        this.sortByConfidence = bl;
    }

    public Boolean isSortByConfidence() {
        return this.sortByConfidence;
    }

    public int getMaxTargetValuesDisplayed() {
        return this.maxTargetValues;
    }

    public void setMaxTargetValuesDisplayed(int n) {
        this.maxTargetValues = n;
        for (Map.Entry<String, IlvSDMNode> entry : this.nodeStore.entrySet()) {
            IlvSDMNode ilvSDMNode = entry.getValue();
            if (!(ilvSDMNode instanceof DTTreeNode)) continue;
            ((DTTreeNode)ilvSDMNode).setMaxValuesDisplayed(this.maxTargetValues);
        }
        this.fireDataChanged(null);
    }

    static {
        otherColor = Color.pink;
        standardColors = new Color[]{new Color(0xFF0000), new Color(65280), new Color(255), new Color(14802006), new Color(5744232), new Color(5333622), new Color(11156339), new Color(14093683), new Color(11381904), new Color(8586175), new Color(14988982), new Color(13216308), new Color(13337386), new Color(9592506), new Color(3349430), new Color(6579103), new Color(5561257), new Color(13886040), new Color(1323336), new Color(12310444), new Color(2819063), new Color(12954258), new Color(0xABABAB), new Color(4622140), new Color(8818020), new Color(11083876), new Color(6302308), new Color(1342701), new Color(9798459), new Color(16457062), new Color(1877895), new Color(9518340), new Color(6157359), new Color(15905569), new Color(10174933), new Color(13014247), new Color(13672079), new Color(8967876), new Color(10534583), new Color(6561053), new Color(8102468), new Color(16040710), new Color(11465478), new Color(2892545), new Color(11372963), new Color(5192903), new Color(15658890), new Color(15658890), new Color(9347224), new Color(883781)};
        colors = DecisionTreeSDMModel.generateColors(1000);
    }

    public static class MalformedModelException
    extends Exception {
        @Override
        public String getMessage() {
            return DecisionTreeEditorLrb.get("MALFORMED_MODEL");
        }
    }
}

