/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.renderers.ComboBoxListRenderer;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientEditor;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientItemTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoefficientFilterPanel;
import oracle.dmt.dataminer.mviewer.coefficients.RenameFeaturePanel;
import oracle.dmt.dataminer.mviewer.svd.SingularValuesEditor;
import oracle.dmt.dataminer.navigator.RefreshController;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorManager;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class SVDCoefficientFilterPanel
extends GeneralCoefficientFilterPanel {
    private JCheckBox _jAbsoluteValueFilter;
    private JButton _jApplyFilterButton;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;
    private JComboBox<Object> _jTargetValueCombo;
    private JLabel _jTargetValueLabel;
    private Box.Filler filler1;
    private JButton jBtnTargetEdit;
    private JLabel jSingValueLbl;
    private JLabel jSingValueLbl1;
    private ModelViewerPartitionToolbar modelViewerPartitionToolbar1;

    public SVDCoefficientFilterPanel(CoefViewerMainPanel coefViewerMainPanel, CoefViewerState coefViewerState) {
        super(coefViewerMainPanel, coefViewerState);
        this.initComponents();
        this.initRes();
        this.initUI();
        this.initializeUIState();
    }

    private void initComponents() {
        this._jTargetValueLabel = new JLabel();
        this._jTargetValueCombo = new JComboBox();
        this.jBtnTargetEdit = new JButton();
        this._jAbsoluteValueFilter = new JCheckBox();
        this._jFetchSizeLabel = new JLabel();
        this._jFetchSize = new JSpinner();
        this._jApplyFilterButton = new JButton();
        this.jSingValueLbl = new JLabel();
        this.jSingValueLbl1 = new JLabel();
        this.modelViewerPartitionToolbar1 = new ModelViewerPartitionToolbar();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this._jTargetValueLabel.setText("Target Value:");
        this._jTargetValueCombo.setPreferredSize(new Dimension(160, 23));
        this.jBtnTargetEdit.setText("Edit");
        this.jBtnTargetEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SVDCoefficientFilterPanel.this.jBtnTargetEditActionPerformed(actionEvent);
            }
        });
        this._jAbsoluteValueFilter.setText("Sort by absolute value");
        this._jAbsoluteValueFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._jAbsoluteValueFilter.setMargin(new Insets(0, 0, 0, 0));
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jFetchSize.setMaximumSize(new Dimension(87, 20));
        this._jFetchSize.setMinimumSize(new Dimension(87, 20));
        this._jFetchSize.setPreferredSize(new Dimension(87, 20));
        this._jApplyFilterButton.setText("Query");
        this.jSingValueLbl.setText("Singular Value:");
        this.jSingValueLbl1.setText(" ");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modelViewerPartitionToolbar1, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jTargetValueLabel).addComponent(this.jSingValueLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this._jTargetValueCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnTargetEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jAbsoluteValueFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this._jFetchSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jFetchSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jApplyFilterButton)).addComponent(this.jSingValueLbl1, -1, -1, Short.MAX_VALUE)))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.filler1, -2, -1, -2).addGap(310, 310, 310)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jTargetValueLabel).addComponent(this._jTargetValueCombo, -2, -1, -2).addComponent(this.jBtnTargetEdit).addComponent(this._jAbsoluteValueFilter, -1, -1, Short.MAX_VALUE).addComponent(this._jFetchSizeLabel).addComponent(this._jFetchSize, -2, -1, -2).addComponent(this._jApplyFilterButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSingValueLbl).addComponent(this.jSingValueLbl1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modelViewerPartitionToolbar1, -2, -1, -2).addGap(10, 10, 10).addComponent(this.filler1, -2, -1, -2)));
    }

    private void jBtnTargetEditActionPerformed(ActionEvent actionEvent) {
        this.renameFeature();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameFeature() {
        String string = this._jTargetValueCombo.getSelectedItem().toString();
        RenameFeaturePanel renameFeaturePanel = new RenameFeaturePanel(this.state, string);
        if (renameFeaturePanel.showAsDialog(this)) {
            Cursor cursor = this.mainPanel.getCursor();
            try {
                this.mainPanel.setCursor(Cursor.getPredefinedCursor(3));
                String string2 = renameFeaturePanel.getCurrentName();
                this.state.renameFeature(string2, string);
                this.state.reloadFeatureValues(this.modelViewerPartitionToolbar1.getPartitionVO());
                this._jTargetValueCombo.setModel(new DefaultComboBoxModel<Object>(this.state.getTargetPredictions().toArray()));
                this._jTargetValueCombo.getModel().setSelectedItem(string2);
                this.refreshActiveSingularValuesEditor(this.state.getContext());
                CoefficientEditor coefficientEditor = (CoefficientEditor)this.mainPanel.getEditor();
                RefreshController.getInstance().forceRefreshInSiblingEditors(coefficientEditor.getParentNodeId(), coefficientEditor);
                this.mainPanel.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
            }
            catch (Exception exception) {
                try {
                    if (exception.getMessage().equals(CoefficientsLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"))) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)CoefficientsLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"), (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_TITLE"), null);
                    } else {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_TITLE"), (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_MESG"), null);
                    }
                    this.mainPanel.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                }
                catch (Throwable throwable) {
                    this.mainPanel.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
            }
        }
    }

    private void refreshActiveSingularValuesEditor(Context context) {
        List list = EditorManager.getEditorManager().findEditors(context);
        for (Object e : list) {
            if (!(e instanceof SingularValuesEditor)) continue;
            SingularValuesEditor singularValuesEditor = (SingularValuesEditor)e;
            singularValuesEditor.refresh(this.state.getUserName(), this.state.getModelName());
        }
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jSingValueLbl, (Component)this.jSingValueLbl1, (String)CoefficientsLrb.get("SINGULAR_VALUE"));
        this.jSingValueLbl.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("SINGULAR_VALUE"));
        this.jSingValueLbl.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("SINGULAR_VALUE_ADA"));
        ResourceUtils.resLabel((JLabel)this._jTargetValueLabel, this._jTargetValueCombo, (String)CoefficientsLrb.get("FEATURE_VALUE"));
        this._jTargetValueLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FEATURE_VALUE"));
        this._jTargetValueLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FEATURE_VALUE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jBtnTargetEdit, (String)CoefficientsLrb.get("FEATURE_EDIT"));
        this.jBtnTargetEdit.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FEATURE_EDIT"));
        this.jBtnTargetEdit.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FEATURE_EDIT_ADA"));
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSize.setToolTipText(CoefficientsLrb.get("FETCH_SIZE_ADA") + "\n" + CoefficientsLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1000));
        ResourceUtils.resButton((AbstractButton)this._jAbsoluteValueFilter, (String)CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
        this._jAbsoluteValueFilter.setToolTipText(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
    }

    @Override
    public void initUI() {
        this.setLocale(this._jFetchSize, Locale.getDefault());
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SVDCoefficientFilterPanel.this.updateFilter();
                SVDCoefficientFilterPanel.this.coefFilterSetting.getViewerState().setFetchSizeValue(SVDCoefficientFilterPanel.this.getNumber(SVDCoefficientFilterPanel.this._jFetchSize).intValue());
                SVDCoefficientFilterPanel.this.coefFilterSetting.getViewerState().setSortByAbsoluteValue(SVDCoefficientFilterPanel.this._jAbsoluteValueFilter.isSelected());
            }
        });
        this._jAbsoluteValueFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SVDCoefficientFilterPanel.this.isLoading()) {
                    return;
                }
                SVDCoefficientFilterPanel.this.state.setSortByAbsoluteValue(SVDCoefficientFilterPanel.this._jAbsoluteValueFilter.isSelected());
                SVDCoefficientFilterPanel.this.coefFilterSetting.setFilterByAbsolute(SVDCoefficientFilterPanel.this._jAbsoluteValueFilter.isSelected());
            }
        });
        CoefficientItemTableModel coefficientItemTableModel = new CoefficientItemTableModel();
        this.state.setFilterItemTableModel(coefficientItemTableModel);
        this.filterTable.setModel((TableModel)((Object)coefficientItemTableModel));
        this._jTargetValueCombo.setRenderer(new ComboBoxListRenderer());
        this._jTargetValueCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SVDCoefficientFilterPanel.this.isLoading()) {
                    return;
                }
                SVDCoefficientFilterPanel.this.state.setSelectedTargetClass(SVDCoefficientFilterPanel.this._jTargetValueCombo.getSelectedItem());
                SVDCoefficientFilterPanel.this.prepareReload();
            }
        });
        this._jTargetValueCombo.setModel(new DefaultComboBoxModel());
    }

    private void updateFilter() {
        try {
            GeneralCoefficientFilterPanel.ValidateUpdateState validateUpdateState = new GeneralCoefficientFilterPanel.ValidateUpdateState();
            validateUpdateState.setTitle(CoefficientsLrb.get("FILTER_PROCESS_TITLE"));
            validateUpdateState.setMessage(CoefficientsLrb.get("FILTER_PROCESS_MESG"));
            validateUpdateState.setCancelable(false);
            validateUpdateState.start(true);
            if (validateUpdateState.getException() != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)validateUpdateState.getException(), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            }
            if (validateUpdateState.getValidation()) {
                this.mainPanel.setFilterState(this.coefFilterSetting);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
        }
    }

    private void initializeUIState() {
        this.coefFilterSetting = new CoefficientFilterSetting(false);
        this.loadStateAttributes();
    }

    @Override
    protected JSpinner getFetchSizeComponent() {
        return this._jFetchSize;
    }

    @Override
    protected JCheckBox getAbsoluteValueComponent() {
        return this._jAbsoluteValueFilter;
    }

    @Override
    public ModelViewerPartitionToolbar getPartitionToolbar() {
        return this.modelViewerPartitionToolbar1;
    }

    public String getSelectedParitionId() {
        return this.modelViewerPartitionToolbar1.getSelectedPartitionID();
    }

    public PartitionVO getPartitionVO() {
        return this.modelViewerPartitionToolbar1.getPartitionVO();
    }

    @Override
    public void setupUI(CoefficientFilterSetting coefficientFilterSetting) {
        this.coefFilterSetting = coefficientFilterSetting;
        this.loadStateAttributes();
        this.setLoaded(true);
    }

    @Override
    protected void loadStateAttributes() {
        if (this.coefFilterSetting.getViewerState() != null) {
            this.setNumber(this._jFetchSize, this.coefFilterSetting.getViewerState().getFetchSizeValue());
            this._jAbsoluteValueFilter.setSelected(this.coefFilterSetting.getFilterAndSortByAbsolute());
        }
    }

    @Override
    public void updateTarget() {
        this._jTargetValueCombo.setModel(new DefaultComboBoxModel<Object>(this.state.getTargetPredictions().toArray()));
        this._jTargetValueCombo.setSelectedItem(this.state.getSelectedTargetClass());
        Double d = this.state.getFeatureIdSingularValue(this.state.getSelectedTargetClass());
        String string = this.numberFormat.format(d);
        this.jSingValueLbl1.setText(string);
    }

    public void reload() {
        ReLoadUI reLoadUI = new ReLoadUI();
        reLoadUI.execute();
    }

    private class ReLoadUI
    extends ODMrSwingWorker<Void, Void> {
        private PartitionVO pvo;

        private ReLoadUI() {
            super(SVDCoefficientFilterPanel.this, SVDCoefficientFilterPanel.this.overLayPanel);
            this.pvo = SVDCoefficientFilterPanel.this.modelViewerPartitionToolbar1.getPartitionVO();
        }

        @Override
        protected Void doInBackground() throws Exception {
            SVDCoefficientFilterPanel.this.modelViewerPartitionToolbar1.load(SVDCoefficientFilterPanel.this.mainPanel.getEditor());
            SVDCoefficientFilterPanel.this.state.reloadFeatureValues(this.pvo);
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            SVDCoefficientFilterPanel.this._jTargetValueCombo.setModel(new DefaultComboBoxModel<Object>(SVDCoefficientFilterPanel.this.state.getTargetPredictions().toArray()));
        }

        @Override
        protected void onFailure(Throwable throwable) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable, (String)CoefficientsLrb.get("ERROR_RELOADING_FEATURES_TITLE"), (String)CoefficientsLrb.get("ERROR_RELOADING_FEATURES_MSG"), null);
        }
    }
}

