/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientItemTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoefficientFilterPanel;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;

public class RegrCoefficientFilterPanel
extends GeneralCoefficientFilterPanel {
    private JCheckBox _jAbsoluteValueFilter;
    private JButton _jApplyFilterButton;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;
    private ModelViewerPartitionToolbar modelViewerPartitionToolbar1;

    public RegrCoefficientFilterPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public RegrCoefficientFilterPanel(CoefViewerMainPanel coefViewerMainPanel, CoefViewerState coefViewerState) {
        super(coefViewerMainPanel, coefViewerState);
        this.initComponents();
        this.initRes();
        this.initUI();
        this.initializeUIState();
    }

    private void initComponents() {
        this._jAbsoluteValueFilter = new JCheckBox();
        this._jFetchSizeLabel = new JLabel();
        this._jFetchSize = new JSpinner();
        this._jApplyFilterButton = new JButton();
        this.modelViewerPartitionToolbar1 = new ModelViewerPartitionToolbar();
        this._jAbsoluteValueFilter.setText("Sort by absolute value");
        this._jAbsoluteValueFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jFetchSize.setPreferredSize(new Dimension(110, 24));
        this._jApplyFilterButton.setText("Query");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this._jAbsoluteValueFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this._jFetchSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._jFetchSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jApplyFilterButton, -2, 110, -2)).addComponent(this.modelViewerPartitionToolbar1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jApplyFilterButton, -1, -1, Short.MAX_VALUE).addComponent(this._jFetchSizeLabel).addComponent(this._jFetchSize, -2, -1, -2)).addComponent(this._jAbsoluteValueFilter, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modelViewerPartitionToolbar1, -2, -1, -2).addGap(10, 10, 10)));
    }

    @Override
    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSize.setToolTipText(CoefficientsLrb.get("FETCH_SIZE_ADA") + "\n" + CoefficientsLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1));
        ResourceUtils.resButton((AbstractButton)this._jAbsoluteValueFilter, (String)CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
        this._jAbsoluteValueFilter.setToolTipText(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
    }

    @Override
    public void initUI() {
        this.setLocale(this._jFetchSize, Locale.getDefault());
        this._jAbsoluteValueFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RegrCoefficientFilterPanel.this._jAbsoluteValueFilter_actionPerformed(actionEvent);
            }
        });
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RegrCoefficientFilterPanel.this._jApplyFilterButton_actionPerformed(actionEvent);
            }
        });
        CoefficientItemTableModel coefficientItemTableModel = new CoefficientItemTableModel();
        this.state.setFilterItemTableModel(coefficientItemTableModel);
        this.filterTable.setModel((TableModel)((Object)coefficientItemTableModel));
    }

    @Override
    public ModelViewerPartitionToolbar getPartitionToolbar() {
        return this.modelViewerPartitionToolbar1;
    }

    @Override
    protected void loadStateAttributes() {
        if (this.coefFilterSetting.getViewerState() != null) {
            this.setNumber(this._jFetchSize, this.preferenceSettings.getFetchSizeOtherModels());
            this._jAbsoluteValueFilter.setSelected(this.coefFilterSetting.getFilterAndSortByAbsolute());
        }
    }

    @Override
    public void setupUI(CoefficientFilterSetting coefficientFilterSetting) {
        this.coefFilterSetting = coefficientFilterSetting;
        this.loadStateAttributes();
        this.setLoaded(true);
    }

    @Override
    protected JSpinner getFetchSizeComponent() {
        return this._jFetchSize;
    }

    @Override
    protected JCheckBox getAbsoluteValueComponent() {
        return this._jAbsoluteValueFilter;
    }

    public String getSelectedPartitionName() {
        return this.modelViewerPartitionToolbar1.getSelectedPartitionName();
    }

    public String getSelectedParitionId() {
        return this.modelViewerPartitionToolbar1.getSelectedPartitionID();
    }

    public PartitionVO getPartitionVO() {
        return this.modelViewerPartitionToolbar1.getPartitionVO();
    }

    private void initializeUIState() {
        this.coefFilterSetting = new CoefficientFilterSetting();
        this.loadStateAttributes();
    }

    public void updateInput() throws Exception {
        Number number = this.getNumber(this._jFetchSize);
        this.coefFilterSetting.setFetchSize(number.intValue());
        this.coefFilterSetting.setFilterByAbsolute(this._jAbsoluteValueFilter.isSelected());
    }

    private void _jAbsoluteValueFilter_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this.state.setSortByAbsoluteValue(this._jAbsoluteValueFilter.isSelected());
        this.coefFilterSetting.setFilterByAbsolute(this._jAbsoluteValueFilter.isSelected());
    }

    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        try {
            GeneralCoefficientFilterPanel.ValidateUpdateState validateUpdateState = new GeneralCoefficientFilterPanel.ValidateUpdateState();
            validateUpdateState.setTitle(CoefficientsLrb.get("FILTER_PROCESS_TITLE"));
            validateUpdateState.setMessage(CoefficientsLrb.get("FILTER_PROCESS_MESG"));
            validateUpdateState.setCancelable(false);
            validateUpdateState.start(true);
            if (validateUpdateState.getException() != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)validateUpdateState.getException(), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            }
            if (validateUpdateState.getValidation()) {
                this.mainPanel.setFilterState(this.coefFilterSetting);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
        }
    }
}

