/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NMFModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVDModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.utils.Formats;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;

public abstract class GeneralCoefficientFilterPanel
extends JPanel
implements DataminerGUIPanel {
    public static final String FILTER_SETTING_PROPERTY = "FILTER_SETTING_PROPERTY";
    protected boolean loaded;
    protected CoefViewerState state;
    protected CoefViewerMainPanel mainPanel;
    protected CoefficientFilterSetting coefFilterSetting;
    protected NumberFormat numberFormat;
    protected DataMinerTable filterTable;
    protected BlockingComponent overLayPanel;
    protected ModelViewerPreferenceSettings preferenceSettings;

    public GeneralCoefficientFilterPanel() {
        this(null, null);
    }

    public GeneralCoefficientFilterPanel(CoefViewerMainPanel coefViewerMainPanel, CoefViewerState coefViewerState) {
        this.mainPanel = coefViewerMainPanel;
        this.state = coefViewerState;
        this.numberFormat = Formats.ModelViewer.getNumeric();
        this.filterTable = new DataMinerTable();
        this.preferenceSettings = ModelViewerPreferenceSettings.getInstance();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public JPanel getUIComponent() {
        return this;
    }

    protected boolean isSVM() {
        ModelNode modelNode = (ModelNode)this.state.getContext().getNode();
        return modelNode instanceof SVMCModelNode;
    }

    protected boolean isGLM() {
        ModelNode modelNode = (ModelNode)this.state.getContext().getNode();
        return modelNode instanceof GLMCModelNode;
    }

    protected boolean isAnomaly() {
        ModelNode modelNode = (ModelNode)this.state.getContext().getNode();
        return modelNode instanceof ANModelNode;
    }

    protected boolean isNB() {
        ModelNode modelNode = (ModelNode)this.state.getContext().getNode();
        return modelNode instanceof NBModelNode;
    }

    protected boolean isNMF() {
        ModelNode modelNode = (ModelNode)this.state.getContext().getNode();
        return modelNode instanceof NMFModelNode;
    }

    protected boolean isSVD() {
        ModelNode modelNode = (ModelNode)this.state.getContext().getNode();
        return modelNode instanceof SVDModelNode;
    }

    public void setupUI(CoefficientFilterSetting coefficientFilterSetting) {
        this.coefFilterSetting = coefficientFilterSetting;
        if (this.isAnomaly()) {
            this.coefFilterSetting.setFilterByAbsolute(true);
        }
        this.loadStateAttributes();
        this.setLoaded(true);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    protected void setNumber(JSpinner jSpinner, Number number) {
        jSpinner.setValue(number);
    }

    protected void setLocale(JSpinner jSpinner, Locale locale) {
        jSpinner.setLocale(locale);
    }

    protected Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    public boolean isLoading() {
        return this.mainPanel.isLoading();
    }

    protected void prepareReload() {
        this.mainPanel.prepareReload();
    }

    protected void setupUIDetail() {
        this.loadStateAttributes();
        this.setLoaded(true);
    }

    public void updateTarget() {
    }

    protected abstract ModelViewerPartitionToolbar getPartitionToolbar();

    protected abstract void loadStateAttributes();

    protected abstract JSpinner getFetchSizeComponent();

    protected abstract JCheckBox getAbsoluteValueComponent();

    public class ValidateUpdateState
    extends ProgressRunnable {
        private Exception exception;
        private Boolean validated;

        public boolean getValidation() {
            return this.validated;
        }

        public Exception getException() {
            return this.exception;
        }

        protected Object doWork() throws Exception {
            this.validated = false;
            try {
                Number number = GeneralCoefficientFilterPanel.this.getNumber(GeneralCoefficientFilterPanel.this.getFetchSizeComponent());
                if (null == number || number.longValue() <= 0L) {
                    this.validated = false;
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)CoefficientsLrb.get("FETCH_SIZE_RANGE_ERROR"), (String)CoefficientsLrb.get("COEFFICIENT_ERROR_TITLE"), null);
                    return this.validated;
                }
                this.validated = true;
                GeneralCoefficientFilterPanel.this.coefFilterSetting.setFetchSize(number.intValue());
                GeneralCoefficientFilterPanel.this.coefFilterSetting.setUseFilterSpecification(false);
                if (null != GeneralCoefficientFilterPanel.this.getAbsoluteValueComponent()) {
                    GeneralCoefficientFilterPanel.this.coefFilterSetting.setFilterByAbsolute(GeneralCoefficientFilterPanel.this.getAbsoluteValueComponent().isSelected());
                }
            }
            catch (Exception exception) {
                this.exception = exception;
                this.validated = false;
            }
            return this.validated;
        }
    }
}

