/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.util.Comparator;
import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.fe.common.FeatureCoefficient;
import oracle.dmt.dataminer.core.utils.comparator.AbsoluteNumberComparator;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;

public class ESACoefViewerTableModel
extends ODMrTableModel<FeatureCoefficient> {
    private static final int ATTRIBUTE = 0;
    private static final int VALUE = 1;
    public static final int COEFFICIENT = 2;
    private boolean _absoluteSort = false;
    private static final String[] COLUMN_NAMES = new String[]{CoefficientsLrb.get("ATTRIBUTE_COLUMN"), CoefficientsLrb.get("VALUE_COLUMN"), CoefficientsLrb.get("COEFFICIENT_COLUMN")};

    public ESACoefViewerTableModel() {
        super(COLUMN_NAMES);
    }

    public ESACoefViewerTableModel(List<FeatureCoefficient> list) {
        super(COLUMN_NAMES, list);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        FeatureCoefficient featureCoefficient = (FeatureCoefficient)this.srcData.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = featureCoefficient.getAttributeFullName();
                break;
            }
            case 1: {
                object = featureCoefficient.getAttributeValue();
                break;
            }
            case 2: {
                object = featureCoefficient.getCoefficient();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        return object == null ? "" : object;
    }

    public Comparator getColumnSortComparator(int n) {
        if (n == 2) {
            if (this._absoluteSort) {
                return AbsoluteNumberComparator.getComparator();
            }
            return NumberComparator.getComparator();
        }
        return super.getColumnSortComparator(n);
    }

    public void setAbsoluteValueSort(boolean bl) {
        this._absoluteSort = bl;
    }

    public boolean getAbsoluteSort() {
        return this._absoluteSort;
    }
}

