/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLTimeoutException;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.renderers.ComboBoxListRenderer;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientItemTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoefficientFilterPanel;
import oracle.dmt.dataminer.mviewer.coefficients.RenameFeaturePanel;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class CoefficientFilterPanel
extends GeneralCoefficientFilterPanel {
    private JCheckBox _jAbsoluteValueFilter;
    private JButton _jApplyFilterButton;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;
    private JComboBox<Object> _jTargetValueCombo;
    private JLabel _jTargetValueLabel;
    private JButton jBtnTargetEdit;
    private ModelViewerPartitionToolbar modelViewerPartitionToolbar1;

    private CoefficientFilterPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public CoefficientFilterPanel(CoefViewerMainPanel coefViewerMainPanel, CoefViewerState coefViewerState) {
        super(coefViewerMainPanel, coefViewerState);
        this.initComponents();
        this.initRes();
        this.initUI();
        this.initializeUIState();
    }

    private void initComponents() {
        this.modelViewerPartitionToolbar1 = new ModelViewerPartitionToolbar();
        this._jTargetValueLabel = new JLabel();
        this._jTargetValueCombo = new JComboBox();
        this.jBtnTargetEdit = new JButton();
        this._jAbsoluteValueFilter = new JCheckBox();
        this._jApplyFilterButton = new JButton();
        this._jFetchSize = new JSpinner();
        this._jFetchSizeLabel = new JLabel();
        this._jTargetValueLabel.setText("Target Value:");
        this._jTargetValueCombo.setPreferredSize(new Dimension(160, 23));
        this.jBtnTargetEdit.setText("Edit");
        this.jBtnTargetEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoefficientFilterPanel.this.jBtnTargetEditActionPerformed(actionEvent);
            }
        });
        this._jAbsoluteValueFilter.setText("Sort by absolute value");
        this._jAbsoluteValueFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._jApplyFilterButton.setText("Query");
        this._jFetchSize.setMaximumSize(new Dimension(87, 20));
        this._jFetchSize.setMinimumSize(new Dimension(87, 20));
        this._jFetchSize.setPreferredSize(new Dimension(110, 20));
        this._jFetchSizeLabel.setText("Fetch Size Label:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modelViewerPartitionToolbar1, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this._jTargetValueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this._jTargetValueCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnTargetEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jAbsoluteValueFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 47, Short.MAX_VALUE).addComponent(this._jFetchSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jFetchSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jApplyFilterButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jTargetValueLabel).addComponent(this._jTargetValueCombo, -2, -1, -2).addComponent(this.jBtnTargetEdit).addComponent(this._jAbsoluteValueFilter).addComponent(this._jApplyFilterButton).addComponent(this._jFetchSize, -2, -1, -2).addComponent(this._jFetchSizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modelViewerPartitionToolbar1, -2, -1, -2).addGap(10, 10, 10)));
    }

    private void jBtnTargetEditActionPerformed(ActionEvent actionEvent) {
        this.renameFeature(this._jTargetValueCombo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void renameFeature(JComboBox<Object> jComboBox) {
        String string = jComboBox.getSelectedItem().toString();
        RenameFeaturePanel renameFeaturePanel = new RenameFeaturePanel(this.state, string);
        if (renameFeaturePanel.showAsDialog(this)) {
            Cursor cursor = this.mainPanel.getCursor();
            try {
                this.mainPanel.setCursor(Cursor.getPredefinedCursor(3));
                String string2 = renameFeaturePanel.getCurrentName();
                this.state.renameFeature(string2, string);
                this.state.reloadFeatureValues(this.modelViewerPartitionToolbar1.getPartitionVO());
                jComboBox.setModel(new DefaultComboBoxModel<Object>(this.state.getTargetPredictions().toArray()));
                jComboBox.getModel().setSelectedItem(string2);
                this.mainPanel.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
            }
            catch (SQLTimeoutException sQLTimeoutException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CoefficientsLrb.get("FEATURE_RENAME_TIMEOUT_MESG"), (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_TITLE"), null);
                this.mainPanel.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
            }
            catch (Exception exception) {
                if (exception.getMessage().equals(CoefficientsLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"))) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)CoefficientsLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"), (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_TITLE"), null);
                } else {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_TITLE"), (String)CoefficientsLrb.get("FEATURE_RENAME_FAILURE_MESG"), null);
                }
                this.mainPanel.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                {
                    catch (Throwable throwable) {
                        this.mainPanel.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                        throw throwable;
                    }
                }
            }
        }
    }

    @Override
    public void initRes() {
        if (this.isNMF() || this.isSVD()) {
            ResourceUtils.resLabel((JLabel)this._jTargetValueLabel, this._jTargetValueCombo, (String)CoefficientsLrb.get("FEATURE_VALUE"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FEATURE_VALUE"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FEATURE_VALUE_ADA"));
            ResourceUtils.resButton((AbstractButton)this.jBtnTargetEdit, (String)CoefficientsLrb.get("FEATURE_EDIT"));
            this.jBtnTargetEdit.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FEATURE_EDIT"));
            this.jBtnTargetEdit.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FEATURE_EDIT_ADA"));
        } else if (!this.isAnomaly()) {
            ResourceUtils.resLabel((JLabel)this._jTargetValueLabel, this._jTargetValueCombo, (String)CoefficientsLrb.get("TARGET_VALUE"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("TARGET_VALUE"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("TARGET_VALUE_ADA"));
        } else {
            ResourceUtils.resLabel((JLabel)this._jTargetValueLabel, this._jTargetValueCombo, (String)CoefficientsLrb.get("PREDICTIVE_CLASS"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("PREDICTIVE_CLASS"));
            this._jTargetValueLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("PREDICTIVE_CLASS_ADA"));
        }
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSize.setToolTipText(CoefficientsLrb.get("FETCH_SIZE_ADA") + "\n" + CoefficientsLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1000));
        ResourceUtils.resButton((AbstractButton)this._jAbsoluteValueFilter, (String)CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("ABSOLUTE_VALUE"));
        this._jAbsoluteValueFilter.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
        this._jAbsoluteValueFilter.setToolTipText(CoefficientsLrb.get("ABSOLUTE_VALUE_ADA"));
    }

    @Override
    public void initUI() {
        this.setLocale(this._jFetchSize, Locale.getDefault());
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoefficientFilterPanel.this._jApplyFilterButton_actionPerformed(actionEvent);
                CoefficientFilterPanel.this.coefFilterSetting.getViewerState().setFetchSizeValue(CoefficientFilterPanel.this.getNumber(CoefficientFilterPanel.this._jFetchSize).intValue());
                CoefficientFilterPanel.this.coefFilterSetting.getViewerState().setSortByAbsoluteValue(CoefficientFilterPanel.this._jAbsoluteValueFilter.isSelected());
            }
        });
        this._jAbsoluteValueFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoefficientFilterPanel.this._jAbsoluteValueFilter_actionPerformed(actionEvent);
            }
        });
        CoefficientItemTableModel coefficientItemTableModel = new CoefficientItemTableModel();
        this.state.setFilterItemTableModel(coefficientItemTableModel);
        this.filterTable.setModel((TableModel)((Object)coefficientItemTableModel));
        this._jTargetValueCombo.setRenderer(new ComboBoxListRenderer());
        this._jTargetValueCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoefficientFilterPanel.this._jTargetValueCombo_actionPerformed(actionEvent);
            }
        });
        if (this.isAnomaly()) {
            this._jTargetValueCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{CoefViewerState.TYPICAL, CoefViewerState.OUTLIER}));
            this._jTargetValueCombo.setSelectedItem(CoefViewerState.TYPICAL);
            this.state.setPredictiveValue(CoefViewerState.TYPICAL);
        } else {
            this._jTargetValueCombo.setModel(new DefaultComboBoxModel());
        }
        if (this.isNB() || this.isNMF()) {
            this._jAbsoluteValueFilter.setVisible(false);
        }
        this.jBtnTargetEdit.setVisible(this.isNMF());
    }

    private void initializeUIState() {
        this.coefFilterSetting = new CoefficientFilterSetting();
        this.loadStateAttributes();
    }

    @Override
    protected void loadStateAttributes() {
        if (this.coefFilterSetting.getViewerState() != null) {
            this.setNumber(this._jFetchSize, this.coefFilterSetting.getViewerState().getFetchSizeValue());
            this._jAbsoluteValueFilter.setSelected(this.coefFilterSetting.getViewerState().getSortByAbsoluteValue());
        }
    }

    @Override
    public void updateTarget() {
        if (this.isAnomaly()) {
            this._jTargetValueCombo.setSelectedItem(this.state.getPredictiveValue());
            return;
        }
        this._jTargetValueCombo.setModel(new DefaultComboBoxModel<Object>(this.state.getTargetPredictions().toArray()));
        this._jTargetValueCombo.setSelectedItem(this.state.getSelectedTargetClass());
    }

    @Override
    public ModelViewerPartitionToolbar getPartitionToolbar() {
        return this.modelViewerPartitionToolbar1;
    }

    @Override
    protected JSpinner getFetchSizeComponent() {
        return this._jFetchSize;
    }

    @Override
    protected JCheckBox getAbsoluteValueComponent() {
        return this._jAbsoluteValueFilter;
    }

    public String getSelectedParitionId() {
        return this.modelViewerPartitionToolbar1.getSelectedPartitionID();
    }

    public PartitionVO getPartitionVO() {
        return this.modelViewerPartitionToolbar1.getPartitionVO();
    }

    private void _jTargetValueCombo_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        if (this.isAnomaly()) {
            this.state.setPredictiveValue(this._jTargetValueCombo.getSelectedItem().toString());
        } else {
            this.state.setSelectedTargetClass(this._jTargetValueCombo.getSelectedItem());
        }
        this.prepareReload();
    }

    private void _jAbsoluteValueFilter_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this.state.setSortByAbsoluteValue(this._jAbsoluteValueFilter.isSelected());
        this.coefFilterSetting.setFilterByAbsolute(this._jAbsoluteValueFilter.isSelected());
    }

    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        try {
            GeneralCoefficientFilterPanel.ValidateUpdateState validateUpdateState = new GeneralCoefficientFilterPanel.ValidateUpdateState(this);
            validateUpdateState.setTitle(CoefficientsLrb.get("FILTER_PROCESS_TITLE"));
            validateUpdateState.setMessage(CoefficientsLrb.get("FILTER_PROCESS_MESG"));
            validateUpdateState.setCancelable(false);
            validateUpdateState.start(true);
            if (validateUpdateState.getException() != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)validateUpdateState.getException(), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            }
            if (validateUpdateState.getValidation()) {
                this.mainPanel.setFilterState(this.coefFilterSetting);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)CoefficientsLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
        }
    }

    public static CoefficientFilterPanel createCoefficientFilterPanel() {
        CoefficientFilterPanel coefficientFilterPanel = new CoefficientFilterPanel();
        return coefficientFilterPanel;
    }
}

