/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.rules;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSplitPane;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.mviewer.ModelMessagePanel;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.arrules.rules.ARRulesFilterPanel;
import oracle.dmt.dataminer.mviewer.arrules.rules.ARRulesViewer;
import oracle.dmt.dataminer.mviewer.arrules.rules.ARRulesViewerState;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;

public class ARRulesMainPanel
extends DataMinerViewGUI {
    private ARRulesViewerState state;
    private ARRulesViewer rulesViewerPanel;
    private ARRulesFilterPanel rulesFilterPanel;
    private JSplitPane splitPanel;

    public ARRulesMainPanel(Editor editor, Context context) {
        super(editor, context);
        Node node = context.getNode();
        ModelNode modelNode = (ModelNode)node;
        if (!modelNode.exists()) {
            this.add(new ModelMessagePanel(ModelViewerLrb.get("MODEL_DOES_NOT_EXIST")));
            return;
        }
        this.state = new ARRulesViewerState(context);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.rulesFilterPanel = new ARRulesFilterPanel(this.getEditor(), this.state);
        this.rulesViewerPanel = new ARRulesViewer(this.state);
        this.splitPanel = new JSplitPane(0, this.rulesFilterPanel, this.rulesViewerPanel);
        this.add((Component)this.splitPanel, "Center");
        this.splitPanel.setEnabled(this.rulesFilterPanel.isFilterExpanded());
    }

    private void initUI() {
        this.rulesFilterPanel.addActionListener(new QueryButtonActionListener());
        this.rulesFilterPanel.addFilterPropertyChangeListener(new FilterSplitPropertyChangeListener());
    }

    @Override
    public HelpInfo getHelpInfo() {
        return new HelpInfo("ar_view_rules");
    }

    @Override
    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void query() {
        QueryWorker queryWorker = new QueryWorker();
        queryWorker.execute();
    }

    private void checkFilterExpanded(boolean bl) {
        this.splitPanel.setEnabled(bl);
        this.splitPanel.resetToPreferredSizes();
    }

    private class QueryWorker
    extends ODMrSwingWorker<Void, Void> {
        private QueryWorker() {
            super(ARRulesMainPanel.this, ARRulesMainPanel.this.overLayPanel, ARRulesMainPanel.this.rulesViewerPanel.getRulesTable());
        }

        @Override
        protected void beforeExecute() {
            ARRulesMainPanel.this.rulesFilterPanel.beforeLoad();
            ARRulesMainPanel.this.rulesViewerPanel.beforeLoad();
        }

        @Override
        protected Void doInBackground() throws Exception {
            ARRulesMainPanel.this.state.query(ARRulesMainPanel.this.rulesFilterPanel.getSelectedPartitionID());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            ARRulesMainPanel.this.rulesViewerPanel.afterQuery();
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        private LoadUI() {
            super(ARRulesMainPanel.this, ARRulesMainPanel.this.overLayPanel, ARRulesMainPanel.this.rulesViewerPanel.getRulesTable());
        }

        @Override
        protected void beforeExecute() {
            ARRulesMainPanel.this.rulesFilterPanel.beforeLoad();
            ARRulesMainPanel.this.rulesViewerPanel.beforeLoad();
        }

        @Override
        protected Void doInBackground() throws Exception {
            ARRulesMainPanel.this.rulesFilterPanel.loadPartitionToobar();
            ARRulesMainPanel.this.state.load(ARRulesMainPanel.this.rulesFilterPanel.getSelectedPartitionID());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            ARRulesMainPanel.this.rulesViewerPanel.afterLoad();
            ARRulesMainPanel.this.rulesFilterPanel.afterLoad();
        }
    }

    private class FilterSplitPropertyChangeListener
    implements PropertyChangeListener {
        private FilterSplitPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ARRulesMainPanel.this.checkFilterExpanded((Boolean)propertyChangeEvent.getNewValue());
        }
    }

    private class QueryButtonActionListener
    implements ActionListener {
        private QueryButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ARRulesMainPanel.this.query();
        }
    }
}

