/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.itemsets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.res.ARLrb;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.itemsets.ARItemSetsViewerState;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.model.ItemSetsFilterSetting;
import oracle.ide.editor.Editor;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class ARItemSetsFilterPanel
extends JPanel {
    private static final String SORT_BY_SUPPORT = ARLrb.get((String)"SUPPORT");
    private static final String SORT_BY_SIZE = ARLrb.get((String)"ITEMS_IN_RULE");
    static final String[] ITEMSETS_SORT_COMBO_VALUES = new String[]{SORT_BY_SUPPORT, SORT_BY_SIZE};
    private Editor editor;
    private ARItemSetsViewerState state;
    private boolean filterExpanded;
    private JButton jApplyFilterButton;
    private JCheckBox jChkBoxUseFilter;
    private JPanel jContainerPanel;
    private JButton jExpandButton;
    private JLabel jFetchSizeLabel;
    private JSpinner jFetchSizeValue;
    private JPanel jFilterControlsPanel;
    private JLabel jFilterMessageLbl;
    private JPanel jFilterMessagePanel;
    private JLabel jMaximumItems;
    private JSpinner jMaximumItemsValue;
    private JLabel jMinimumSupport;
    private JSpinner jMinimumSupportValue;
    private JRadioButton jSortAscBtn;
    private ButtonGroup jSortBtnGrp;
    private JLabel jSortByLabel;
    private JComboBox<String> jSortCombo;
    private JRadioButton jSortDesBtn;
    private ModelViewerPartitionToolbar partitionToolbar;

    public ARItemSetsFilterPanel(Editor editor, ARItemSetsViewerState aRItemSetsViewerState) {
        this.editor = editor;
        this.state = aRItemSetsViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSortBtnGrp = new ButtonGroup();
        this.jApplyFilterButton = new JButton();
        this.jExpandButton = new JButton();
        this.partitionToolbar = new ModelViewerPartitionToolbar();
        this.jContainerPanel = new JPanel();
        this.jFilterMessagePanel = new JPanel();
        this.jFilterMessageLbl = new JLabel();
        this.jFilterControlsPanel = new JPanel();
        this.jMinimumSupport = new JLabel();
        this.jMinimumSupportValue = new JSpinner();
        this.jMaximumItems = new JLabel();
        this.jMaximumItemsValue = new JSpinner();
        this.jChkBoxUseFilter = new JCheckBox();
        this.jFetchSizeValue = new JSpinner();
        this.jFetchSizeLabel = new JLabel();
        this.jSortByLabel = new JLabel();
        this.jSortCombo = new JComboBox();
        this.jSortAscBtn = new JRadioButton();
        this.jSortDesBtn = new JRadioButton();
        this.jApplyFilterButton.setText("Query");
        this.jApplyFilterButton.setMaximumSize(new Dimension(87, 23));
        this.jApplyFilterButton.setMinimumSize(new Dimension(87, 23));
        this.jApplyFilterButton.setPreferredSize(new Dimension(87, 23));
        this.jExpandButton.setText("More");
        this.jExpandButton.setMaximumSize(new Dimension(87, 23));
        this.jExpandButton.setMinimumSize(new Dimension(87, 23));
        this.jExpandButton.setPreferredSize(new Dimension(87, 23));
        this.jContainerPanel.setLayout(new BoxLayout(this.jContainerPanel, 1));
        this.jFilterMessagePanel.setBorder(BorderFactory.createTitledBorder("Filter"));
        this.jFilterMessageLbl.setText("No Filter");
        GroupLayout groupLayout = new GroupLayout(this.jFilterMessagePanel);
        this.jFilterMessagePanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jFilterMessageLbl).addContainerGap(888, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jFilterMessageLbl).addGap(5, 5, 5)));
        this.jContainerPanel.add(this.jFilterMessagePanel);
        this.jFilterControlsPanel.setBorder(BorderFactory.createTitledBorder("Filter"));
        this.jMinimumSupport.setText("Minimum Support (%):");
        this.jMaximumItems.setText("Maximum Items Per Set:");
        this.jChkBoxUseFilter.setText("Use filter");
        this.jChkBoxUseFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GroupLayout groupLayout2 = new GroupLayout(this.jFilterControlsPanel);
        this.jFilterControlsPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jChkBoxUseFilter, -1, 866, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMaximumItems).addComponent(this.jMinimumSupport)).addGap(18, 18, 18).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jMinimumSupportValue, -1, 100, Short.MAX_VALUE).addComponent(this.jMaximumItemsValue)).addGap(0, 0, Short.MAX_VALUE))).addGap(69, 69, 69)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jChkBoxUseFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMinimumSupport).addComponent(this.jMinimumSupportValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaximumItems).addComponent(this.jMaximumItemsValue, -2, -1, -2)).addGap(5, 5, 5)));
        this.jContainerPanel.add(this.jFilterControlsPanel);
        this.jFetchSizeLabel.setText("Fetch Size:");
        this.jSortByLabel.setText("Sort by:");
        this.jSortBtnGrp.add(this.jSortAscBtn);
        this.jSortAscBtn.setText("Ascending");
        this.jSortBtnGrp.add(this.jSortDesBtn);
        this.jSortDesBtn.setText("Descending");
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jContainerPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.partitionToolbar, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jSortByLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSortCombo, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSortAscBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSortDesBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jFetchSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFetchSizeValue, -2, 90, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jApplyFilterButton, -2, 119, -2).addComponent(this.jExpandButton, -2, 119, -2)))).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jApplyFilterButton, -2, -1, -2).addComponent(this.jFetchSizeValue, -2, -1, -2).addComponent(this.jFetchSizeLabel, -2, 14, -2).addComponent(this.jSortByLabel).addComponent(this.jSortCombo, -2, -1, -2).addComponent(this.jSortAscBtn).addComponent(this.jSortDesBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jExpandButton, -2, -1, -2).addComponent(this.partitionToolbar, -2, -1, -2)).addGap(0, 0, 0).addComponent(this.jContainerPanel, -2, -1, -2).addGap(5, 5, 5)));
    }

    private void initRes() {
        ResourceUtils.resButton((AbstractButton)this.jApplyFilterButton, (String)ControlsLrb.get("FILTER_QUERY"));
        this.jApplyFilterButton.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_QUERY"));
        this.jApplyFilterButton.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_QUERY_ADA"));
        this.jApplyFilterButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        ResourceUtils.resLabel((JLabel)this.jFetchSizeLabel, (Component)this.jFetchSizeValue, (String)ControlsLrb.get("FILTER_FETCH_SIZE"));
        this.jFetchSizeLabel.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_FETCH_SIZE"));
        this.jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_FETCH_SIZE_ADA"));
        this.jFetchSizeValue.setToolTipText(ControlsLrb.get("FILTER_FETCH_SIZE_ADA") + "\n" + ControlsLrb.get("FILTER_FETCH_SIZE_RANGE"));
        ResourceUtils.resLabel((JLabel)this.jMaximumItems, (Component)this.jMaximumItemsValue, (String)ARRulesLrb.get("FILTER_ITEMSETS_MAXIMUM_ITEMS"));
        this.jMaximumItems.getAccessibleContext().setAccessibleName(ARRulesLrb.get("FILTER_ITEMSETS_MAXIMUM_ITEMS"));
        this.jMaximumItems.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("FILTER_ITEMSETS_MAXIMUM_ITEMS_ADA"));
        this.jMaximumItemsValue.setToolTipText(ARRulesLrb.get("FILTER_ITEMSETS_MAXIMUM_ITEMS_ADA"));
        ResourceUtils.resLabel((JLabel)this.jMinimumSupport, (Component)this.jMinimumSupportValue, (String)ARRulesLrb.get("MINIMUM_SUPPORT"));
        this.jMinimumSupport.getAccessibleContext().setAccessibleName(ARRulesLrb.get("MINIMUM_SUPPORT"));
        this.jMinimumSupport.getAccessibleContext().setAccessibleDescription(ARRulesLrb.get("MINIMUM_SUPPORT_ADA"));
        this.jMinimumSupportValue.setToolTipText(ARRulesLrb.get("MINIMUM_SUPPORT_ADA"));
        ResourceUtils.resLabel((JLabel)this.jSortByLabel, this.jSortCombo, (String)ControlsLrb.get("FILTER_SORT_BY"));
        this.jSortByLabel.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_SORT_BY"));
        this.jSortByLabel.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_SORT_BY_ADA"));
        this.jSortCombo.setModel(new DefaultComboBoxModel<String>(ITEMSETS_SORT_COMBO_VALUES));
        this.jSortCombo.setSelectedItem(SORT_BY_SUPPORT);
        this.jSortCombo.setToolTipText(ControlsLrb.get("FILTER_SORT_BY_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jSortAscBtn, (String)SortDirection.ASCENDING.getLabel());
        ResourceUtils.resButton((AbstractButton)this.jSortDesBtn, (String)SortDirection.DESCENDING.getLabel());
        ResourceUtils.resButton((AbstractButton)this.jExpandButton, (String)ControlsLrb.get("FILTER_MORE"));
        this.jExpandButton.setIcon(DataMinerIcons.get(Icons.EXPAND));
        this.jExpandButton.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_MORE"));
        this.jExpandButton.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_MORE_ADA"));
        this.jExpandButton.setHorizontalTextPosition(10);
        this.jFetchSizeValue.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 100));
        this.jMaximumItemsValue.setModel(new SpinnerNumberModel(4, 1, Integer.MAX_VALUE, 1));
        this.jMinimumSupportValue.setModel(new SpinnerNumberModel(1.0, 1.0E-5, 100.0, 1.0));
        this.jMinimumSupportValue.setEditor(new JSpinner.NumberEditor(this.jMinimumSupportValue, "#,##0.######;(#)"));
        ResourceUtils.resButton((AbstractButton)this.jChkBoxUseFilter, (String)ControlsLrb.get("FILTER_USE_FILTER"));
        this.jChkBoxUseFilter.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_USE_FILTER"));
        this.jChkBoxUseFilter.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_USE_FILTER_ADA"));
        TitledBorder titledBorder = (TitledBorder)this.jFilterControlsPanel.getBorder();
        titledBorder.setTitle(CoreCommonLrb.get((String)"FILTER"));
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    private void setNumber(JSpinner jSpinner, Number number) {
        jSpinner.setValue(number);
    }

    private void initUI() {
        this.initUiListeners();
        this.initFilterPanel();
    }

    private void initUiListeners() {
        this.jExpandButton.addActionListener(new ExpandFilterActionListener());
        this.jChkBoxUseFilter.addActionListener(new UseFilterActionListener());
    }

    private void initFilterPanel() {
        this.jFilterControlsPanel.setVisible(false);
        this.partitionToolbar.setVisible(false);
        this.enableFilterControls(false);
        this.initFilterValues();
    }

    private void initFilterValues() {
        ItemSetsFilterSetting itemSetsFilterSetting = this.state.getFilterSetting();
        this.setNumber(this.jFetchSizeValue, itemSetsFilterSetting.getFetchSize());
        this.setNumber(this.jMaximumItemsValue, itemSetsFilterSetting.getMaxItemSetLength());
        this.setNumber(this.jMinimumSupportValue, itemSetsFilterSetting.getMinSupport() * 100.0);
        this.jSortCombo.setSelectedItem(this.getSortColumn());
        if (SortDirection.ASCENDING == this.getSortDirection()) {
            this.jSortAscBtn.setSelected(true);
        } else {
            this.jSortDesBtn.setSelected(true);
        }
    }

    private String getSortColumn() {
        String string = null;
        SortSpec sortSpec = this.state.getFilterSetting().getSortSpecification().get(0);
        switch (sortSpec.getAttributeName()) {
            case "SUPPORT": {
                string = SORT_BY_SUPPORT;
                break;
            }
            case "NUMBER_OF_ITEMS": {
                string = SORT_BY_SIZE;
                break;
            }
            default: {
                string = sortSpec.getAttributeName();
                assert (false) : "Invalid sort statement";
                break;
            }
        }
        return string;
    }

    private SortDirection getSortDirection() {
        SortSpec sortSpec = this.state.getFilterSetting().getSortSpecification().get(0);
        return sortSpec.getSortDirection();
    }

    String getSelectedPartition() {
        return this.partitionToolbar.getSelectedPartitionID();
    }

    private void enableFilterControls(boolean bl) {
        this.jMaximumItems.setEnabled(bl);
        this.jMaximumItemsValue.setEnabled(bl);
        this.jMinimumSupport.setEnabled(bl);
        this.jMinimumSupportValue.setEnabled(bl);
    }

    void updateFilterSetting() {
        Number number = this.getNumber(this.jFetchSizeValue);
        this.state.getFilterSetting().setFetchSize(number.intValue());
        this.state.getFilterSetting().setMaxItemSetLength(this.getNumber(this.jMaximumItemsValue).intValue());
        this.state.getFilterSetting().setMinSupport(this.getNumber(this.jMinimumSupportValue).doubleValue() / 100.0);
        SortSpec sortSpec = this.state.getFilterSetting().getSortSpecification().get(0);
        sortSpec.setUseIt(true);
        String string = (String)this.jSortCombo.getSelectedItem();
        if (SORT_BY_SUPPORT.equals(string)) {
            sortSpec.setAttributeName("SUPPORT");
        } else if (SORT_BY_SIZE.equals(string)) {
            sortSpec.setAttributeName("NUMBER_OF_ITEMS");
        } else if (this.state.getAggregates().contains(string)) {
            sortSpec.setAttributeName(string);
        } else {
            throw new IllegalArgumentException("Unrecognized sort value selection: " + string);
        }
        SortDirection sortDirection = this.jSortAscBtn.isSelected() ? SortDirection.ASCENDING : SortDirection.DESCENDING;
        sortSpec.setSortDirection(sortDirection);
        this.state.getFilterSetting().updatePreferences();
    }

    JButton getQueryButton() {
        return this.jApplyFilterButton;
    }

    void loadPartitionToobar() {
        this.partitionToolbar.load(this.editor);
    }

    void afterLoad() {
        this.initSortComboModel();
    }

    private void initSortComboModel() {
        this.jSortCombo.setModel(new DefaultComboBoxModel<String>(ITEMSETS_SORT_COMBO_VALUES));
        for (String string : this.state.getAggregates()) {
            this.jSortCombo.addItem(string);
        }
    }

    private class ExpandFilterActionListener
    implements ActionListener {
        private ExpandFilterActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ARItemSetsFilterPanel.this.jFilterMessagePanel.setVisible(ARItemSetsFilterPanel.this.filterExpanded);
            ARItemSetsFilterPanel.this.filterExpanded = !ARItemSetsFilterPanel.this.filterExpanded;
            ARItemSetsFilterPanel.this.jFilterControlsPanel.setVisible(ARItemSetsFilterPanel.this.filterExpanded);
            ARItemSetsFilterPanel.this.jChkBoxUseFilter.setVisible(ARItemSetsFilterPanel.this.filterExpanded);
            if (ARItemSetsFilterPanel.this.filterExpanded) {
                ResourceUtils.resButton((AbstractButton)ARItemSetsFilterPanel.this.jExpandButton, (String)ControlsLrb.get("FILTER_MORE"));
                ARItemSetsFilterPanel.this.jExpandButton.setIcon(DataMinerIcons.get(Icons.EXPAND));
                ARItemSetsFilterPanel.this.jExpandButton.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_MORE"));
                ARItemSetsFilterPanel.this.jExpandButton.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_MORE_ADA"));
            } else {
                ResourceUtils.resButton((AbstractButton)ARItemSetsFilterPanel.this.jExpandButton, (String)ControlsLrb.get("FILTER_HIDE"));
                ARItemSetsFilterPanel.this.jExpandButton.setIcon(DataMinerIcons.get(Icons.COLLAPSE));
                ARItemSetsFilterPanel.this.jExpandButton.getAccessibleContext().setAccessibleName(ControlsLrb.get("FILTER_HIDE"));
                ARItemSetsFilterPanel.this.jExpandButton.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("FILTER_HIDE_ADA"));
            }
        }
    }

    private class UseFilterActionListener
    implements ActionListener {
        private UseFilterActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ARItemSetsFilterPanel.this.jChkBoxUseFilter.isSelected();
            ARItemSetsFilterPanel.this.enableFilterControls(bl);
            ARItemSetsFilterPanel.this.state.getFilterSetting().setUseFilterSpecification(bl);
            this.updateLabels(bl);
        }

        private void updateLabels(boolean bl) {
            String string = bl ? CoreCommonLrb.get((String)"MSG_FILTER_ACTIVE") : CoreCommonLrb.get((String)"MSG_FILTER_NO_FILTER");
            ResourceUtils.resLabel((JLabel)ARItemSetsFilterPanel.this.jFilterMessageLbl, null, (String)string);
            Icon icon = bl ? OracleIcons.getIcon((String)"filter.png") : null;
            ARItemSetsFilterPanel.this.jFilterMessageLbl.setIcon(icon);
        }
    }
}

