/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.formatters;

import java.text.NumberFormat;
import java.util.HashMap;
import oracle.dmt.dataminer.core.model.ar.Item;
import oracle.dmt.dataminer.core.model.ar.Rule;
import oracle.dmt.dataminer.core.model.ar.RuleAggregateData;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.res.ARLrb;
import oracle.dmt.dataminer.mviewer.arrules.ARPreferences;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.formatters.ARRuleAbstractFormatter;
import oracle.dmt.dataminer.utils.FileHelper;
import oracle.dmt.dataminer.utils.Formats;

public class ARRuleAggregateFormatter
extends ARRuleAbstractFormatter {
    private static final int RULE_INFORMATION = 3;
    private static final int ITEMSET_INFORMATION = 2;
    private static final int BASIC_COLUMNS = 3;
    private static final int RULE_ROW = 0;
    private static final int ANTECEDENT_ROW = 1;
    private static final int CONSEQUENT_ROW = 2;
    private static final int ANTECEDENT_START_ROW = 3;
    private static final int COL_LOCATION = 0;
    private static final int COL_LEVEL = 1;
    private static final int COL_ITEM = 2;
    private int itemsetConsIdx;
    private int itemsetAntIdx;
    private boolean showAverage;
    private String ruleHTMLTemplate = FileHelper.loadFile("/oracle/dmt/dataminer/mviewer/res/ARRuleAggregateTemplate.html");
    private ARPreferences preferences = ARPreferences.getInstance();
    private NumberFormat numericFormat;
    private NumberFormat percentFormat;

    @Override
    public String formatBody(Rule rule) {
        this.initVariables(rule);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("AGGREGATE_METRICS", ARRulesLrb.get("METRIC_DETAILS_AGGREGATES"));
        hashMap.put("TABLE_HEAD", this.getTableHeader(rule));
        hashMap.put("TABLE_BODY", this.getTableBody(rule));
        String string = StringUtils.getReplacedString((String)this.ruleHTMLTemplate, hashMap);
        return string;
    }

    private void initVariables(Rule rule) {
        this.numericFormat = Formats.ModelViewer.getNumeric();
        this.percentFormat = Formats.ModelViewer.getPercentage();
        this.itemsetConsIdx = 3 + rule.getAntecedent().size();
        this.itemsetAntIdx = this.itemsetConsIdx + 1;
        this.showAverage = this.preferences.getShowAverageMetricDetailsColumn();
    }

    private String getTableHeader(Rule rule) {
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append("<td>");
        stringBuilder.append(CoreCommonLrb.get((String)"LOCATION"));
        stringBuilder.append("</td><td>");
        stringBuilder.append(CoreCommonLrb.get((String)"LEVEL"));
        stringBuilder.append("</td><td>");
        stringBuilder.append(CoreCommonLrb.get((String)"ITEM"));
        stringBuilder.append("</td>");
        for (String string : rule.getAggregateNames()) {
            stringBuilder.append("<td>");
            stringBuilder.append(string);
            stringBuilder.append("</td>");
        }
        if (this.showAverage) {
            for (String string : rule.getAggregateNames()) {
                stringBuilder.append("<td>");
                stringBuilder.append(string);
                stringBuilder.append("_avg</td>");
            }
        }
        return stringBuilder.toString();
    }

    private String getTableBody(Rule rule) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 3 + rule.getAntecedent().size();
        int n2 = 2;
        int n3 = n + n2;
        int n4 = this.showAverage ? 2 : 1;
        int n5 = 3 + rule.getAggregateNames().size() * n4;
        for (int i = 0; i < n3; ++i) {
            if (i % 2 == 0) {
                stringBuilder.append("<tr class='trOdd'>");
            } else {
                stringBuilder.append("<tr class='trEven'>");
            }
            for (int j = 0; j < n5; ++j) {
                stringBuilder.append("<td>");
                stringBuilder.append(this.getValueFor(i, j, rule));
                stringBuilder.append("</td>");
            }
            stringBuilder.append("</tr>");
        }
        return stringBuilder.toString();
    }

    private String getValueFor(int n, int n2, Rule rule) {
        String string = "";
        switch (n2) {
            case 0: {
                string = this.getLocationValue(n);
                break;
            }
            case 1: {
                string = this.getLevelValue(n);
                break;
            }
            case 2: {
                string = this.getItemValue(rule, n);
                break;
            }
            default: {
                string = this.getAggregateValue(rule, n, n2);
            }
        }
        return string;
    }

    private String getLocationValue(int n) {
        String string = "";
        if (n == 0) {
            string = ARLrb.get((String)"RULE");
        }
        if (n == this.itemsetConsIdx) {
            string = ARLrb.get((String)"ITEMSET");
        }
        return string;
    }

    private String getLevelValue(int n) {
        String string = "";
        if (n == 0) {
            string = ARLrb.get((String)"RULE");
        } else if (n == 2) {
            string = ARLrb.get((String)"CONSEQUENT");
        }
        string = n == this.itemsetConsIdx ? ARLrb.get((String)"CONSEQUENT") : ARLrb.get((String)"ANTECEDENT");
        return string;
    }

    private String getItemValue(Rule rule, int n) {
        String string = "";
        if (n == 2) {
            string = rule.getConsequent().getAttributeName();
        } else if (n >= 3 && n < this.itemsetConsIdx) {
            int n2 = n - 3;
            string = ((Item)rule.getAntecedent().get(n2)).getAttributeName();
        } else if (n == this.itemsetConsIdx) {
            string = rule.getConsequent().getAttributeName();
        }
        return string;
    }

    private String getAggregateValue(Rule rule, int n, int n2) {
        Double d;
        String string = "";
        boolean bl = n2 >= 3 + rule.getAggregateNames().size();
        int n3 = bl ? n2 - (3 + rule.getAggregateNames().size()) : n2 - 3;
        String string2 = (String)rule.getAggregateNames().get(n3);
        RuleAggregateData ruleAggregateData = rule.getAggregateData(string2);
        if (n == 0) {
            d = bl ? ruleAggregateData.getRuleAvg() : ruleAggregateData.getRule();
            string = this.numericFormat.format(d);
        }
        if (n == 1) {
            d = bl ? ruleAggregateData.getAntecedentRuleAvg() : ruleAggregateData.getAntecedentRule();
            string = this.numericFormat.format(d);
        } else if (n == 2) {
            d = bl ? ruleAggregateData.getConsequentRuleAvg() : ruleAggregateData.getConsequentRule();
            string = this.numericFormat.format(d);
        } else if (n >= 3 && n < this.itemsetConsIdx) {
            int n4 = n - 3;
            Item item = (Item)rule.getAntecedent().get(n4);
            Double d2 = bl ? item.getAggregateAvg(string2) : item.getAggregate(string2);
            string = this.numericFormat.format(d2);
        } else if (n == this.itemsetConsIdx) {
            string = bl ? "" : this.numericFormat.format(ruleAggregateData.getConsequentItemset());
        } else if (n == this.itemsetAntIdx) {
            string = bl ? "" : this.numericFormat.format(ruleAggregateData.getAntecedentItemset());
        }
        return string;
    }
}

