/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.formatters;

import java.util.List;

public abstract class ARObjectAbstractFormatter<O> {
    private static final String STYLE = "<style type=\"text/css\">\n\n.MetricTable {\n\t margin:0px;\n\t padding:0px;\n\t width:33%;\n  border:1px solid #555555;\n  color:#000000; \n}\n\n.MetricTable table{\n  border-collapse: collapse;\n  border-spacing: 0;\n\t width:100%;\n\t margin:0px;\n\t padding:0px;\n}\n\n.trOdd  { background-color:#ffffff; }\n.trEven { background-color:#e5e5e5; }\n\n.MetricTable td{\n\t vertical-align:middle;\n\t border:1px solid #cccccc;\n\t border-width:0px 1px 1px 0px;\n\t text-align:left;\n  padding: 3px;\n}\n\n.MetricTable .header {\n  background-color:#BFBFBF;\n  font-weight: bold;\n}\n\n </style> ";
    private static final String HTML_HEADER = "<html>\n <style type=\"text/css\">\n\n.MetricTable {\n\t margin:0px;\n\t padding:0px;\n\t width:33%;\n  border:1px solid #555555;\n  color:#000000; \n}\n\n.MetricTable table{\n  border-collapse: collapse;\n  border-spacing: 0;\n\t width:100%;\n\t margin:0px;\n\t padding:0px;\n}\n\n.trOdd  { background-color:#ffffff; }\n.trEven { background-color:#e5e5e5; }\n\n.MetricTable td{\n\t vertical-align:middle;\n\t border:1px solid #cccccc;\n\t border-width:0px 1px 1px 0px;\n\t text-align:left;\n  padding: 3px;\n}\n\n.MetricTable .header {\n  background-color:#BFBFBF;\n  font-weight: bold;\n}\n\n </style>  \n<body>";
    private static final String HTML_FOOTER = "</body>\n \n</html>";

    public String formatOne(List<O> list) {
        boolean bl = list.size() == 0;
        boolean bl2 = list.size() == 1;
        String string = null;
        string = bl ? this.getHtmlForMessage(this.getNoItemSelectedMessage()) : (bl2 ? this.format(list.get(0)) : this.getHtmlForMessage(this.getSingleSelectionMessage()));
        String string2 = this.encloseInHtml(string);
        return string2;
    }

    public String formatAll(List<O> list) {
        assert (list.size() > 0) : "No object selected";
        StringBuilder stringBuilder = new StringBuilder();
        for (O o : list) {
            stringBuilder.append(this.format(o));
            stringBuilder.append("<br />");
        }
        String string = this.encloseInHtml(stringBuilder.toString());
        return string;
    }

    private String encloseInHtml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(HTML_HEADER);
        stringBuilder.append(string);
        stringBuilder.append(HTML_FOOTER);
        return stringBuilder.toString();
    }

    private String getHtmlForMessage(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div><h1 style='text-align: center; color:gray;'>");
        stringBuilder.append(string);
        stringBuilder.append("</h1></div>");
        return stringBuilder.toString();
    }

    protected abstract String getNoItemSelectedMessage();

    protected abstract String getSingleSelectionMessage();

    protected String format(O o) {
        assert (o != null) : "Argument can not be null";
        Object object = this.formatHeader(o);
        object = (String)object + this.formatBody(o);
        return object;
    }

    protected abstract String formatBody(O var1);

    protected abstract String formatHeader(O var1);
}

