/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.text.html.HTMLEditorKit;
import oracle.dmt.dataminer.mviewer.arrules.ARMetricDetailsType;
import oracle.dmt.dataminer.mviewer.arrules.formatters.ARObjectAbstractFormatter;

public abstract class ARObjectDetailViewer<O>
extends JPanel {
    protected List<O> itemsToDisplay;
    protected ARObjectAbstractFormatter<O> formatter;
    protected JPanel jContainerPanel;
    protected JTextPane jDetailsTextPane;
    protected JComboBox<ARMetricDetailsType> jMetricDetailsCmb;
    protected JLabel jMetricDetailsLbl;
    private JScrollPane jScrollPane1;

    public ARObjectDetailViewer() {
        this.initComponents();
        this.initRes();
        this.initUI();
        this.formatter = this.getSelectedFormatter();
    }

    private void initComponents() {
        this.jContainerPanel = new JPanel();
        this.jMetricDetailsLbl = new JLabel();
        this.jMetricDetailsCmb = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jDetailsTextPane = new JTextPane();
        this.jContainerPanel.setBorder(BorderFactory.createTitledBorder("Object Details"));
        this.jMetricDetailsLbl.setText("Metric Details:");
        this.jScrollPane1.setViewportView(this.jDetailsTextPane);
        GroupLayout groupLayout = new GroupLayout(this.jContainerPanel);
        this.jContainerPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(groupLayout.createSequentialGroup().addComponent(this.jMetricDetailsLbl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jMetricDetailsCmb, -2, 190, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMetricDetailsLbl).addComponent(this.jMetricDetailsCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 19, Short.MAX_VALUE).addContainerGap()));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jContainerPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jContainerPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void initRes() {
        DefaultComboBoxModel<ARMetricDetailsType> defaultComboBoxModel = new DefaultComboBoxModel<ARMetricDetailsType>(ARMetricDetailsType.values());
        this.jMetricDetailsCmb.setModel(defaultComboBoxModel);
        this.jContainerPanel.setBorder(BorderFactory.createTitledBorder(this.getContainerPanelTitle()));
    }

    private void initUI() {
        this.jMetricDetailsCmb.addActionListener(new MetricDetailsActionListener());
        this.jDetailsTextPane.setEditorKit(new HTMLEditorKit());
        this.jDetailsTextPane.setEditable(false);
    }

    public void displayDetailsFor(List<O> list) {
        this.itemsToDisplay = list == null ? Collections.emptyList() : list;
        String string = this.formatter.formatOne(this.itemsToDisplay);
        this.jDetailsTextPane.setText(string);
        this.jDetailsTextPane.setCaretPosition(this.jDetailsTextPane.getDocument().getLength());
        this.jDetailsTextPane.moveCaretPosition(0);
    }

    public void enableAggregateDetails(boolean bl) {
        this.jMetricDetailsLbl.setEnabled(bl);
        this.jMetricDetailsCmb.setEnabled(bl);
    }

    protected abstract String getContainerPanelTitle();

    protected abstract ARObjectAbstractFormatter<O> getSelectedFormatter();

    private class MetricDetailsActionListener
    implements ActionListener {
        private MetricDetailsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ARObjectDetailViewer.this.formatter = ARObjectDetailViewer.this.getSelectedFormatter();
            ARObjectDetailViewer.this.displayDetailsFor(ARObjectDetailViewer.this.itemsToDisplay);
        }
    }
}

