/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer;

import java.util.List;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.common.build.MiningModelSettings;
import oracle.dmt.dataminer.core.model.common.build.ModelGeneralDescription;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.server.model.Model;
import oracle.ide.Context;
import oracle.ide.model.Node;

public class ModelViewerState {
    private boolean loaded;
    private Model odmModel;
    private Context context;

    public ModelViewerState(Context context) {
        assert (context != null) : "Context cannot be passed into constructore as a null.";
        this.context = context;
    }

    public void load() {
        Node node = this.context.getNode();
        if (node instanceof ModelNode) {
            this.odmModel = ((ModelNode)node).getOdmModel();
            this.loaded = true;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public Model getOdmModel() {
        return this.odmModel;
    }

    public String getModelName() {
        return this.odmModel != null ? this.odmModel.getModelName() : null;
    }

    public String getUserName() {
        return this.odmModel != null ? this.odmModel.getUserName() : null;
    }

    public ModelGeneralDescription getModelDesc() {
        return this.odmModel != null ? this.odmModel.getModelGeneralDescription() : null;
    }

    public List<MiningModelSettings> getModelSettings() throws ODMrDAOException {
        return this.odmModel != null ? this.odmModel.getModelSettings() : null;
    }
}

