/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.expressionbuilder2;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.expressionbuilder2.DialogsLrb;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.TableNameValidator;
import oracle.dmt.dataminer.utils.UITools;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.SQLQuery.SQLQueryPIPropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class CreateViewPanel
extends DialogDisplayer<AbstractNode> {
    private static int MAX_LENGTH = 32;
    private static int MAX_LENGTH_EX = 130;
    private String _viewName;
    private JScrollPane jScrollPaneTitle;
    private JLabel jViewNameLabel;
    private JTextField jViewNameTextField;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();

    public CreateViewPanel(Context context, String string) {
        super(context, null);
        assert (string != null) : "View Name can't be null";
        this._viewName = string;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jViewNameLabel, (Component)this.jViewNameTextField, (String)DialogsLrb.get("SQLQUERY_CREATE_VIEW_NAME"));
    }

    @Override
    public void initUI() {
        this._jDescription.setText(DialogsLrb.get("SQLQUERY_CREATE_VIEW_DESC"));
        this.jScrollPaneTitle.getViewport().add((Component)this._jDescription);
        boolean bl = SQLHelper.isExpandedObjNameEnabled(this._context);
        this.jViewNameTextField.setDocument(new TextFieldLimit(bl ? MAX_LENGTH_EX : MAX_LENGTH));
        ViewNameInputVerifier viewNameInputVerifier = new ViewNameInputVerifier(this.jViewNameTextField, this._context);
        this.jViewNameTextField.setInputVerifier(viewNameInputVerifier);
        if (!StringUtils.isValidNonQuotedDBObjectName(this._viewName)) {
            this._viewName = StringUtils.addDoubleQuotes(this._viewName);
        }
        this.jViewNameTextField.setText(this._viewName);
        CustomViewNameValidator customViewNameValidator = new CustomViewNameValidator(viewNameInputVerifier);
        this.jViewNameTextField.addFocusListener(customViewNameValidator);
        this.jViewNameTextField.addKeyListener(customViewNameValidator);
    }

    private void initComponents() {
        this.jViewNameLabel = new JLabel();
        this.jViewNameTextField = new JTextField();
        this.jScrollPaneTitle = new JScrollPane();
        this.jViewNameLabel.setText("View Name");
        this.jViewNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateViewPanel.this.jViewNameTextFieldActionPerformed(actionEvent);
            }
        });
        this.jScrollPaneTitle.setBorder(null);
        this.jScrollPaneTitle.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneTitle.setVerticalScrollBarPolicy(21);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneTitle, -1, 376, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jViewNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jViewNameTextField, -2, 162, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jViewNameTextField, -2, -1, -2).addComponent(this.jViewNameLabel)).addContainerGap(53, Short.MAX_VALUE)));
    }

    private void jViewNameTextFieldActionPerformed(ActionEvent actionEvent) {
    }

    public String getViewName() {
        return this._viewName;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("SQLQUERY_CREATE_VIEW_DIALOG");
    }

    @Override
    protected String getHelpTopic() {
        return null;
    }

    @Override
    protected int getDialogButtonMask() {
        return 3;
    }

    private boolean isDuplicateName(String string) {
        boolean bl = false;
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            bl = workflowEditor.doesNodeNameAlreadyExist(string);
        }
        return bl;
    }

    class ViewNameInputVerifier
    extends InputVerifier {
        JTextField _textField;
        String _currentValue;
        Context _context;

        public ViewNameInputVerifier(JTextField jTextField, Context context) {
            this._textField = jTextField;
            this._context = context;
        }

        @Override
        public boolean verify(JComponent jComponent) {
            boolean bl = true;
            this._currentValue = CreateViewPanel.this._viewName;
            if (jComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jComponent;
                String string = jTextField.getText().trim();
                if (string.length() == 0) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_NAME_MISSING"), (String)SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_SPEC_ERROR_TITLE"), null);
                    bl = false;
                }
                if (StringUtils.isDoubleQuotedString(string)) {
                    this._currentValue = StringUtils.addDoubleQuotes(this._currentValue);
                }
                if (bl && !StringUtils.isDoubleQuotedString(string)) {
                    string = string.toUpperCase();
                }
                try {
                    if (this._currentValue != null && this._currentValue.compareTo(string) != 0) {
                        if (bl && CreateViewPanel.this.isDuplicateName(StringUtils.trimDoubleQuotes(string))) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)SQLQueryPIPropertyLrb.get("PI_SQLQUERY_NOT_UNIQUE_MSG"), (String)SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_SPEC_ERROR_TITLE"), null);
                            bl = false;
                        }
                        if (bl && !TableNameValidator.validateTableName(string, null, this._context, true)) {
                            bl = false;
                        }
                        if (bl && !TableNameValidator.isTableNameUnique(this._context, string)) {
                            String string2 = MessageFormat.format(DataDialogsLrb.get("TABLE_VALIDATION_ERROR_IN_USE"), string);
                            if (!MessageDialog.confirm((Component)UITools.getParentWindow(CreateViewPanel.this), (Object)string2, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), null)) {
                                bl = false;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_SYSTEM_ERROR"), null);
                    bl = false;
                }
                if (!bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ViewNameInputVerifier.this._textField.setText(ViewNameInputVerifier.this._currentValue);
                        }
                    });
                } else {
                    CreateViewPanel.this._viewName = StringUtils.trimDoubleQuotes(string);
                }
            }
            return bl;
        }
    }

    class CustomViewNameValidator
    extends KeyAdapter
    implements FocusListener {
        boolean busy = false;
        ViewNameInputVerifier _verifier;

        public CustomViewNameValidator(ViewNameInputVerifier viewNameInputVerifier) {
            this._verifier = viewNameInputVerifier;
        }

        private void validateName() {
            if (this.busy) {
                return;
            }
            try {
                this.busy = true;
                this._verifier.verify(CreateViewPanel.this.jViewNameTextField);
            }
            finally {
                this.busy = false;
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                this.validateName();
            }
        }
    }
}

