/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.dprofiler;

import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.workflow.inspect.transformations.StatisticSelectionDefinitions;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;

public class DataProfileStatisticsModel
extends ODMrTableModel<DataProfileStatisticsData> {
    private static final String TABLE_SUMMARY_EDITOR_STATUS = DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_LOADING_TITLE");
    public static final String TABLE_SUMMARY_EDITOR_COLUMN_NAME = DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_NAME");
    public static final String TABLE_SUMMARY_EDITOR_COLUMN_HISTOGRAM = StatisticSelectionDefinitions.HISTOGRAM;
    public static final String TABLE_SUMMARY_EDITOR_COLUMN_DATA_TYPE = DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_DATA_TYPE");
    public static final String TABLE_SUMMARY_EDITOR_COLUMN_PERCENT_NULL = StatisticSelectionDefinitions.PERCENT_NULL;
    public static final String TABLE_SUMMARY_EDITOR_COLUMN_DISTINCT = StatisticSelectionDefinitions.DISTINCT;
    public static final String TABLE_SUMMARY_EDITOR_PERCENT_DISTINCT = StatisticSelectionDefinitions.DISTINCT_PCNT;
    public static final String TABLE_SUMMARY_EDITOR_COLUMN_MODE = StatisticSelectionDefinitions.MODE;
    public static final String TABLE_SUMMARY_EDITOR_COLUMN_AVG = StatisticSelectionDefinitions.AVG;
    public static final String TABLE_SUMMARY_EDITOR_COLUMN_MEDIAN = StatisticSelectionDefinitions.MEDIAN;
    public static final String TABLE_SUMMARY_EDITOR_COLUMN_MIN = StatisticSelectionDefinitions.MIN;
    public static final String TABLE_SUMMARY_EDITOR_COLUMN_MAX = StatisticSelectionDefinitions.MAX;
    public static final String TABLE_SUMMARY_EDITOR_COLUMN_STD = StatisticSelectionDefinitions.STD;
    public static final String TABLE_SUMMARY_EDITOR_COLUMN_VAR = StatisticSelectionDefinitions.VAR;
    public static final String TABLE_SUMMARY_EDITOR_COLUMN_SKEWNESS = StatisticSelectionDefinitions.SKEWNESS;
    public static final String TABLE_SUMMARY_EDITOR_COLUMN_KURTOSIS = StatisticSelectionDefinitions.KURTOSIS;
    private Map<Integer, String> idtoName = new HashMap<Integer, String>();
    private Map<String, Integer> nametoId = new HashMap<String, Integer>();
    private Vector<String> columns = new Vector();

    private Vector<String> createLoadingColumnVector() {
        int n = 0;
        if (!this.idtoName.isEmpty()) {
            this.idtoName.clear();
        }
        if (!this.nametoId.isEmpty()) {
            this.nametoId.clear();
        }
        if (!this.columns.isEmpty()) {
            this.columns.clear();
        }
        this.columns.add(TABLE_SUMMARY_EDITOR_STATUS);
        this.idtoName.put(n, TABLE_SUMMARY_EDITOR_STATUS);
        this.nametoId.put(TABLE_SUMMARY_EDITOR_STATUS, n++);
        return this.columns;
    }

    private Vector<String> createColumnVector(StatsSelection statsSelection) {
        int n = 0;
        if (!this.idtoName.isEmpty()) {
            this.idtoName.clear();
        }
        if (!this.nametoId.isEmpty()) {
            this.nametoId.clear();
        }
        if (!this.columns.isEmpty()) {
            this.columns.clear();
        }
        this.columns.add(TABLE_SUMMARY_EDITOR_COLUMN_NAME);
        this.idtoName.put(n, TABLE_SUMMARY_EDITOR_COLUMN_NAME);
        this.nametoId.put(TABLE_SUMMARY_EDITOR_COLUMN_NAME, n++);
        if (statsSelection.isHistogram()) {
            this.columns.add(TABLE_SUMMARY_EDITOR_COLUMN_HISTOGRAM);
            this.idtoName.put(n, TABLE_SUMMARY_EDITOR_COLUMN_HISTOGRAM);
            this.nametoId.put(TABLE_SUMMARY_EDITOR_COLUMN_HISTOGRAM, n++);
        }
        this.columns.add(TABLE_SUMMARY_EDITOR_COLUMN_DATA_TYPE);
        this.idtoName.put(n, TABLE_SUMMARY_EDITOR_COLUMN_DATA_TYPE);
        this.nametoId.put(TABLE_SUMMARY_EDITOR_COLUMN_DATA_TYPE, n++);
        if (statsSelection.isPercentnull()) {
            this.columns.add(TABLE_SUMMARY_EDITOR_COLUMN_PERCENT_NULL);
            this.idtoName.put(n, TABLE_SUMMARY_EDITOR_COLUMN_PERCENT_NULL);
            this.nametoId.put(TABLE_SUMMARY_EDITOR_COLUMN_PERCENT_NULL, n++);
        }
        if (statsSelection.isPercentdistinct()) {
            this.columns.add(TABLE_SUMMARY_EDITOR_COLUMN_DISTINCT);
            this.idtoName.put(n, TABLE_SUMMARY_EDITOR_COLUMN_DISTINCT);
            this.nametoId.put(TABLE_SUMMARY_EDITOR_COLUMN_DISTINCT, n++);
            this.columns.add(TABLE_SUMMARY_EDITOR_PERCENT_DISTINCT);
            this.idtoName.put(n, TABLE_SUMMARY_EDITOR_PERCENT_DISTINCT);
            this.nametoId.put(TABLE_SUMMARY_EDITOR_PERCENT_DISTINCT, n++);
        }
        if (statsSelection.isMode()) {
            this.columns.add(TABLE_SUMMARY_EDITOR_COLUMN_MODE);
            this.idtoName.put(n, TABLE_SUMMARY_EDITOR_COLUMN_MODE);
            this.nametoId.put(TABLE_SUMMARY_EDITOR_COLUMN_MODE, n++);
        }
        if (statsSelection.isAvg()) {
            this.columns.add(TABLE_SUMMARY_EDITOR_COLUMN_AVG);
            this.idtoName.put(n, TABLE_SUMMARY_EDITOR_COLUMN_AVG);
            this.nametoId.put(TABLE_SUMMARY_EDITOR_COLUMN_AVG, n++);
        }
        if (statsSelection.isMedian()) {
            this.columns.add(TABLE_SUMMARY_EDITOR_COLUMN_MEDIAN);
            this.idtoName.put(n, TABLE_SUMMARY_EDITOR_COLUMN_MEDIAN);
            this.nametoId.put(TABLE_SUMMARY_EDITOR_COLUMN_MEDIAN, n++);
        }
        if (statsSelection.isMin()) {
            this.columns.add(TABLE_SUMMARY_EDITOR_COLUMN_MIN);
            this.idtoName.put(n, TABLE_SUMMARY_EDITOR_COLUMN_MIN);
            this.nametoId.put(TABLE_SUMMARY_EDITOR_COLUMN_MIN, n++);
        }
        if (statsSelection.isMax()) {
            this.columns.add(TABLE_SUMMARY_EDITOR_COLUMN_MAX);
            this.idtoName.put(n, TABLE_SUMMARY_EDITOR_COLUMN_MAX);
            this.nametoId.put(TABLE_SUMMARY_EDITOR_COLUMN_MAX, n++);
        }
        if (statsSelection.isStd()) {
            this.columns.add(TABLE_SUMMARY_EDITOR_COLUMN_STD);
            this.idtoName.put(n, TABLE_SUMMARY_EDITOR_COLUMN_STD);
            this.nametoId.put(TABLE_SUMMARY_EDITOR_COLUMN_STD, n++);
        }
        if (statsSelection.isVar()) {
            this.columns.add(TABLE_SUMMARY_EDITOR_COLUMN_VAR);
            this.idtoName.put(n, TABLE_SUMMARY_EDITOR_COLUMN_VAR);
            this.nametoId.put(TABLE_SUMMARY_EDITOR_COLUMN_VAR, n++);
        }
        if (statsSelection.isSkewness()) {
            this.columns.add(TABLE_SUMMARY_EDITOR_COLUMN_SKEWNESS);
            this.idtoName.put(n, TABLE_SUMMARY_EDITOR_COLUMN_SKEWNESS);
            this.nametoId.put(TABLE_SUMMARY_EDITOR_COLUMN_SKEWNESS, n++);
        }
        if (statsSelection.isKurtosis()) {
            this.columns.add(TABLE_SUMMARY_EDITOR_COLUMN_KURTOSIS);
            this.idtoName.put(n, TABLE_SUMMARY_EDITOR_COLUMN_KURTOSIS);
            this.nametoId.put(TABLE_SUMMARY_EDITOR_COLUMN_KURTOSIS, n++);
        }
        return this.columns;
    }

    public Integer getColumnColumnName() {
        return this.nametoId.get(TABLE_SUMMARY_EDITOR_COLUMN_NAME);
    }

    public Integer getColumnHistogram() {
        return this.nametoId.get(TABLE_SUMMARY_EDITOR_COLUMN_HISTOGRAM);
    }

    public Integer getColumnDataType() {
        return this.nametoId.get(TABLE_SUMMARY_EDITOR_COLUMN_DATA_TYPE);
    }

    public Integer getColumnPercentNull() {
        return this.nametoId.get(TABLE_SUMMARY_EDITOR_COLUMN_PERCENT_NULL);
    }

    public Integer getColumnDistinct() {
        return this.nametoId.get(TABLE_SUMMARY_EDITOR_COLUMN_DISTINCT);
    }

    public Integer getColumnPercentDistinct() {
        return this.nametoId.get(TABLE_SUMMARY_EDITOR_PERCENT_DISTINCT);
    }

    public Integer getColumnMode() {
        return this.nametoId.get(TABLE_SUMMARY_EDITOR_COLUMN_MODE);
    }

    public Integer getColumnAvg() {
        return this.nametoId.get(TABLE_SUMMARY_EDITOR_COLUMN_AVG);
    }

    public Integer getColumnMedian() {
        return this.nametoId.get(TABLE_SUMMARY_EDITOR_COLUMN_MEDIAN);
    }

    public Integer getColumnMin() {
        return this.nametoId.get(TABLE_SUMMARY_EDITOR_COLUMN_MIN);
    }

    public Integer getColumnMax() {
        return this.nametoId.get(TABLE_SUMMARY_EDITOR_COLUMN_MAX);
    }

    public Integer getColumnStd() {
        return this.nametoId.get(TABLE_SUMMARY_EDITOR_COLUMN_STD);
    }

    public Integer getColumnVar() {
        return this.nametoId.get(TABLE_SUMMARY_EDITOR_COLUMN_VAR);
    }

    public Integer getColumnSkewness() {
        return this.nametoId.get(TABLE_SUMMARY_EDITOR_COLUMN_SKEWNESS);
    }

    public Integer getColumnKurtosis() {
        return this.nametoId.get(TABLE_SUMMARY_EDITOR_COLUMN_KURTOSIS);
    }

    public DataProfileStatisticsModel(List<DataProfileStatisticsData> list, StatsSelection statsSelection) {
        this.setColumnIdentifiers(this.createColumnVector(statsSelection));
        for (DataProfileStatisticsData dataProfileStatisticsData : list) {
            this.srcData.add(dataProfileStatisticsData);
        }
        Collections.sort(this.srcData);
    }

    public DataProfileStatisticsModel(String string) {
        this.setColumnIdentifiers(this.createLoadingColumnVector());
        DataProfileStatisticsData dataProfileStatisticsData = new DataProfileStatisticsData(string);
        this.srcData.add(dataProfileStatisticsData);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        DataProfileStatisticsData dataProfileStatisticsData = (DataProfileStatisticsData)this.srcData.get(n);
        Object object = null;
        String string = this.idtoName.get(n2);
        if (string.equals(TABLE_SUMMARY_EDITOR_COLUMN_NAME)) {
            object = StringUtils.trimDoubleQuotes(dataProfileStatisticsData.getName());
        } else if (string.equals(TABLE_SUMMARY_EDITOR_STATUS)) {
            object = StringUtils.trimDoubleQuotes(dataProfileStatisticsData.getName());
        } else if (string.equals(TABLE_SUMMARY_EDITOR_COLUMN_DATA_TYPE)) {
            object = dataProfileStatisticsData.getDataType();
        } else if (string.equals(TABLE_SUMMARY_EDITOR_COLUMN_PERCENT_NULL)) {
            object = dataProfileStatisticsData.getPercentNulls();
        } else if (string.equals(TABLE_SUMMARY_EDITOR_COLUMN_DISTINCT)) {
            object = dataProfileStatisticsData.getNumOfDistincts();
        } else if (string.equals(TABLE_SUMMARY_EDITOR_PERCENT_DISTINCT)) {
            object = dataProfileStatisticsData.getPercentOfDistincts();
        } else if (string.equals(TABLE_SUMMARY_EDITOR_COLUMN_MODE)) {
            object = dataProfileStatisticsData.getMode();
        } else if (string.equals(TABLE_SUMMARY_EDITOR_COLUMN_AVG)) {
            object = dataProfileStatisticsData.getAvg();
        } else if (string.equals(TABLE_SUMMARY_EDITOR_COLUMN_MEDIAN)) {
            object = dataProfileStatisticsData.getMedian();
        } else if (string.equals(TABLE_SUMMARY_EDITOR_COLUMN_MIN)) {
            object = dataProfileStatisticsData.getMin();
        } else if (string.equals(TABLE_SUMMARY_EDITOR_COLUMN_MAX)) {
            object = dataProfileStatisticsData.getMax();
        } else if (string.equals(TABLE_SUMMARY_EDITOR_COLUMN_STD)) {
            object = dataProfileStatisticsData.getStd();
        } else if (string.equals(TABLE_SUMMARY_EDITOR_COLUMN_VAR)) {
            object = dataProfileStatisticsData.getVar();
        } else if (string.equals(TABLE_SUMMARY_EDITOR_COLUMN_SKEWNESS)) {
            object = dataProfileStatisticsData.getSkewness();
        } else if (string.equals(TABLE_SUMMARY_EDITOR_COLUMN_KURTOSIS)) {
            object = dataProfileStatisticsData.getKurtosis();
        } else if (string.equals(TABLE_SUMMARY_EDITOR_COLUMN_HISTOGRAM)) {
            object = dataProfileStatisticsData.getGraphDataModel();
            if (object instanceof DefaultGraphDataModel) {
                ((DefaultGraphDataModel)object).setComment(MessageFormat.format(DataProfileStatisticsLrb.get("DETAIL_TABLE_TOOL_TIP_HISTOGRAM"), dataProfileStatisticsData.getName()));
            }
        } else assert (false) : "Out of bounds column when accessing statistics";
        if (object instanceof Date || object instanceof Timestamp || object instanceof GregorianCalendar) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = null;
            SimpleDateFormat simpleDateFormat = null;
            if (object instanceof Timestamp) {
                simpleDateFormat = TimeUtils.getExplorerNodeTimestampFormat();
                stringBuffer2 = simpleDateFormat.format((Date)((Timestamp)object), stringBuffer, new FieldPosition(0));
            } else if (object instanceof Date) {
                simpleDateFormat = TimeUtils.getExplorerNodeDateFormat();
                stringBuffer2 = simpleDateFormat.format((Date)object, stringBuffer, new FieldPosition(0));
            } else if (object instanceof GregorianCalendar) {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
                simpleDateFormat = TimeUtils.getExplorerNodeFormatTimestampTimeZone();
                simpleDateFormat.setTimeZone(gregorianCalendar.getTimeZone());
                Date date = gregorianCalendar.getTime();
                simpleDateFormat.format(date, stringBuffer, new FieldPosition(0));
                stringBuffer2 = new StringBuffer(TimeUtils.removeGMT(stringBuffer.toString()));
            }
            return stringBuffer2.toString().toUpperCase();
        }
        return object != null ? object : "";
    }

    public Comparator getColumnSortComparator(int n) {
        String string = this.idtoName.get(n);
        if (string.equals(TABLE_SUMMARY_EDITOR_COLUMN_PERCENT_NULL) || string.equals(TABLE_SUMMARY_EDITOR_COLUMN_DISTINCT) || string.equals(TABLE_SUMMARY_EDITOR_PERCENT_DISTINCT) || string.equals(TABLE_SUMMARY_EDITOR_COLUMN_AVG) || string.equals(TABLE_SUMMARY_EDITOR_COLUMN_MEDIAN) || string.equals(TABLE_SUMMARY_EDITOR_COLUMN_MIN) || string.equals(TABLE_SUMMARY_EDITOR_COLUMN_MAX) || string.equals(TABLE_SUMMARY_EDITOR_COLUMN_STD) || string.equals(TABLE_SUMMARY_EDITOR_COLUMN_VAR) || string.equals(TABLE_SUMMARY_EDITOR_COLUMN_SKEWNESS) || string.equals(TABLE_SUMMARY_EDITOR_COLUMN_KURTOSIS)) {
            return NumberComparator.getComparator();
        }
        return super.getColumnSortComparator(n);
    }

    public void setFailedStatus() {
        DataProfileStatisticsData dataProfileStatisticsData = new DataProfileStatisticsData(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILED_TO_LOAD_TABLE_SUMMARY"));
        this.srcData.clear();
        this.addRow(dataProfileStatisticsData);
    }
}

