/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.core.model.common.Range;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;

class RangeCellEditorPanel
extends JPanel {
    private Range range;
    private JButton jApplyBtn;
    private JCheckBox jMaxChk;
    private JSpinner jMaxSpn;
    private JLabel jMessageLbl;
    private JCheckBox jMinChk;
    private JSpinner jMinSpn;
    private JPanel subPanel;

    public RangeCellEditorPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jMinChk = new JCheckBox();
        this.jMinSpn = new JSpinner();
        this.jMaxChk = new JCheckBox();
        this.jMaxSpn = new JSpinner();
        this.subPanel = new JPanel();
        this.jMessageLbl = new JLabel();
        this.jApplyBtn = new JButton();
        this.setLayout(new GridBagLayout());
        this.jMinChk.setText("Min");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.jMinChk, gridBagConstraints);
        this.jMinSpn.setMaximumSize(new Dimension(300, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.add((Component)this.jMinSpn, gridBagConstraints);
        this.jMaxChk.setText("Max");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.jMaxChk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.jMaxSpn, gridBagConstraints);
        this.jMessageLbl.setForeground(new Color(102, 102, 102));
        this.jMessageLbl.setText("0.0 < value");
        this.jApplyBtn.setText("Apply");
        GroupLayout groupLayout = new GroupLayout(this.subPanel);
        this.subPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jMessageLbl, -1, 169, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jApplyBtn).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMessageLbl).addComponent(this.jApplyBtn)).addGap(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.subPanel, gridBagConstraints);
    }

    private void initRes() {
        this.jApplyBtn.setText(CoreCommonLrb.get((String)"APPLY"));
        this.jMinChk.setText(CoreCommonLrb.get((String)"MINIMUM_SHORT"));
        this.jMaxChk.setText(CoreCommonLrb.get((String)"MAXIMUM_SHORT"));
    }

    private void initUI() {
        RangeChangeListener rangeChangeListener = new RangeChangeListener();
        this.jMinChk.addActionListener(rangeChangeListener);
        this.jMaxChk.addActionListener(rangeChangeListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.jApplyBtn.addActionListener(actionListener);
    }

    public void setRange(Range range) {
        this.range = range;
        this.initSpinners();
        this.showOrHideMax();
        this.showHint();
    }

    private void initSpinners() {
        SpinnerNumberModel spinnerNumberModel = null;
        SpinnerNumberModel spinnerNumberModel2 = null;
        Range.Type type = this.range.getType();
        switch (type) {
            case PERCENTAGE: 
            case DOUBLE: 
            case POSITIVE_DOUBLE: {
                double d = this.range.getMin() != null ? this.range.getMin().doubleValue() : 0.0;
                double d2 = this.range.getMax() != null ? this.range.getMax().doubleValue() : 0.0;
                double d3 = type.getMinAllowed().doubleValue();
                double d4 = type.getMaxAllowed().doubleValue();
                double d5 = type.getSuggestedStep().doubleValue();
                spinnerNumberModel = new SpinnerNumberModel(d, d3, d4, d5);
                spinnerNumberModel2 = new SpinnerNumberModel(d2, d3, d4, d5);
                break;
            }
            case INTEGER: 
            case POSITIVE_INTEGER: {
                int n = this.range.getMin() != null ? this.range.getMin().intValue() : 0;
                int n2 = this.range.getMax() != null ? this.range.getMax().intValue() : 0;
                int n3 = type.getMinAllowed().intValue();
                int n4 = type.getMaxAllowed().intValue();
                int n5 = type.getSuggestedStep().intValue();
                spinnerNumberModel = new SpinnerNumberModel(n, n3, n4, n5);
                spinnerNumberModel2 = new SpinnerNumberModel(n2, n3, n4, n5);
                break;
            }
            default: {
                assert (false) : "Invalid option";
                break;
            }
        }
        this.jMinSpn.setModel(spinnerNumberModel);
        this.jMaxSpn.setModel(spinnerNumberModel2);
        this.disableSpinnersIfNoValue();
    }

    private void disableSpinnersIfNoValue() {
        boolean bl = this.range.getMin() != null;
        this.jMinChk.setSelected(bl);
        this.jMinSpn.setEnabled(bl);
        boolean bl2 = this.range.getMax() != null;
        this.jMaxChk.setSelected(bl2);
        this.jMaxSpn.setEnabled(bl2);
    }

    private void showOrHideMax() {
        boolean bl = !this.range.isOnlyMin();
        this.jMaxChk.setVisible(bl);
        this.jMaxSpn.setVisible(bl);
    }

    private void showHint() {
        String string = "";
        Range.Type type = this.range.getType();
        switch (type) {
            case PERCENTAGE: {
                string = MessageFormat.format(ControlsLrb.get("RANGE_EDITOR_HINT_MAX"), Double.toString(0.0), Double.toString(1.0));
                break;
            }
            case DOUBLE: {
                string = ControlsLrb.get("RANGE_EDITOR_HINT_DEC");
                break;
            }
            case POSITIVE_DOUBLE: {
                string = MessageFormat.format(ControlsLrb.get("RANGE_EDITOR_HINT"), Double.toString(0.0));
                break;
            }
            case INTEGER: {
                string = ControlsLrb.get("RANGE_EDITOR_HINT_INT");
                break;
            }
            case POSITIVE_INTEGER: {
                string = MessageFormat.format(ControlsLrb.get("RANGE_EDITOR_HINT"), Integer.toString(0));
                break;
            }
            default: {
                assert (false) : "Invalid option";
                break;
            }
        }
        this.jMessageLbl.setText(string);
    }

    public Range getRange() {
        Number number = this.jMinChk.isSelected() ? (Number)((Number)this.jMinSpn.getValue()) : (Number)null;
        Range range = null;
        if (this.range.isOnlyMin()) {
            range = new Range(this.range.getType(), number);
        } else {
            Number number2 = this.jMaxChk.isSelected() ? (Number)((Number)this.jMaxSpn.getValue()) : (Number)null;
            range = new Range(this.range.getType(), number, number2);
        }
        return range;
    }

    private class RangeChangeListener
    implements ActionListener {
        private RangeChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.enableSpinners(actionEvent.getSource());
        }

        private void enableSpinners(Object object) {
            if (object == RangeCellEditorPanel.this.jMinChk) {
                RangeCellEditorPanel.this.jMinSpn.setEnabled(RangeCellEditorPanel.this.jMinChk.isSelected());
            } else if (object == RangeCellEditorPanel.this.jMaxChk) {
                RangeCellEditorPanel.this.jMaxSpn.setEnabled(RangeCellEditorPanel.this.jMaxChk.isSelected());
            } else assert (false) : "invalid source";
        }
    }
}

