/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.DialogOkExecutor;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.workflow.dialog.WritablePanel;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;

public class DialogHelper {
    private static final Logger LOGGER = Logger.getLogger(DialogHelper.class.getName());
    public static final String CANCELLED = "DIALOG_CANCELLED";
    private DialogDisplayable displayable;
    private DialogOkExecutor executor;
    private Dialogable dialogable;
    private JEWTDialog dialog;
    private JComponent content;

    public DialogHelper(DialogDisplayable dialogDisplayable) {
        this.displayable = dialogDisplayable;
    }

    public void setDialogOkExecutor(DialogOkExecutor dialogOkExecutor) {
        this.executor = dialogOkExecutor;
    }

    public boolean showAsDialog() {
        return this.showAsDialog((Component)Ide.getMainWindow());
    }

    public boolean showAsDialog(Component component) {
        component = component != null ? component : Ide.getMainWindow();
        try {
            this.buildDialog(component);
            this.customizeDialog();
        }
        catch (Exception exception) {
            this.unexpectedErrorHandler(exception, component);
            return false;
        }
        boolean bl = false;
        try {
            bl = this.invoke();
        }
        catch (Exception exception) {
            this.unexpectedErrorHandler(exception, (Component)this.dialog);
        }
        return bl;
    }

    private void buildDialog(Component component) {
        this.createDialog(component);
        this.tryAssingOkExecutor();
        this.setHelpTopic();
    }

    private void createDialog(Component component) {
        this.dialogable = this.displayable.asDialog();
        this.content = this.dialogable.getContent();
        String string = this.dialogable.getTitle();
        int n = this.dialogable.getButtonMask();
        JEWTDialog jEWTDialog = null;
        while (component != null) {
            if (component instanceof Dialog) {
                jEWTDialog = new CustomJEWTDialog((Dialog)component, string, n);
                break;
            }
            if (component instanceof Frame) {
                jEWTDialog = new CustomJEWTDialog((Frame)component, string, n);
                break;
            }
            component = SwingUtilities.getWindowAncestor(component);
        }
        if (jEWTDialog == null) {
            jEWTDialog = new JEWTDialog((Frame)Ide.getMainWindow(), string, n);
        }
        this.dialog = jEWTDialog;
        this.dialog.setContent((Component)this.content);
        this.dialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                DialogHelper.this.dialogable.onWindowClose();
            }
        });
    }

    private void tryAssingOkExecutor() {
        if (this.dialogable instanceof DialogOkExecutor) {
            this.executor = (DialogOkExecutor)((Object)this.dialogable);
        }
    }

    private void setHelpTopic() {
        if (this.isHelpButtonActive()) {
            String string = this.dialogable.getHelpTopic();
            if (StringUtils.isEmpty(string)) {
                LOGGER.log(Level.WARNING, "Help topic is required for the specified button mask");
            } else {
                HelpSystem.getHelpSystem().registerTopic(this.content, string);
            }
        }
    }

    private boolean isHelpButtonActive() {
        int n = this.dialogable.getButtonMask();
        return (n & 4) > 0;
    }

    private void customizeDialog() {
        this.dialogable.customizeDialogProperties(this.dialog);
        this.dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                boolean bl;
                if (DialogHelper.this.executor == null) {
                    if (ConfigUtils.isDebugBuild()) {
                        LOGGER.log(Level.WARNING, "No Executor defined for this Dialog");
                    }
                    return;
                }
                boolean bl2 = "closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue());
                boolean bl3 = bl = "closed".equals(propertyChangeEvent.getPropertyName()) && DialogHelper.CANCELLED.equals(propertyChangeEvent.getNewValue());
                if (bl2) {
                    try {
                        this.execute();
                    }
                    catch (DialogExecutionException dialogExecutionException) {
                        DialogHelper.this.dialogable.onFailure(dialogExecutionException, DialogHelper.this.dialog);
                        throw new PropertyVetoException("onOK", propertyChangeEvent);
                    }
                    catch (Exception exception) {
                        DialogHelper.this.unexpectedErrorHandler(exception, (Component)DialogHelper.this.dialog);
                        throw new PropertyVetoException("onOK", propertyChangeEvent);
                    }
                } else if (bl && !DialogHelper.this.dialogable.canBeCanceled()) {
                    throw new PropertyVetoException("onCancel", propertyChangeEvent);
                }
            }

            private void execute() throws DialogExecutionException {
                try {
                    DialogHelper.this.executor.onOK();
                }
                catch (DataMinerException dataMinerException) {
                    throw new DialogExecutionException(dataMinerException.getTitle(), dataMinerException.getMessage(), dataMinerException);
                }
            }
        });
        if (this.content instanceof WritablePanel) {
            WritablePanel writablePanel = (WritablePanel)((Object)this.content);
            this.dialog.setOKButtonEnabled(writablePanel.isWritable());
        }
    }

    private boolean invoke() {
        if (WizardLauncher.runDialog((JDialog)this.dialog)) {
            return true;
        }
        this.dialogable.onCancel();
        return false;
    }

    private void unexpectedErrorHandler(Exception exception, Component component) {
        ExceptionDialog.showExceptionDialog((Component)component, (Throwable)exception, (String)CommonLrb.get("ERROR"), (String)CommonLrb.get("MSG_EXCEPTION"), null);
    }

    private class CustomJEWTDialog
    extends JEWTDialog {
        public CustomJEWTDialog(Dialog dialog, String string, int n) {
            super(dialog, string, n);
        }

        public CustomJEWTDialog(Frame frame, String string, int n) {
            super(frame, string, n);
        }

        protected void dismissDialog(boolean bl) {
            if (bl) {
                try {
                    super.fireVetoableChange("closed", (Object)Boolean.FALSE, (Object)DialogHelper.CANCELLED);
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
                super.dismissDialog(bl);
            } else {
                super.dismissDialog(bl);
            }
        }

        public void dispose() {
            super.dispose();
            DialogHelper.this.dialogable.onWindowClose();
        }
    }
}

