/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.ds.GetAccessableTablesQuery;
import oracle.dmt.dataminer.core.model.ds.Table;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.workflow.TableChooserPreferenceSettings;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class TableChooserModel
extends ODMrTableModel<Table> {
    private static final String[] COLUMN_NAMES = new String[]{ControlsLrb.get("TABLE_CHOOSER_TABLES_LIST_NAME"), ControlsLrb.get("TABLE_CHOOSER_TABLES_LIST_TYPE")};
    static final int SCHEMA_TABLE_NAME = 0;
    static final int TYPE = 1;
    static final int SCHEMA = 2;
    static final int TABLE_NAME = 3;
    private String _ownerSchema;
    private Context _context;
    private boolean tablesOnly;
    private boolean _ownerOnly;
    private String _connectionName;
    private TableChooserPreferenceSettings _tableChooserPrefenceSettings;
    private ConnectionManager connManager;
    private SqlDataAccessObject dao;

    public TableChooserModel(String string, Context context) {
        super(COLUMN_NAMES);
        assert (string != null) : "Can not pass a null ownerSchema in to the constructor";
        assert (context != null) : "Can not pass a null context in to the constructor";
        this._context = context;
        this._ownerSchema = string;
        this._ownerOnly = true;
        this._connectionName = ConnectionFolder.getConnectionName(this._context);
        this._tableChooserPrefenceSettings = TableChooserPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
        this.connManager = ConnectionFolder.getConnectionFolder(context);
        this.dao = new SqlDataAccessObject(this.connManager);
    }

    public int selectRow(String string, String string2) {
        int n = -1;
        for (int i = 0; i < this.srcData.size(); ++i) {
            Table table = (Table)this.srcData.get(i);
            if (!table.getSchema().equals(string) || !table.getName().equals(string2)) continue;
            n = i;
            break;
        }
        return n;
    }

    @Override
    public Table getRow(int n) {
        return (Table)this.srcData.get(n);
    }

    public List<Table> load() throws ODMrDAOException {
        Object object2;
        ListStructure listStructure = this._tableChooserPrefenceSettings.getIncludedSchemaList(this._connectionName);
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add(this._ownerSchema);
        if (!this._ownerOnly) {
            for (Object object2 : listStructure) {
                treeSet.add(object2.toString());
            }
        }
        Iterator iterator = new GetAccessableTablesQuery(this.connManager.getDbVersion(), treeSet).setTablesOnly(this.tablesOnly);
        object2 = this.dao.readItems((Query)iterator);
        return object2;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!" + n + " of " + this.getRowCount();
        Table table = (Table)this.srcData.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                if (this.isOwnerOnly()) {
                    if (this._ownerSchema != null) {
                        if (this._ownerSchema.equals(table.getSchema())) {
                            string = table.getName();
                            break;
                        }
                        string = table.getFullName();
                        break;
                    }
                    string = table.getName();
                    break;
                }
                string = table.getFullName();
                break;
            }
            case 2: {
                string = table.getSchema();
                break;
            }
            case 1: {
                string = table.getType();
                break;
            }
            case 3: {
                string = table.getName();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing list of tables";
                break;
            }
        }
        return string;
    }

    public void setOwnerOnly(boolean bl) {
        this._ownerOnly = bl;
    }

    public boolean isOwnerOnly() {
        return this._ownerOnly;
    }

    public String getOwnerSchema() {
        return this._ownerSchema;
    }

    public void setTablesOnly(boolean bl) {
        this.tablesOnly = bl;
    }

    public boolean isTablesOnly() {
        return this.tablesOnly;
    }
}

