/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;

public class GraphicalPreferencesSettings
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.dmt.dataminer.controls.GraphicalPreferencesSettings";
    public static final String HISTOGRAM_GRAPH_STYLE = "histogram_graph_style";
    public static final String HISTOGRAM_RADIUS_DEPTH = "radius_depth";

    static GraphicalPreferencesSettings getInstance() {
        return GraphicalPreferencesSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private GraphicalPreferencesSettings(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static GraphicalPreferencesSettings getInstance(PropertyStorage propertyStorage) {
        return new GraphicalPreferencesSettings(GraphicalPreferencesSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public List getColumnPositions() {
        ArrayList arrayList = new ArrayList();
        ListStructure listStructure = this._hash.getListStructure("columnPositions");
        if (listStructure != null && listStructure.size() > 0) {
            arrayList.addAll(listStructure);
        }
        return arrayList;
    }

    public void setColumnPositions(List list) {
        if (list != null && list.size() > 0) {
            ListStructure listStructure = ListStructure.newInstance();
            listStructure.addAll((Collection)list);
            this._hash.putListStructure("columnPositions", listStructure);
        }
    }

    public int[] getHiddenColumns() {
        return this.getIntArray("hiddenColumns");
    }

    public void setHiddenColumns(int[] nArray) {
        this.setIntArray("hiddenColumns", nArray);
    }

    public int[] getColumnWidths() {
        return this.getIntArray("columnWidths");
    }

    public void setColumnWidths(int[] nArray) {
        this.setIntArray("columnWidths", nArray);
    }

    public void setSorted(boolean bl) {
        this._hash.putBoolean("setSorted", bl);
    }

    public boolean isSorted() {
        return this._hash.getBoolean("isSorted", true);
    }

    public void setSortColumn(int n) {
        this._hash.putInt("sortColumn", n);
    }

    public int getSortColumn() {
        return this._hash.getInt("sortColumn");
    }

    public boolean isSortAscending() {
        return this._hash.getBoolean("sortAscending", true);
    }

    public void setSortAscending(boolean bl) {
        this._hash.putBoolean("sortAscending", bl);
    }

    private int[] getIntArray(String string) {
        ArrayList arrayList = new ArrayList();
        ListStructure listStructure = this._hash.getListStructure(string);
        if (listStructure != null && listStructure.size() > 0) {
            arrayList.addAll(listStructure);
        }
        int[] nArray = null;
        if (arrayList.size() > 0) {
            int n = 0;
            nArray = new int[arrayList.size()];
            for (Object e : arrayList) {
                nArray[n++] = (Integer)e;
            }
        }
        return nArray;
    }

    private void setIntArray(String string, int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            ListStructure listStructure = ListStructure.newInstance();
            for (int n : nArray) {
                listStructure.add((Object)n);
            }
            this._hash.putListStructure(string, listStructure);
        }
    }

    public void setShowStatistics(Boolean bl) {
        this._hash.putBoolean("show_xforms_stats", bl.booleanValue());
    }

    public Boolean isShowStatistics() {
        return this._hash.getBoolean("show_xforms_stats", true);
    }

    public void setNumberOfBins(int n) {
        this._hash.putInt("number_of_bins", n);
    }

    public int getNumberOfBins() {
        return this._hash.getInt("number_of_bins", 10);
    }

    public void addStructureChangeListener(StructureChangeListener structureChangeListener) {
        this._hash.addStructureChangeListener(structureChangeListener);
    }

    public void removeStructureChangeListener(StructureChangeListener structureChangeListener) {
        this._hash.removeStructureChangeListener(structureChangeListener);
    }

    public void setGraphStyle(String string) {
        this._hash.putString(HISTOGRAM_GRAPH_STYLE, string);
    }

    public String getGraphStyle() {
        return this._hash.getString(HISTOGRAM_GRAPH_STYLE, ControlsLrb.get("HISTOGRAM_NAUTICAL_STYLE_PATH"));
    }

    public void setRadiusDepthValue(int n) {
        this._hash.putInt(HISTOGRAM_RADIUS_DEPTH, n);
    }

    public int getRadiusDepthValue() {
        return this._hash.getInt(HISTOGRAM_RADIUS_DEPTH, 0);
    }
}

