/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;
import oracle.dmt.dataminer.controls.CalendarDateProvider;
import oracle.dmt.dataminer.controls.DayComponent;
import oracle.dmt.dataminer.controls.MonthComponent;
import oracle.dmt.dataminer.controls.TimeDisplayPanel;
import oracle.dmt.dataminer.controls.TimeEditPanel;
import oracle.dmt.dataminer.controls.YearComponent;
import oracle.dmt.dataminer.core.model.time.Day;

public class CalendarPanel
extends JPanel {
    private ActionListener _listener;
    private Calendar _cal;
    private Locale _locale;
    private boolean _isMultiSelect;
    private boolean _showTime;
    private boolean _editTime;
    private DayComponent _dayPanel;
    private MonthComponent _monthPanel;
    private YearComponent _yearPanel;
    private TimeDisplayPanel _timeDisplay;
    private TimeEditPanel _timeEditor;
    private JButton _previousButton;
    private JButton _nextButton;
    private TreeSet<Day> _selectedDays;

    public CalendarPanel(Locale locale) {
        this(false, locale);
    }

    public CalendarPanel(boolean bl, Locale locale) {
        this._isMultiSelect = bl;
        this._selectedDays = new TreeSet();
        this._locale = locale;
        this._init();
        this.setSelectedDate(new Date());
    }

    public CalendarPanel(Calendar calendar, Locale locale) {
        this._cal = calendar;
        this._isMultiSelect = false;
        this._selectedDays = new TreeSet();
        this._locale = locale;
        this._createSubcomponents();
        this.setTimeZone(this._cal.getTimeZone());
        this._layoutComponents();
        this.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(2, 4, 8, 4)));
        this.setBackground(UIManager.getColor("TextArea.background"));
        this.setSelectedDate(new Date());
    }

    private void _init() {
        this._cal = Calendar.getInstance(this._locale);
        this._cal.setTime(new Date());
        this._cal.setMinimalDaysInFirstWeek(1);
        this._createSubcomponents();
        this.setTimeZone(this._cal.getTimeZone());
        this._layoutComponents();
        this.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(2, 4, 8, 4)));
        this.setBackground(UIManager.getColor("TextArea.background"));
    }

    private void _createSubcomponents() {
        this._dayPanel = new DayComponent(this._cal, this._isMultiSelect, this._selectedDays, this._locale);
        this._yearPanel = new YearComponent(this._cal, this._dayPanel);
        this._monthPanel = new MonthComponent(this._cal, this._dayPanel, this._locale);
        this._timeDisplay = new TimeDisplayPanel(this._locale, this._cal);
        this._timeEditor = new TimeEditPanel(this._locale, this._cal);
        this._previousButton = new BasicArrowButton(7);
        this._nextButton = new BasicArrowButton(3);
        this._previousButton.setBackground(UIManager.getColor("TextArea.background"));
        this._nextButton.setBackground(UIManager.getColor("TextArea.background"));
        this._previousButton.setOpaque(false);
        this._nextButton.setOpaque(false);
        this._previousButton.setBorderPainted(false);
        this._previousButton.setAction(null);
        this._nextButton.setBorderPainted(false);
        ArrowButtonListener arrowButtonListener = new ArrowButtonListener();
        this._previousButton.addActionListener(arrowButtonListener);
        this._nextButton.addActionListener(arrowButtonListener);
        SingleClickListener singleClickListener = new SingleClickListener();
        this._dayPanel.getTable().getGrid().addMouseListener((MouseListener)singleClickListener);
    }

    private void _layoutComponents() {
        this.removeAll();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(this._previousButton, gridBagConstraints);
        gridBagConstraints.insets = new Insets(4, 2, 4, 2);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this._monthPanel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this._yearPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(4, 0, 4, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this._nextButton, gridBagConstraints);
        this.add(this._previousButton);
        this.add(this._monthPanel);
        this.add(this._yearPanel);
        this.add(this._nextButton);
        gridBagLayout.setConstraints(this._dayPanel, gridBagConstraints);
        this.add(this._dayPanel);
        this._dayPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("ComboBox.disabledBackground")));
        if (this._showTime) {
            if (this._editTime) {
                gridBagConstraints.insets = new Insets(0, 2, 0, 2);
                gridBagLayout.setConstraints(this._timeEditor, gridBagConstraints);
                this.add(this._timeEditor);
            } else {
                gridBagConstraints.insets = new Insets(0, 2, 4, 2);
                gridBagLayout.setConstraints(this._timeDisplay, gridBagConstraints);
                this.add(this._timeDisplay);
            }
        }
    }

    public Date[] getSelectedDates() {
        Date[] dateArray = new Date[this._selectedDays.size()];
        Calendar calendar = (Calendar)this._cal.clone();
        int n = 0;
        for (Day day : this._selectedDays) {
            Date date = day.getDate();
            if (this._showTime) {
                calendar.setTime(date);
                calendar.set(11, this._cal.get(11));
                calendar.set(12, this._cal.get(12));
                calendar.set(13, this._cal.get(13));
                calendar.setTimeZone(this._cal.getTimeZone());
                date = calendar.getTime();
            }
            dateArray[n] = date;
            ++n;
        }
        return dateArray;
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        Object[] objectArray = this.listenerList.getListenerList();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PropertyChangeListener.class) continue;
            ((PropertyChangeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
        }
    }

    public void setSelectedDate(Date date) {
        this._selectedDays.clear();
        this._selectedDays.add(new Day(date));
        Calendar calendar = (Calendar)this._cal.clone();
        calendar.setTime(date);
        this._cal.set(11, calendar.get(11));
        this._cal.set(12, calendar.get(12));
        this._cal.set(13, calendar.get(13));
        this._refreshCalendar();
    }

    public void setTimeZone(TimeZone timeZone) {
        TimeZone timeZone2 = this._timeEditor.getNearestTimeZoneMatch(timeZone);
        this._cal.setTimeZone(timeZone2);
        this._refreshCalendar();
    }

    public TimeZone getTimeZone() {
        return this._cal.getTimeZone();
    }

    public void setSelectedDates(Date[] dateArray) {
        this._selectedDays.clear();
        if (!this._isMultiSelect) {
            this._selectedDays.add(new Day(dateArray[0]));
        } else {
            for (Date date : dateArray) {
                this._selectedDays.add(new Day(date));
            }
        }
        Calendar calendar = (Calendar)this._cal.clone();
        calendar.setTime(dateArray[0]);
        this._cal.set(11, calendar.get(11));
        this._cal.set(12, calendar.get(12));
        this._cal.set(13, calendar.get(13));
        this._dayPanel.rebuild();
    }

    public void addSelectedDates(Date[] dateArray) {
        if (!this._isMultiSelect) {
            this._selectedDays.clear();
            this._selectedDays.add(new Day(dateArray[0]));
        } else {
            for (Date date : dateArray) {
                this._selectedDays.add(new Day(date));
            }
        }
        this._dayPanel.rebuild();
    }

    public void removeSelectedDates(Date[] dateArray) {
        for (Date date : dateArray) {
            this._selectedDays.remove(new Day(date));
        }
        this._dayPanel.rebuild();
    }

    public Date getVisibleDate() {
        return this._cal.getTime();
    }

    public void makeDateVisible(Date date) {
        Calendar calendar = (Calendar)this._cal.clone();
        this._cal.setTime(date);
        this._cal.set(11, calendar.get(11));
        this._cal.set(12, calendar.get(12));
        this._cal.set(13, calendar.get(13));
        this._refreshCalendar();
    }

    private void _refreshCalendar() {
        this._monthPanel.updateDisplay();
        this._yearPanel.updateDisplay();
        this._timeDisplay.updateDisplay();
        this._timeEditor.updateDisplay();
        this._dayPanel.rebuild();
    }

    public void setMinimumDate(Date date) {
        this._dayPanel.setMinimumDate(date);
    }

    public Date getMinimumDate() {
        return this._dayPanel.getMinimumDate();
    }

    public void setMaximumDate(Date date) {
        this._dayPanel.setMaximumDate(date);
    }

    public Date getMaximumDate() {
        return this._dayPanel.getMaximumDate();
    }

    public void setDateProvider(CalendarDateProvider calendarDateProvider) {
        this._dayPanel.setDateProvider(calendarDateProvider);
    }

    public CalendarDateProvider getDateProvider() {
        return this._dayPanel.getDateProvider();
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    public void setShowTime(boolean bl) {
        this._showTime = bl;
        this._timeDisplay.updateDisplay();
        this._timeEditor.updateDisplay();
        this._layoutComponents();
    }

    public boolean isShowingTime() {
        return this._showTime;
    }

    public void setEditTime(boolean bl) {
        this._editTime = bl;
        this._timeDisplay.updateDisplay();
        this._timeEditor.updateDisplay();
        this._layoutComponents();
    }

    public boolean isEditingTime() {
        return this._editTime;
    }

    public void cleanUp() {
        this._dayPanel.cleanUp();
        this._monthPanel.cleanUp();
        this._yearPanel.cleanUp();
        this._dayPanel = null;
        this._monthPanel = null;
        this._yearPanel = null;
        this._cal = null;
        this._selectedDays.clear();
        this._selectedDays = null;
    }

    public void addActionListener(ActionListener actionListener) {
        this._listener = actionListener;
    }

    private void fireDateChanged() {
        ActionEvent actionEvent = new ActionEvent(this, 1, "dateChanged");
        if (this._listener != null) {
            this._listener.actionPerformed(actionEvent);
        }
    }

    private class ArrowButtonListener
    implements ActionListener {
        private ArrowButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == CalendarPanel.this._previousButton) {
                CalendarPanel.this._cal.add(2, -1);
                CalendarPanel.this._refreshCalendar();
            } else if (actionEvent.getSource() == CalendarPanel.this._nextButton) {
                CalendarPanel.this._cal.add(2, 1);
                CalendarPanel.this._refreshCalendar();
            }
        }
    }

    private class SingleClickListener
    extends MouseAdapter {
        private SingleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                CalendarPanel.this.fireDateChanged();
            }
        }
    }

    private class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                CalendarPanel.this.fireDateChanged();
            }
        }
    }
}

