/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.util.Vector;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.BaseCostMatrixDataProvider;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;

public class BaseCostMatrixTableModel
extends SimpleBaseTableModel {
    private int rowCount;
    private Vector<String> columns;
    protected BaseCostMatrixDataProvider dataProvider;

    public BaseCostMatrixTableModel(BaseCostMatrixDataProvider baseCostMatrixDataProvider) {
        assert (baseCostMatrixDataProvider != null);
        this.dataProvider = baseCostMatrixDataProvider;
        Object[] objectArray = this.dataProvider.getTargetValues();
        this.rowCount = objectArray != null ? objectArray.length : 0;
        this.columns = new Vector();
        this.columns.add(0, DialogsLrb.get("COST_MATRIX_MATRIX_TARGET"));
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    this.columns.add("");
                    continue;
                }
                this.columns.add(objectArray[i].toString());
            }
        }
        this.setColumnIdentifiers(this.columns);
        this.setRowCount(this.rowCount);
        this.setColumnCount(objectArray != null ? objectArray.length + 1 : 1);
    }

    protected boolean isDiagonalCell(int n, int n2) {
        return n == BaseCostMatrixTableModel.getDataColumnNumber(n2);
    }

    public void setColumn0Header(String string) {
        if (string == null) {
            this.columns.remove(0);
            this.columns.add(0, "");
        } else {
            this.columns.remove(0);
            this.columns.add(0, string);
        }
    }

    public Object getValueAt(int n, int n2) {
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        if (n2 == 0) {
            Object[] objectArray = this.dataProvider.getTargetValues();
            return objectArray != null && objectArray.length > 0 && objectArray[n] != null ? objectArray[n].toString() : "";
        }
        return this.dataProvider.getValueAt(n, BaseCostMatrixTableModel.getDataColumnNumber(n2));
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        this.dataProvider.setValueAt(object, n, BaseCostMatrixTableModel.getDataColumnNumber(n2));
    }

    static int getDataColumnNumber(int n) {
        return n - 1;
    }
}

