/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.DataMinerViewListener;
import oracle.dmt.dataminer.DataMinerViewStatus;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.javatools.ui.BlockingComponent;

public abstract class DataMinerViewGUI
extends JPanel {
    private Context context;
    private Editor editor;
    protected BlockingComponent overLayPanel;
    private DataMinerViewStatus viewStatus;
    private List<DataMinerViewListener> listeners;

    public DataMinerViewGUI(Editor editor, Context context) {
        this.context = context;
        this.editor = editor;
        this.listeners = new ArrayList<DataMinerViewListener>();
        this.viewStatus = DataMinerViewStatus.BUSY;
    }

    public final Context getContext() {
        return this.context;
    }

    public final void setContext(Context context) {
        this.context = context;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public boolean isLoaded() {
        return this.viewStatus == DataMinerViewStatus.READY;
    }

    protected void setLoaded(boolean bl) {
        if (bl) {
            this.viewStatus = DataMinerViewStatus.READY;
            this.fireViewReady(new DataMinerViewEvent(this, "VIEW_READY", null));
        } else {
            this.viewStatus = DataMinerViewStatus.BUSY;
            this.fireViewBusy(new DataMinerViewEvent(this, "VIEW_BUSY", null));
        }
    }

    public DataMinerViewStatus getViewStatus() {
        return this.viewStatus;
    }

    protected void setViewStatus(DataMinerViewStatus dataMinerViewStatus) {
        assert (dataMinerViewStatus != null) : "DataMinerViewStatus can not be set to null";
        if (dataMinerViewStatus == DataMinerViewStatus.BUSY) {
            this.setLoading(true);
        } else {
            this.setLoading(false);
        }
    }

    public boolean isLoading() {
        return this.viewStatus == DataMinerViewStatus.BUSY;
    }

    protected void setLoading(boolean bl) {
        if (bl) {
            this.viewStatus = DataMinerViewStatus.BUSY;
            this.fireViewBusy(new DataMinerViewEvent(this, "VIEW_BUSY", null));
        } else {
            this.viewStatus = DataMinerViewStatus.READY;
            this.fireViewReady(new DataMinerViewEvent(this, "VIEW_READY", null));
        }
    }

    public void addDataMinerViewListener(DataMinerViewListener dataMinerViewListener) {
        this.listeners.add(dataMinerViewListener);
    }

    public void removeDataMinerViewListener(DataMinerViewListener dataMinerViewListener) {
        this.listeners.remove(dataMinerViewListener);
    }

    public void fireViewReady(DataMinerViewEvent dataMinerViewEvent) {
        this.fireEvent(new DataMinerViewListenerHandler(){

            @Override
            public void handle(DataMinerViewListener dataMinerViewListener, DataMinerViewEvent dataMinerViewEvent) {
                dataMinerViewListener.viewReady(dataMinerViewEvent);
            }
        }, dataMinerViewEvent);
    }

    public void fireViewBusy(DataMinerViewEvent dataMinerViewEvent) {
        this.fireEvent(new DataMinerViewListenerHandler(){

            @Override
            public void handle(DataMinerViewListener dataMinerViewListener, DataMinerViewEvent dataMinerViewEvent) {
                dataMinerViewListener.viewBusy(dataMinerViewEvent);
            }
        }, dataMinerViewEvent);
    }

    public void fireViewPropertySelectionChange(Object object, Object object2) {
        this.fireViewPropertySelectionChange(new DataMinerViewEvent(this, "PROPERTY_SELECTION_EVENT", object2));
    }

    public void fireViewPropertySelectionChange(DataMinerViewEvent dataMinerViewEvent) {
        this.fireEvent(new DataMinerViewListenerHandler(){

            @Override
            public void handle(DataMinerViewListener dataMinerViewListener, DataMinerViewEvent dataMinerViewEvent) {
                dataMinerViewListener.viewPropertySelectionChange(dataMinerViewEvent);
            }
        }, dataMinerViewEvent);
    }

    private void fireEvent(DataMinerViewListenerHandler dataMinerViewListenerHandler, DataMinerViewEvent dataMinerViewEvent) {
        List<DataMinerViewListener> list = this.cloneToAvoidConcurrentModificationException(this.listeners);
        for (DataMinerViewListener dataMinerViewListener : list) {
            dataMinerViewListenerHandler.handle(dataMinerViewListener, dataMinerViewEvent);
        }
    }

    private List<DataMinerViewListener> cloneToAvoidConcurrentModificationException(List<DataMinerViewListener> list) {
        return (List)((ArrayList)list).clone();
    }

    public void load() {
    }

    public void reload() {
        this.load();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public HelpInfo getHelpInfo() {
        return null;
    }

    private static interface DataMinerViewListenerHandler {
        public void handle(DataMinerViewListener var1, DataMinerViewEvent var2);
    }
}

