/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.ceditor.saveactions;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ElementName;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class SaveActionsShapingHook {
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/customization", "ceditor-saveactions-shaping");
    private static List<SaveActionShaper> actionShapers = new CopyOnWriteArrayList<SaveActionShaper>();
    private static HashStructureHookListener listener;

    static Map<String, SaveActionShaper> getActionShapers() {
        if (listener == null) {
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            HashStructureHook hook = (HashStructureHook)registry.getHook(NAME);
            listener = new SaveActionsShapingListener();
            hook.addHashStructureHookListener(listener);
        }
        LinkedHashMap<String, SaveActionShaper> shapers = new LinkedHashMap<String, SaveActionShaper>(actionShapers.size());
        for (SaveActionShaper shaper : actionShapers) {
            shapers.put(shaper.getId(), shaper);
        }
        return shapers;
    }

    static class SaveActionShaper
    extends HashStructureAdapter {
        private SaveActionShaper(HashStructure hash) {
            super(hash);
        }

        String getId() {
            return this._hash.getString("id");
        }

        boolean executeByDefault() {
            return this._hash.getBoolean("execute-by-default", false);
        }
    }

    private static class SaveActionsShapingListener
    implements HashStructureHookListener {
        private SaveActionsShapingListener() {
        }

        public void elementVisited(HashStructureHookEvent e) {
            this.addShapers(e.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent e) {
            this.addShapers(e.getCombinedHashStructure());
        }

        private void addShapers(HashStructure hash) {
            List shaperStructures = hash.getAsList("saveaction");
            if (shaperStructures != null) {
                for (Object shaperStructure : shaperStructures) {
                    actionShapers.add(new SaveActionShaper((HashStructure)shaperStructure));
                }
            }
        }
    }
}

