/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.saveactions;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.ceditor.saveactions.Bundle;
import oracle.ide.ceditor.saveactions.SaveActionsOptionsPanel;
import oracle.ide.help.HelpSystem;
import oracle.ideimpl.ceditor.saveactions.SaveActionDescription;
import oracle.javatools.ui.builders.BuiltList;
import oracle.javatools.ui.builders.ListBuilder;

final class AddActionsDialog
extends JEWTDialog {
    private BuiltList<SaveActionDescription> lc;
    private SaveActionsOptionsPanel.ActionRenderer actionRenderer = new SaveActionsOptionsPanel.ActionRenderer();

    AddActionsDialog(List<SaveActionDescription> usedActions, List<SaveActionDescription> unusedActions) {
        super((Frame)Ide.getMainWindow(), Bundle.get("SAVE_ACTIONS_SELECT_TITLE"), 7);
        this.init(usedActions, unusedActions);
    }

    private void init(List<SaveActionDescription> usedActions, List<SaveActionDescription> unusedActions) {
        Collections.sort(unusedActions, new ActionComparator());
        ActionListener doubleClickAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window w = SwingUtilities.windowForComponent(AddActionsDialog.this.lc.getJList());
                if (w instanceof JEWTDialog) {
                    ((JEWTDialog)w).closeDialog(false);
                }
            }
        };
        ListBuilder builder = new ListBuilder();
        builder.setModel(unusedActions);
        builder.setSelectionMode(2);
        builder.setRenderer((ListCellRenderer)this.actionRenderer);
        builder.setRollover(true);
        builder.setEmptyText(Bundle.get("SAVE_ACTIONS_EMPTY_LIST"));
        builder.setLabel(Bundle.get("SAVE_ACTIONS_INSTRUCTIONS"));
        builder.setDoubleClickListener(doubleClickAction);
        this.lc = builder.build();
        this.lc.getJList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AddActionsDialog.this.setOKButtonEnabled(AddActionsDialog.this.lc.getSelectedValue() != null);
            }
        });
        this.setOKButtonEnabled(this.lc.getJList().getSelectedIndex() != -1);
        this.setResizable(true);
        this.pack();
        Dimension d = this.getPreferredSize();
        this.setMinimumSize(Math.max(325, d.width), Math.max(200, d.height));
        this.setContent(this.lc.getGUI());
        HelpSystem.getHelpSystem().registerTopic(this.lc.getGUI(), "f1_idedidesetselectactions_html");
    }

    public List<SaveActionDescription> getSelectedActions() {
        return this.lc.getSelectedValues();
    }

    private class ActionComparator
    implements Comparator<SaveActionDescription> {
        private ActionComparator() {
        }

        @Override
        public int compare(SaveActionDescription o1, SaveActionDescription o2) {
            if (o1 == o2) {
                return 0;
            }
            return o1.getId().compareTo(o2.getId());
        }
    }
}

