/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.sqlsource;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.metrics.engine.BooleanType;
import oracle.dbtools.raptor.metrics.engine.ParameterType;
import oracle.dbtools.raptor.metrics.engine.ParameterTypes;
import oracle.dbtools.raptor.metrics.engine.SourceType;
import oracle.dbtools.raptor.metrics.engine.StringType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLJobType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLOperationType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLSourceInstance;

public class SQLSourceType
extends SourceType {
    public static final String PARAMETER_DATABASE = "database";
    public static final String PARAMETER_NO_CONNECTION = "noConnection";
    private final Map<String, SQLJobType> jobTypeMap;
    private final Map<String, SQLOperationType> operationTypeMap;
    private final ParameterTypes parameterTypes;

    public SQLSourceType() {
        super("DbSql", 5.0, 1);
        HashSet<ParameterType> hashSet = new HashSet<ParameterType>();
        hashSet.add(new ParameterType(PARAMETER_DATABASE, new StringType(), null));
        hashSet.add(new ParameterType(PARAMETER_NO_CONNECTION, new BooleanType(), false));
        this.parameterTypes = new ParameterTypes(hashSet);
        this.jobTypeMap = new HashMap<String, SQLJobType>();
        this.operationTypeMap = new HashMap<String, SQLOperationType>();
    }

    @Override
    public String getConnectionTypeName() {
        return "sql";
    }

    public Map<String, SQLJobType> jobTypeMap() {
        return this.jobTypeMap;
    }

    public Map<String, SQLOperationType> operationTypeMap() {
        return this.operationTypeMap;
    }

    @Override
    protected SQLSourceInstance createSource(String string, Map<String, String> map) {
        return new SQLSourceInstance(this, string, map);
    }

    @Override
    protected ParameterTypes getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    protected void mergeJobTypes(SourceType.MergeContext mergeContext) {
        SQLJobType sQLJobType;
        SQLSourceType sQLSourceType = (SQLSourceType)mergeContext.getSourceType();
        for (String string : sQLSourceType.jobTypeMap().keySet()) {
            sQLJobType = sQLSourceType.jobTypeMap().get(string);
            this.jobTypeMap.put(string, sQLJobType);
        }
        for (String string : sQLSourceType.jobTypeMap().keySet()) {
            sQLJobType = sQLSourceType.jobTypeMap().get(string);
            sQLJobType.onMerge(this);
        }
        super.mergeJobTypes(mergeContext);
    }

    @Override
    protected void mergeOperationTypes(SourceType.MergeContext mergeContext) {
        SQLOperationType sQLOperationType;
        SQLSourceType sQLSourceType = (SQLSourceType)mergeContext.getSourceType();
        for (String string : sQLSourceType.operationTypeMap().keySet()) {
            sQLOperationType = sQLSourceType.operationTypeMap().get(string);
            this.operationTypeMap.put(string, sQLOperationType);
        }
        for (String string : sQLSourceType.operationTypeMap().keySet()) {
            sQLOperationType = sQLSourceType.operationTypeMap().get(string);
            sQLOperationType.onMerge(this);
        }
        super.mergeOperationTypes(mergeContext);
    }

    void setJobTypes(List<SQLJobType> list) {
        for (SQLJobType sQLJobType : list) {
            this.jobTypeMap.put(sQLJobType.getPath(), sQLJobType);
        }
    }

    void setOperationTypes(List<SQLOperationType> list) {
        for (SQLOperationType sQLOperationType : list) {
            this.operationTypeMap.put(sQLOperationType.getPath(), sQLOperationType);
        }
    }
}

