/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.sqlsource;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.query.Query;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SQLResource {
    private Map<String, List<Query>> queriesMap;
    private final StringProperty nameProperty = new SimpleStringProperty((Object)this, "name");
    private final StringProperty pathProperty = new SimpleStringProperty((Object)this, "path");

    public String getName() {
        return (String)this.nameProperty.get();
    }

    public void setName(String string) {
        this.nameProperty.set((Object)string);
    }

    public StringProperty nameProperty() {
        return this.nameProperty;
    }

    public String getPath() {
        return (String)this.pathProperty.get();
    }

    public void setPath(String string) {
        this.pathProperty.set((Object)string);
    }

    public StringProperty pathProperty() {
        return this.pathProperty;
    }

    String getSql(ClassLoader classLoader, String string, Version version, Version version2) {
        if (this.queriesMap == null) {
            this.queriesMap = this.loadQueriesMap(classLoader);
        }
        List<Query> list = this.queriesMap.get(string);
        for (Query query : list) {
            Version version3 = query.getMinversion();
            Version version4 = query.getMaxversion();
            if (version3 != null && version3.compareTo(version) > 0 || version4 != null && version4.compareTo(version2) < 0) continue;
            return query.getSql();
        }
        return "";
    }

    List<Query> getQueries(ClassLoader classLoader, String string) {
        if (this.queriesMap == null) {
            this.queriesMap = this.loadQueriesMap(classLoader);
        }
        return this.queriesMap.get(string);
    }

    private Map<String, List<Query>> loadQueriesMap(ClassLoader classLoader) {
        HashMap<String, List<Query>> hashMap = new HashMap<String, List<Query>>();
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse(classLoader.getResourceAsStream(this.getPath()));
            XMLDocument xMLDocument = dOMParser.getDocument();
            Element element = xMLDocument.getDocumentElement();
            if (element != null) {
                NodeList nodeList = element.getElementsByTagName("queryType");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element2 = (Element)nodeList.item(i);
                    String string = element2.getAttribute("id");
                    NodeList nodeList2 = element2.getElementsByTagName("queries");
                    if (nodeList2.getLength() <= 0) continue;
                    List list = Query.getQueries((Node)((XMLNode)nodeList2.item(0)));
                    hashMap.put(string, list);
                }
            }
        }
        catch (IOException | SAXException exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return hashMap;
    }
}

