/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.sqlsource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.OperationInstance;
import oracle.dbtools.raptor.metrics.listener.DXOperationCallback;
import oracle.dbtools.raptor.metrics.sqlsource.SQLConnections;
import oracle.dbtools.raptor.metrics.sqlsource.SQLOperationType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLSourceInstance;
import oracle.dbtools.raptor.query.Query;

public class SQLOperationInstance
extends OperationInstance {
    private final SQLOperationType operationType;
    private final SQLSourceInstance source;
    private volatile Thread invokeThread;
    private static final int ORACLE_STATEMENT_CANCELED = 1013;

    SQLOperationInstance(SQLOperationType sQLOperationType, SQLSourceInstance sQLSourceInstance, Map<String, String> map, DXOperationCallback dXOperationCallback) {
        super(sQLOperationType, sQLSourceInstance, map, dXOperationCallback);
        this.operationType = sQLOperationType;
        this.source = sQLSourceInstance;
    }

    @Override
    public SQLOperationType getRunnableType() {
        return this.operationType;
    }

    @Override
    public SQLSourceInstance getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invoke(Map<String, Object> map) {
        block9: {
            Connection connection = this.source.acquireJDBCConnection();
            if (connection == null) {
                throw new DXException("SQLSource connection not available");
            }
            try {
                if (!SQLConnections.lock(connection)) break block9;
                try {
                    String string = this.getSQL(connection);
                    if (string != null) {
                        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                        dBUtil.setRaiseError(false);
                        this.invokeThread = Thread.currentThread();
                        dBUtil.execute(string, map);
                        SQLException sQLException = dBUtil.getLastException();
                        if (!(sQLException == null || sQLException.getErrorCode() == 1013 && this.isRunCanceled())) {
                            throw new DXException("SQLJob query error", sQLException);
                        }
                    }
                }
                finally {
                    SQLConnections.unlock(connection);
                }
            }
            finally {
                this.source.releaseJDBCConnection(connection);
            }
        }
    }

    @Override
    protected boolean cancel() {
        boolean bl = false;
        Thread thread = this.invokeThread;
        if (thread != null) {
            DBUtil.cancelExecution((Thread)thread);
            bl = true;
        }
        return bl;
    }

    private String getSQL(Connection connection) {
        Query query = this.operationType.getQueries().getQuery(DefaultConnectionIdentifier.createIdentifier((Connection)connection));
        return query.getSql();
    }
}

