/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Map;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.panel.Formatter;

class DurationFormatter
extends Formatter {
    DurationFormatter() {
    }

    @Override
    protected String formatImpl(String string, Map<String, String> map, Object ... objectArray) {
        Duration duration;
        if (objectArray.length != 1) {
            throw new IllegalArgumentException();
        }
        if (objectArray[0] instanceof Duration) {
            duration = (Duration)objectArray[0];
        } else if (objectArray[0] instanceof Double) {
            duration = new Duration(((Double)objectArray[0]).doubleValue());
        } else {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        block11: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case 'D': {
                    long l = (long)duration.toHours() / 24L;
                    stringBuilder.append(l);
                    continue block11;
                }
                case 'H': {
                    long l = (long)duration.toHours();
                    stringBuilder.append(l);
                    continue block11;
                }
                case 'M': {
                    long l = (long)duration.toMinutes();
                    stringBuilder.append(l);
                    continue block11;
                }
                case 'S': {
                    long l = (long)duration.toSeconds();
                    stringBuilder.append(l);
                    continue block11;
                }
                case 'F': {
                    long l = (long)duration.toMillis();
                    stringBuilder.append(l);
                    continue block11;
                }
                case 'h': {
                    long l = Math.floorMod((long)duration.toHours(), 24L);
                    if (l < 10L) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(l);
                    continue block11;
                }
                case 'm': {
                    long l = Math.floorMod((long)duration.toMinutes(), 60L);
                    if (l < 10L) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(l);
                    continue block11;
                }
                case 's': {
                    long l = Math.floorMod((long)duration.toSeconds(), 60L);
                    if (l < 10L) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(l);
                    continue block11;
                }
                case 'f': {
                    long l = Math.floorMod((long)duration.toMillis(), 1000L);
                    stringBuilder.append(l);
                    continue block11;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

