/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.item;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.engine.DataMap;
import oracle.dbtools.raptor.metrics.engine.ItemInstance;
import oracle.dbtools.raptor.metrics.engine.ValueConverter;
import oracle.dbtools.raptor.metrics.item.TableItemType;
import oracle.dbtools.raptor.metrics.item.TableValue;
import oracle.dbtools.raptor.metrics.listener.DXTableChanges;

class TableItemInstance
extends ItemInstance {
    private final TableItemType itemType;
    private Map<DXTableChanges.Key, DXTableChanges.Row> rowMap;
    private DXTableChanges tableChanges;

    TableItemInstance(TableItemType tableItemType, URI uRI) {
        super(uRI);
        this.itemType = tableItemType;
    }

    @Override
    public TableItemType getItemType() {
        return this.itemType;
    }

    @Override
    protected DXTableChanges getChangeObject() {
        ArrayList<DXTableChanges.Row> arrayList = this.rowMap != null ? new ArrayList<DXTableChanges.Row>(this.rowMap.values()) : new ArrayList();
        List<DXTableChanges.Row> list = Collections.emptyList();
        List<DXTableChanges.Key> list2 = Collections.emptyList();
        return new DXTableChanges(arrayList, list, list2);
    }

    @Override
    protected DXTableChanges getIncrementalChangeObject() {
        return this.tableChanges;
    }

    @Override
    protected void update(ValueConverter valueConverter, DataMap dataMap) {
        DataMap dataMap2 = dataMap.getDataMap(this.getItemType().getMapTo());
        if (dataMap2 != null) {
            boolean bl;
            if (this.rowMap == null) {
                this.rowMap = Collections.emptyMap();
                bl = true;
            } else {
                bl = false;
            }
            Map<DXTableChanges.Key, DXTableChanges.Row> map = this.rowMap;
            HashMap<DXTableChanges.Key, DXTableChanges.Row> hashMap = new HashMap<DXTableChanges.Key, DXTableChanges.Row>();
            ArrayList<DXTableChanges.Row> arrayList = new ArrayList<DXTableChanges.Row>();
            ArrayList<DXTableChanges.Row> arrayList2 = new ArrayList<DXTableChanges.Row>();
            ArrayList<DXTableChanges.Key> arrayList3 = new ArrayList<DXTableChanges.Key>();
            List<DXTableChanges.Key> list = this.getRowKeys(valueConverter, dataMap2);
            int n = 0;
            for (DXTableChanges.Key object : list) {
                DXTableChanges.Row row = map.get(object);
                if (row == null) {
                    DXTableChanges.Row row2 = this.createNewRow(valueConverter, object, dataMap2, n);
                    arrayList.add(row2);
                    hashMap.put(object, row2);
                    bl = true;
                } else {
                    boolean bl2 = false;
                    for (TableValue tableValue : this.itemType.getTableValues()) {
                        String string = tableValue.getName();
                        List<Object> list2 = dataMap2.getColumnValue(tableValue.getMapTo());
                        Comparable<?> comparable = this.rawToGeneric(tableValue, valueConverter, list2.get(n));
                        if (Objects.equals(row.getCellValue(string, Object.class), comparable)) continue;
                        bl2 = true;
                    }
                    if (bl2) {
                        DXTableChanges.Row row3 = this.createNewRow(valueConverter, object, dataMap2, n);
                        arrayList2.add(row3);
                        hashMap.put(object, row3);
                        bl = true;
                    } else {
                        hashMap.put(object, row);
                    }
                }
                ++n;
            }
            HashSet<DXTableChanges.Key> hashSet = new HashSet<DXTableChanges.Key>(list);
            for (DXTableChanges.Key key : map.keySet()) {
                if (hashSet.contains(key)) continue;
                arrayList3.add(key);
                bl = true;
            }
            if (bl) {
                this.tableChanges = new DXTableChanges(arrayList, arrayList2, arrayList3);
                this.markChanged();
            } else {
                this.tableChanges = null;
            }
            this.rowMap = hashMap;
        } else {
            this.getLogger().log(Level.WARNING, "No data array found for column ''{0}''", new Object[]{this.getItemType().getMapTo()});
        }
    }

    private List<DXTableChanges.Key> getRowKeys(ValueConverter valueConverter, DataMap dataMap) {
        ArrayList<DXTableChanges.Key> arrayList = new ArrayList<DXTableChanges.Key>();
        List<TableValue> list = this.itemType.getKeyValues();
        List<Object> list2 = dataMap.getColumnValue(list.get(0).getMapTo());
        if (list2 == null) {
            this.getLogger().log(Level.WARNING, "No data array found for key column ''{0}''", new Object[]{list.get(0).getMapTo()});
        } else {
            int n = list2.size();
            ArrayList<DXTableChanges.Key> arrayList2 = new ArrayList<DXTableChanges.Key>();
            for (int i = 0; i < n; ++i) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                for (TableValue tableValue : this.itemType.getKeyValues()) {
                    List<Object> list3 = dataMap.getColumnValue(tableValue.getMapTo());
                    if (list3 != null) {
                        hashMap.put(tableValue.getName(), this.rawToGeneric(tableValue, valueConverter, list3.get(i)));
                        continue;
                    }
                    this.getLogger().log(Level.WARNING, "No data array found for column ''{0}''", new Object[]{tableValue.getMapTo()});
                    arrayList2 = null;
                    break;
                }
                if (arrayList2 == null) break;
                arrayList2.add(new DXTableChanges.Key(this.itemType, hashMap));
            }
            if (arrayList2 != null) {
                arrayList.addAll(arrayList2);
            }
        }
        return arrayList;
    }

    private DXTableChanges.Row createNewRow(ValueConverter valueConverter, DXTableChanges.Key key, DataMap dataMap, int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (TableValue tableValue : this.itemType.getTableValues()) {
            String string = tableValue.getName();
            List<Object> list = dataMap.getColumnValue(tableValue.getMapTo());
            if (list != null) {
                hashMap.put(string, this.rawToGeneric(tableValue, valueConverter, list.get(n)));
                continue;
            }
            hashMap.put(string, null);
        }
        return new DXTableChanges.Row(key, hashMap);
    }

    private Comparable<?> rawToGeneric(TableValue tableValue, ValueConverter valueConverter, Object object) {
        Object obj;
        try {
            obj = tableValue.getValueType().rawToGeneric(valueConverter, object);
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "unable to convert data '" + object + "' for table item '" + this.getPath() + "' column '" + tableValue.getName() + "'", runtimeException);
            obj = null;
        }
        return obj;
    }
}

