/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.generation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import oracle.dbtools.raptor.metrics.generation.AbstractGenerationElement;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.GenerationResult;

public class SupportFile
extends AbstractGenerationElement {
    private final StringProperty resourceProperty = new SimpleStringProperty((Object)this, "resource");
    private final StringProperty fileNameProperty = new SimpleStringProperty((Object)this, "fileName");

    public String getResource() {
        return (String)this.resourceProperty.get();
    }

    public void setResource(String string) {
        this.resourceProperty.set((Object)string);
    }

    public StringProperty resourceProperty() {
        return this.resourceProperty;
    }

    public String getFileName() {
        return (String)this.fileNameProperty.get();
    }

    public void setFileName(String string) {
        this.fileNameProperty.set((Object)string);
    }

    public StringProperty fileNameProperty() {
        return this.fileNameProperty;
    }

    @Override
    boolean isSynchronous() {
        return true;
    }

    @Override
    void generate(Consumer<GenerationResult> consumer) {
        String string = this.getGenerationSettings().getAttributes().get(String.class, "FilePath");
        if (string == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "'FilePath' must be specified when calling SupportFile");
            return;
        }
        File file = new File(string);
        File file2 = new File(file.getParentFile(), this.getFileName());
        File file3 = file2.getParentFile();
        file3.mkdir();
        String string2 = this.getResource();
        Context context = this.getGenerationSettings().getContext();
        String string3 = context.getAbsoluteResourcePath(string2);
        try (InputStream inputStream = context.getClassLoader().getResourceAsStream(string3);
             FileWriter fileWriter = new FileWriter(file2);){
            int n = inputStream.read();
            while (n >= 0) {
                fileWriter.append((char)n);
                n = inputStream.read();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, iOException);
        }
        consumer.accept(new GenerationResult(true, ""));
    }
}

