/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.generation;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import oracle.dbtools.raptor.metrics.generation.AbstractGenerationElement;
import oracle.dbtools.raptor.metrics.generation.GenerationSettings;
import oracle.dbtools.raptor.metrics.panel.GenerationResult;

public class AbstractGenerationObject {
    boolean isAggregateSynchronous(List<? extends AbstractGenerationElement> list) {
        for (AbstractGenerationElement abstractGenerationElement : list) {
            if (abstractGenerationElement.isSynchronous()) continue;
            return false;
        }
        return true;
    }

    void aggregateGenerate(List<AbstractGenerationElement> list, GenerationSettings generationSettings, Map<String, Object> map, Consumer<GenerationResult> consumer) {
        GenerationResult[] generationResultArray = new GenerationResult[list.size()];
        if (list.isEmpty()) {
            consumer.accept(new GenerationResult(true, ""));
        } else {
            int n = 0;
            int[] nArray = new int[]{generationResultArray.length};
            for (AbstractGenerationElement abstractGenerationElement : list) {
                int n2 = n++;
                abstractGenerationElement.reset(generationSettings, map);
                abstractGenerationElement.generate(generationResult -> {
                    generationResultArray[n] = generationResult;
                    nArray[0] = nArray[0] - 1;
                    if (nArray[0] == 0) {
                        consumer.accept(this.aggregateGenerationResults(generationResultArray));
                    }
                });
            }
        }
    }

    GenerationResult aggregateGenerationResults(GenerationResult[] generationResultArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (GenerationResult generationResult : generationResultArray) {
            if (!generationResult.isSuccessful()) {
                return generationResult;
            }
            stringBuilder.append(generationResult.getText());
        }
        return new GenerationResult(true, stringBuilder.toString());
    }
}

