/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import javafx.beans.DefaultProperty;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Tooltip;
import oracle.dbtools.raptor.metrics.facet.Augmentor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.Facet;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;
import oracle.dbtools.raptor.metrics.panel.StringDataObject;

@DefaultProperty(value="textItem")
public class TooltipTray
implements Augmentor {
    private final ObjectProperty<StringDataObject> textItemProperty = new SimpleObjectProperty();
    private final ObjectProperty<Tooltip> tooltipProperty = new SimpleObjectProperty();

    public TooltipTray() {
        this.init(new Listener());
    }

    public StringDataObject getTextItem() {
        return (StringDataObject)this.textItemProperty.get();
    }

    public void setTextItem(StringDataObject stringDataObject) {
        this.textItemProperty.set((Object)stringDataObject);
    }

    public ObjectProperty<StringDataObject> textItemProperty() {
        return this.textItemProperty;
    }

    public Tooltip getTooltip() {
        return (Tooltip)this.tooltipProperty.get();
    }

    public void setTooltip(Tooltip tooltip) {
        this.tooltipProperty.set((Object)tooltip);
    }

    public ObjectProperty<Tooltip> tooltipProperty() {
        return this.tooltipProperty;
    }

    @Override
    public Class<?> getBindToClass() {
        return Node.class;
    }

    @Override
    public Class<? extends Facet> getBindAsClass() {
        return TooltipTray.class;
    }

    private void monitorText(Tooltip tooltip) {
        StringExpression stringExpression = this.getTextItem().valueProperty();
        tooltip.setText((String)stringExpression.get());
        stringExpression.addListener((observableValue, string, string2) -> tooltip.setText(string2));
    }

    protected class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onOpen(Context context) {
            Node node = context.getLinkedTarget(Node.class, TooltipTray.this);
            Tooltip tooltip = TooltipTray.this.getTooltip();
            if (tooltip == null) {
                tooltip = new Tooltip();
            }
            if (node instanceof Control) {
                ((Control)node).setTooltip(tooltip);
            } else {
                Tooltip.install((Node)node, (Tooltip)tooltip);
            }
            TooltipTray.this.monitorText(tooltip);
        }
    }
}

