/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import oracle.dbtools.raptor.metrics.facet.AbstractCellFactory;
import oracle.dbtools.raptor.metrics.observable.DXRow;

public abstract class TableCellFactory<L extends TableCell<DXRow, ?>>
extends AbstractCellFactory<TableColumn<DXRow, Object>, L> {
    private final Map<Integer, L> cellMap = new WeakHashMap<Integer, L>();

    @Override
    protected DXRow getRow(L l) {
        int n = l.getIndex();
        if (n >= 0 && n < l.getTableView().getItems().size()) {
            return (DXRow)l.getTableView().getItems().get(n);
        }
        return null;
    }

    @Override
    protected int getRowIndex(L l) {
        return l.getTableRow().getIndex();
    }

    @Override
    protected int getSelectedIndex(L l) {
        return l.getTableView().getSelectionModel().getSelectedIndex();
    }

    @Override
    protected L getCell(int n) {
        return (L)((TableCell)this.cellMap.get(n));
    }

    @Override
    protected void initCell(L l) {
        ChangeListener changeListener = (observableValue, number, number2) -> this.updateCellMap(l, (Number)number, (Number)number2);
        l.tableRowProperty().addListener((observableValue, tableRow, tableRow2) -> {
            Integer n = null;
            Integer n2 = null;
            if (tableRow != null) {
                n = tableRow.getIndex();
                tableRow.indexProperty().removeListener(changeListener);
            }
            if (tableRow2 != null) {
                n2 = tableRow2.getIndex();
                tableRow2.indexProperty().addListener(changeListener);
            }
            this.updateCellMap(l, n, n2);
        });
    }

    private void updateCellMap(L l, Number number, Number number2) {
        int n;
        int n2 = number != null ? number.intValue() : -1;
        int n3 = n = number2 != null ? number2.intValue() : -1;
        if (n2 != n) {
            if (n2 >= 0) {
                this.cellMap.remove(n2);
            }
            if (n >= 0) {
                this.cellMap.put(n, l);
            }
        }
    }
}

