/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;
import oracle.dbtools.raptor.metrics.facet.AbstractContent;
import oracle.dbtools.raptor.metrics.facet.Monitor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;

public class TabPaneMonitor
implements Monitor {
    private ChangeListener<Tab> selectionListener;
    private final BooleanProperty stopOnDeselectProperty = new SimpleBooleanProperty((Object)this, "stopOnDeselect", false);

    public TabPaneMonitor() {
        this.init(new Listener());
    }

    public boolean isStopOnDeselect() {
        return this.stopOnDeselectProperty.get();
    }

    public void setStopOnDeselect(boolean bl) {
        this.stopOnDeselectProperty.set(bl);
    }

    public BooleanProperty stopOnDeselectProperty() {
        return this.stopOnDeselectProperty;
    }

    @Override
    public Class<?> getBindToClass() {
        return TabPane.class;
    }

    protected class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onOpen(Context context) {
            TabPaneMonitor.this.selectionListener = (observableValue, tab, tab2) -> {
                AbstractContent abstractContent;
                if (TabPaneMonitor.this.isStopOnDeselect() && tab != null && (abstractContent = context.getLinkedSource(AbstractContent.class, tab)) != null) {
                    abstractContent.onHide();
                }
                if (tab2 != null && (abstractContent = context.getLinkedSource(AbstractContent.class, tab2)) != null) {
                    if (tab2.getContent() == null) {
                        tab2.setContent(abstractContent.getContentPanel());
                    }
                    abstractContent.onShow();
                }
            };
            TabPane tabPane = context.getLinkedTarget(TabPane.class, TabPaneMonitor.this);
            SingleSelectionModel singleSelectionModel = tabPane.getSelectionModel();
            singleSelectionModel.selectedItemProperty().addListener(TabPaneMonitor.this.selectionListener);
        }

        @Override
        public void onStart(Context context, DXListenerList dXListenerList) {
            Platform.runLater(() -> {
                TabPane tabPane = context.getLinkedTarget(TabPane.class, TabPaneMonitor.this);
                SingleSelectionModel singleSelectionModel = tabPane.getSelectionModel();
                int n = singleSelectionModel.getSelectedIndex();
                singleSelectionModel.clearSelection();
                singleSelectionModel.select(n);
            });
        }

        @Override
        public void onStop(Context context, DXListenerList dXListenerList) {
            TabPane tabPane = context.getLinkedTarget(TabPane.class, TabPaneMonitor.this);
            for (Tab tab : tabPane.getTabs()) {
                AbstractContent abstractContent = context.getLinkedSource(AbstractContent.class, tab);
                if (abstractContent == null) continue;
                abstractContent.onHide();
            }
        }
    }
}

