/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import oracle.dbtools.raptor.metrics.facet.AbstractBinding;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.Context;

public class RowColumnBinding
extends AbstractBinding {
    private final StringProperty colNameProperty = new SimpleStringProperty();
    private Property<Object> property;
    private ReadOnlyObjectProperty<DXRow> sourceRowProperty;
    private String colName;
    private InvalidationListener rowListener;

    public RowColumnBinding() {
        this.init(new Listener());
    }

    public String getColName() {
        return (String)this.colNameProperty.get();
    }

    public void setColName(String string) {
        this.colNameProperty.set((Object)string);
    }

    public StringProperty colNameProperty() {
        return this.colNameProperty;
    }

    @Override
    protected boolean resolveProperties(Context context) {
        this.property = (Property)this.resolveObservable(this.getObject(), this.getProperty());
        this.sourceRowProperty = (ReadOnlyObjectProperty)this.resolveObservable(this.getSourceObject(), this.getSourceProperty());
        this.colName = this.getColName();
        return this.property != null && this.sourceRowProperty != null && this.colName != null;
    }

    @Override
    protected void bind() {
        this.rowListener = observable -> this.bindColumn();
        this.bindColumn();
        this.sourceRowProperty.addListener(this.rowListener);
    }

    @Override
    protected void unbind() {
        if (this.rowListener != null) {
            if (this.property.isBound()) {
                this.property.unbind();
            }
            this.sourceRowProperty.removeListener(this.rowListener);
            this.rowListener = null;
        }
    }

    private void bindColumn() {
        DXRow dXRow;
        if (this.property.isBound()) {
            this.property.unbind();
        }
        if ((dXRow = (DXRow)this.sourceRowProperty.get()) != null) {
            ObjectProperty<Comparable<?>> objectProperty = dXRow.get(this.colName);
            this.property.bind(objectProperty);
        }
    }

    protected class Listener
    extends AbstractBinding.Listener {
        protected Listener() {
        }
    }
}

